/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.IO;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.IO.DirectoryInfo;
import com.aspose.html.utils.ms.System.IO.DirectoryNotFoundException;
import com.aspose.html.utils.ms.System.IO.File;
import com.aspose.html.utils.ms.System.IO.IOException;
import com.aspose.html.utils.ms.System.IO.Path;
import com.aspose.html.utils.ms.System.StringExtensions;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Vector;
import java.util.regex.Pattern;

public class Directory {
    public static DirectoryInfo createDirectory(String string) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        if (string.length() == 0) {
            throw new ArgumentException("Path is empty");
        }
        if (StringExtensions.trim(string).length() == 0) {
            throw new ArgumentException("Only blank characters in path");
        }
        java.io.File file = new java.io.File(string);
        if (file.mkdirs() || file.isDirectory() && file.exists()) {
            return new DirectoryInfo(string, true);
        }
        throw new IOException("DirectoryInfo was not created");
    }

    public static void delete(String string) {
        if (string == null || StringExtensions.trim(string).equals(StringExtensions.Empty)) {
            throw new ArgumentNullException("path");
        }
        java.io.File file = new java.io.File(string);
        if (!file.exists()) {
            throw new DirectoryNotFoundException("Directory was not found");
        }
        if (!file.isDirectory()) {
            throw new IOException("Target path is not directory");
        }
        boolean bl2 = file.delete();
        if (!bl2) {
            throw new IOException("Directory was not deleted");
        }
    }

    public static void delete(String string, boolean bl2) {
        java.io.File file = new java.io.File(string);
        if (bl2) {
            Directory.a(file);
        } else {
            Directory.delete(string);
        }
    }

    static void a(java.io.File file) {
        if (file.isDirectory()) {
            for (java.io.File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    Directory.a(file2);
                    continue;
                }
                file2.delete();
            }
        }
        file.delete();
    }

    public static boolean exists(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return new java.io.File(string).isDirectory();
    }

    public static String getCurrentDirectory() {
        java.io.File file = new java.io.File(".");
        java.io.File file2 = new java.io.File(file.getAbsolutePath());
        return file2.getParent();
    }

    public static String[] getDirectories(String string) {
        return Directory.getDirectories(string, "*");
    }

    public static String[] getDirectories(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        java.io.File file = new java.io.File(string);
        PatternFileFilter patternFileFilter = new PatternFileFilter(string2, false);
        String[] stringArray = new String[]{};
        String[] stringArray2 = file.list(patternFileFilter);
        if (stringArray2 != null) {
            stringArray = new String[stringArray2.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = Path.combine(file.getAbsolutePath(), stringArray2[i2]);
            }
        }
        return stringArray;
    }

    public static String[] getDirectories(String string, String string2, int n2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        if (n2 == 0) {
            return Directory.getDirectories(string, string2);
        }
        Vector<String> vector = new Vector<String>();
        Directory.a(string, string2, vector);
        return vector.toArray(new String[vector.size()]);
    }

    static void a(String string, String string2, Collection<String> collection) {
        for (String string3 : Directory.getDirectories(string)) {
            collection.add(string3);
        }
        for (String string3 : Directory.getDirectories(string)) {
            Directory.a(string3, string2, collection);
        }
    }

    public static String[] getFiles(String string) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        return Directory.getFiles(string, "*.*");
    }

    public static String[] getFiles(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        java.io.File file = new java.io.File(string);
        PatternFileFilter patternFileFilter = new PatternFileFilter(string2, true);
        String[] stringArray = new String[]{};
        String[] stringArray2 = file.list(patternFileFilter);
        if (stringArray2 != null) {
            stringArray = new String[stringArray2.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = Path.combine(file.getAbsolutePath(), stringArray2[i2]);
            }
        }
        return stringArray;
    }

    public static String[] getFiles(String string, String string2, int n2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        if (n2 == 0) {
            return Directory.getFiles(string, string2);
        }
        Vector<String> vector = new Vector<String>();
        Directory.b(string, string2, vector);
        return vector.toArray(new String[vector.size()]);
    }

    static void b(String string, String string2, Collection<String> collection) {
        for (String string3 : Directory.getFiles(string, string2)) {
            collection.add(string3);
        }
        for (String string3 : Directory.getDirectories(string)) {
            Directory.b(string3, string2, collection);
        }
    }

    public static String[] getFileSystemEntries(String string) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        return new java.io.File(string).list();
    }

    public static String[] getFileSystemEntries(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        return Directory.getFileSystemEntries(string);
    }

    static boolean a(String string) {
        if ("/".equals(string)) {
            return true;
        }
        return string.length() == 3 && StringExtensions.endsWith(string, ":\\");
    }

    public static DirectoryInfo getParent(String string) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        if (Directory.a(string)) {
            return null;
        }
        String string2 = Path.getDirectoryName(string);
        if (string2 == null || string2.length() == 0) {
            string2 = Directory.getCurrentDirectory();
        }
        return new DirectoryInfo(string2);
    }

    public static void move(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("sourceDirName");
        }
        if (StringExtensions.trim(string).equals(StringExtensions.Empty)) {
            throw new ArgumentException("sourceDirName is empty", "sourceDirName");
        }
        if (string2 == null) {
            throw new ArgumentNullException("destDirName");
        }
        if (StringExtensions.trim(string2).equals(StringExtensions.Empty)) {
            throw new ArgumentException("destDirName is empty", "destDirName");
        }
        if (StringExtensions.equals(string, string2)) {
            throw new IOException("Source and destination path must be different.");
        }
        if (new java.io.File(string2).exists()) {
            throw new IOException(StringExtensions.concat(string2, " already exists."));
        }
        if (!Directory.exists(string) && !File.exists(string)) {
            throw new DirectoryNotFoundException(StringExtensions.concat(string, " does not exist"));
        }
        java.io.File file = new java.io.File(string);
        if (!file.renameTo(new java.io.File(string2))) {
            throw new IOException("File can't be moved");
        }
    }

    static class PatternFileFilter
    implements FilenameFilter {
        private Pattern a;
        private boolean b;

        public PatternFileFilter(String string, boolean bl2) {
            if (string == "*.*") {
                this.a = Pattern.compile("^.*$");
            } else {
                string = string.replace(".", "\\.");
                this.a = Pattern.compile("^" + string.replace("*", ".*").replace("?", ".") + "$", 2);
            }
            this.b = bl2;
        }

        @Override
        public boolean accept(java.io.File file, String string) {
            String string2 = Path.combine(file.getAbsolutePath(), string);
            java.io.File file2 = new java.io.File(string2);
            if (this.b && file2.isFile() || !this.b && file2.isDirectory()) {
                if (file2.isFile() && !StringExtensions.contains(string, ".")) {
                    String string3 = this.a.pattern();
                    if (string3.endsWith("\\..*$")) {
                        string3 = StringExtensions.replace(string3, "\\..*$", ".*$");
                    }
                    if (string3.endsWith("\\.$")) {
                        string3 = StringExtensions.replace(string3, "\\.$", "$");
                    }
                    Pattern pattern = Pattern.compile(string3);
                    return pattern.matcher(string).find();
                }
                return this.a.matcher(file2.getName()).find();
            }
            return false;
        }
    }
}

