/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Char;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.System.IFormattable;
import com.aspose.html.utils.ms.System.ParseNumbers;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.ValueType;
import java.util.UUID;

public final class Guid
extends ValueType<Guid>
implements IFormattable,
Comparable<Guid> {
    public static final Guid Empty = new Guid();
    private int a;
    private short b;
    private short c;
    private byte d;
    private byte e;
    private byte f;
    private byte g;
    private byte h;
    private byte i;
    private byte j;
    private byte k;

    public Guid(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("b");
        }
        if (byArray.length != 16) {
            throw new ArgumentException("Guid array ctor: b length should be 16.");
        }
        this.a = byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        this.b = (short)(byArray[5] << 8 | byArray[4] & 0xFF);
        this.c = (short)(byArray[7] << 8 | byArray[6] & 0xFF);
        this.d = byArray[8];
        this.e = byArray[9];
        this.f = byArray[10];
        this.g = byArray[11];
        this.h = byArray[12];
        this.i = byArray[13];
        this.j = byArray[14];
        this.k = byArray[15];
    }

    public Guid(long l2, int n2, int n3, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9) {
        this.a = (int)l2;
        this.b = (short)n2;
        this.c = (short)n3;
        this.d = (byte)s2;
        this.e = (byte)s3;
        this.f = (byte)s4;
        this.g = (byte)s5;
        this.h = (byte)s6;
        this.i = (byte)s7;
        this.j = (byte)s8;
        this.k = (byte)s9;
    }

    public Guid(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        this.a = n2;
        this.b = (short)n3;
        this.c = (short)n4;
        this.d = (byte)n5;
        this.e = (byte)n6;
        this.f = (byte)n7;
        this.g = (byte)n8;
        this.h = (byte)n9;
        this.i = (byte)n10;
        this.j = (byte)n11;
        this.k = (byte)n12;
    }

    public Guid() {
        this.a = 0;
        this.b = 0;
        this.c = 0;
        this.d = 0;
        this.e = 0;
        this.f = 0;
        this.g = 0;
        this.h = 0;
        this.i = 0;
        this.j = 0;
        this.k = 0;
    }

    public static Guid fromJava(UUID uUID) {
        if (uUID == null) {
            return new Guid();
        }
        long l2 = uUID.getMostSignificantBits();
        long l3 = uUID.getLeastSignificantBits();
        return new Guid(l2, l3);
    }

    public static UUID toJava(Guid guid) {
        if (guid == null) {
            return null;
        }
        long l2 = (long)guid.a << 32;
        l2 |= ((long)guid.b & 0xFFFFL) << 16;
        l2 |= (long)guid.c & 0xFFFFL;
        long l3 = ((long)guid.d & 0xFFL) << 56;
        l3 |= ((long)guid.e & 0xFFL) << 48;
        l3 |= ((long)guid.f & 0xFFL) << 40;
        l3 |= ((long)guid.g & 0xFFL) << 32;
        l3 |= ((long)guid.h & 0xFFL) << 24;
        l3 |= ((long)guid.i & 0xFFL) << 16;
        l3 |= ((long)guid.j & 0xFFL) << 8;
        return new UUID(l2, l3 |= (long)guid.k & 0xFFL);
    }

    public Guid(long l2, long l3) {
        this.a = (int)(l2 >> 32);
        this.b = (short)(l2 >> 16);
        this.c = (short)l2;
        this.d = (byte)(l3 >> 56);
        this.e = (byte)(l3 >> 48);
        this.f = (byte)(l3 >> 40);
        this.g = (byte)(l3 >> 32);
        this.h = (byte)(l3 >> 24);
        this.i = (byte)(l3 >> 16);
        this.j = (byte)(l3 >> 8);
        this.k = (byte)l3;
    }

    public Guid(String string) {
        if (string == null) {
            throw new NullPointerException("g");
        }
        int n2 = 0;
        int[] nArray = new int[]{0};
        try {
            long l2;
            int n3;
            if (string.indexOf(45, 0) < 0 && string.length() == 32) {
                string = StringExtensions.insert(string, 20, "-");
                string = StringExtensions.insert(string, 16, "-");
                string = StringExtensions.insert(string, 12, "-");
                string = StringExtensions.insert(string, 8, "-");
            }
            if (string.indexOf(45, 0) >= 0) {
                String string2 = string.trim();
                if (string2.charAt(0) == '{') {
                    if (string2.length() != 38 || string2.charAt(37) != '}') {
                        throw new IllegalStateException("Wrong Guid format sting length: " + string);
                    }
                    n2 = 1;
                } else if (string2.charAt(0) == '(') {
                    if (string2.length() != 38 || string2.charAt(37) != ')') {
                        throw new IllegalStateException("Wrong Guid format sting length: " + string);
                    }
                    n2 = 1;
                } else if (string2.length() != 36) {
                    throw new IllegalStateException("Wrong Guid format sting length: " + string);
                }
                if (string2.charAt(8 + n2) != '-' || string2.charAt(13 + n2) != '-' || string2.charAt(18 + n2) != '-' || string2.charAt(23 + n2) != '-') {
                    throw new IllegalStateException("Wrong format: missed or misplaced dashes: " + string);
                }
                nArray[0] = n2;
                this.a = Guid.a(string2, nArray, 8);
                nArray[0] = nArray[0] + 1;
                this.b = (short)Guid.a(string2, nArray, 4);
                nArray[0] = nArray[0] + 1;
                this.c = (short)Guid.a(string2, nArray, 4);
                nArray[0] = nArray[0] + 1;
                n3 = Guid.a(string2, nArray, 4);
                nArray[0] = nArray[0] + 1;
                n2 = nArray[0];
                l2 = ParseNumbers.stringToLong(string2, 16, 8192, nArray);
                if (nArray[0] - n2 != 12) {
                    throw new IllegalStateException("Wrong Guid format sting length: " + string);
                }
            } else {
                throw new IllegalStateException("Unsupported Guid Format: " + string);
            }
            this.d = (byte)(n3 >> 8);
            this.e = (byte)n3;
            n3 = (int)(l2 >> 32);
            this.f = (byte)(n3 >> 8);
            this.g = (byte)n3;
            n3 = (int)l2;
            this.h = (byte)(n3 >> 24);
            this.i = (byte)(n3 >> 16);
            this.j = (byte)(n3 >> 8);
            this.k = (byte)n3;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalStateException("Format_GuidUnrecognized");
        }
    }

    public Guid(int n2, short s2, short s3, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("d");
        }
        if (byArray.length != 8) {
            throw new ArgumentException("Arg_GuidArrayCtor. d should have length 8.");
        }
        this.a = n2;
        this.b = s2;
        this.c = s3;
        this.d = byArray[0];
        this.e = byArray[1];
        this.f = byArray[2];
        this.g = byArray[3];
        this.h = byArray[4];
        this.i = byArray[5];
        this.j = byArray[6];
        this.k = byArray[7];
    }

    public Guid(int n2, short s2, short s3, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9) {
        this.a = n2;
        this.b = s2;
        this.c = s3;
        this.d = by2;
        this.e = by3;
        this.f = by4;
        this.g = by5;
        this.h = by6;
        this.i = by7;
        this.j = by8;
        this.k = by9;
    }

    private static int a(String string, int[] nArray, int n2) {
        int n3 = nArray[0];
        int n4 = (int)ParseNumbers.stringToLong(string, 16, 8192, nArray);
        if (nArray[0] - n3 != n2) {
            throw new IllegalStateException("Wrong Guid Format: Invalid Char: " + string);
        }
        return n4;
    }

    private static String a(String string) {
        int n2 = 0;
        char[] cArray = new char[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Char.isWhiteSpace(c2)) continue;
            cArray[n2++] = c2;
        }
        return new String(cArray, 0, n2);
    }

    private static boolean a(String string, int n2) {
        return string.charAt(n2) == '0' && (string.charAt(n2 + 1) == 'x' || string.charAt(n2 + 1) == 'X');
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[]{(byte)this.a, (byte)(this.a >> 8), (byte)(this.a >> 16), (byte)(this.a >> 24), (byte)this.b, (byte)(this.b >> 8), (byte)this.c, (byte)(this.c >> 8), this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k};
        return byArray;
    }

    public String toString() {
        return this.toString("D");
    }

    public int hashCode() {
        return this.a ^ ((this.b & 0xFFFF) << 16 | this.c & 0xFFFF) ^ ((this.f & 0xFF) << 24 | this.k & 0xFF);
    }

    public boolean equals(Object object) {
        return object instanceof Guid && Guid.op_Equality(this, (Guid)object);
    }

    public static boolean op_Equality(Guid guid, Guid guid2) {
        if (guid == guid2) {
            return true;
        }
        if (guid == null || guid2 == null) {
            return false;
        }
        if (guid.a != guid2.a) {
            return false;
        }
        if (guid.b != guid2.b) {
            return false;
        }
        if (guid.c != guid2.c) {
            return false;
        }
        if (guid.d != guid2.d) {
            return false;
        }
        if (guid.e != guid2.e) {
            return false;
        }
        if (guid.f != guid2.f) {
            return false;
        }
        if (guid.g != guid2.g) {
            return false;
        }
        if (guid.h != guid2.h) {
            return false;
        }
        if (guid.i != guid2.i) {
            return false;
        }
        if (guid.j != guid2.j) {
            return false;
        }
        return guid.k == guid2.k;
    }

    public static boolean op_Inequality(Guid guid, Guid guid2) {
        return !Guid.op_Equality(guid, guid2);
    }

    private int a(long l2, long l3) {
        if (l2 < l3) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareTo(Guid guid) {
        if (guid == null) {
            return 1;
        }
        if (guid.a != this.a) {
            return this.a(this.a, guid.a);
        }
        if (guid.b != this.b) {
            return this.a(this.b, guid.b);
        }
        if (guid.c != this.c) {
            return this.a(this.c, guid.c);
        }
        if (guid.d != this.d) {
            return this.a(this.d, guid.d);
        }
        if (guid.e != this.e) {
            return this.a(this.e, guid.e);
        }
        if (guid.f != this.f) {
            return this.a(this.f, guid.f);
        }
        if (guid.g != this.g) {
            return this.a(this.g, guid.g);
        }
        if (guid.h != this.h) {
            return this.a(this.h, guid.h);
        }
        if (guid.i != this.i) {
            return this.a(this.i, guid.i);
        }
        if (guid.j != this.j) {
            return this.a(this.j, guid.j);
        }
        if (guid.k != this.k) {
            return this.a(this.k, guid.k);
        }
        return 0;
    }

    public static Guid newGuid() {
        return Guid.fromJava(UUID.randomUUID());
    }

    private static char a(int n2) {
        return (char)((n2 &= 0xF) > 9 ? n2 - 10 + 97 : n2 + 48);
    }

    private static int a(char[] cArray, int n2, int n3, int n4) {
        cArray[n2++] = Guid.a(n3 >> 4);
        cArray[n2++] = Guid.a(n3);
        cArray[n2++] = Guid.a(n4 >> 4);
        cArray[n2++] = Guid.a(n4);
        return n2;
    }

    @Override
    public String toString(String string, IFormatProvider iFormatProvider) {
        return this.toString(string);
    }

    public String toString(String string) {
        char[] cArray;
        if (string == null || string.length() == 0) {
            string = "D";
        }
        int n2 = 0;
        int n3 = 38;
        boolean bl2 = true;
        if (string.length() != 1) {
            throw new IllegalStateException("Format_InvalidGuidFormatSpecification");
        }
        char c2 = string.charAt(0);
        if (c2 == 'D' || c2 == 'd') {
            cArray = new char[36];
            n3 = 36;
        } else if (c2 == 'N' || c2 == 'n') {
            cArray = new char[32];
            n3 = 32;
            bl2 = false;
        } else if (c2 == 'B' || c2 == 'b') {
            cArray = new char[38];
            cArray[n2++] = 123;
            cArray[37] = 125;
        } else if (c2 == 'P' || c2 == 'p') {
            cArray = new char[38];
            cArray[n2++] = 40;
            cArray[37] = 41;
        } else {
            throw new IllegalStateException("Format_InvalidGuidFormatSpecification");
        }
        n2 = Guid.a(cArray, n2, this.a >> 24, this.a >> 16);
        n2 = Guid.a(cArray, n2, this.a >> 8, this.a);
        if (bl2) {
            cArray[n2++] = 45;
        }
        n2 = Guid.a(cArray, n2, this.b >> 8, this.b);
        if (bl2) {
            cArray[n2++] = 45;
        }
        n2 = Guid.a(cArray, n2, this.c >> 8, this.c);
        if (bl2) {
            cArray[n2++] = 45;
        }
        n2 = Guid.a(cArray, n2, this.d, this.e);
        if (bl2) {
            cArray[n2++] = 45;
        }
        n2 = Guid.a(cArray, n2, this.f, this.g);
        n2 = Guid.a(cArray, n2, this.h, this.i);
        n2 = Guid.a(cArray, n2, this.j, this.k);
        return new String(cArray, 0, n3);
    }

    public String toString(String string, CultureInfo cultureInfo) {
        return this.toString(string);
    }

    @Override
    public void CloneTo(Guid guid) {
        guid.a = this.a;
        guid.b = this.b;
        guid.c = this.c;
        guid.d = this.d;
        guid.e = this.e;
        guid.f = this.f;
        guid.g = this.g;
        guid.h = this.h;
        guid.i = this.i;
        guid.j = this.j;
        guid.k = this.k;
    }

    @Override
    public Guid Clone() {
        Guid guid = new Guid();
        this.CloneTo(guid);
        return guid;
    }

    public Object clone() {
        return this.Clone();
    }
}

