/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing.Printing;

import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Drawing.Bitmap;
import com.aspose.html.utils.ms.System.Drawing.Brush;
import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.System.Drawing.Graphics;
import com.aspose.html.utils.ms.System.Drawing.Point;
import com.aspose.html.utils.ms.System.Drawing.Printing.InvalidPrinterException;
import com.aspose.html.utils.ms.System.Drawing.Printing.PreviewPageInfo;
import com.aspose.html.utils.ms.System.Drawing.Printing.PrintController;
import com.aspose.html.utils.ms.System.Drawing.Printing.PrintDocument;
import com.aspose.html.utils.ms.System.Drawing.Printing.PrintEventArgs;
import com.aspose.html.utils.ms.System.Drawing.Printing.PrintPageEventArgs;
import com.aspose.html.utils.ms.System.Drawing.Rectangle;
import com.aspose.html.utils.ms.System.Drawing.Size;
import com.aspose.html.utils.ms.System.Drawing.SolidBrush;

public class PreviewPrintController
extends PrintController {
    private boolean b;
    private ArrayList c = new ArrayList();
    private Graphics d;

    @Override
    public boolean isPreview() {
        return true;
    }

    @Override
    public void onStartPrint(PrintDocument printDocument, PrintEventArgs printEventArgs) {
        super.onStartPrint(printDocument, printEventArgs);
        if (!printDocument.getPrinterSettings().isValid()) {
            throw new InvalidPrinterException(printDocument.getPrinterSettings());
        }
    }

    @Override
    public Graphics onStartPage(PrintDocument printDocument, PrintPageEventArgs printPageEventArgs) {
        super.onStartPage(printDocument, printPageEventArgs);
        this.a = printDocument.getPrinterSettings().a(printPageEventArgs.getPageSettings());
        Size size = printPageEventArgs.getPageBounds().getSize();
        int n2 = (size.getWidth() - (printPageEventArgs.getPageSettings().getMargins().getLeft() + printPageEventArgs.getPageSettings().getMargins().getRight())) / 100;
        int n3 = (size.getHeight() - (printPageEventArgs.getPageSettings().getMargins().getBottom() + printPageEventArgs.getPageSettings().getMargins().getTop())) / 100;
        int n4 = printPageEventArgs.getPageSettings().getPrinterResolution().getX();
        int n5 = printPageEventArgs.getPageSettings().getPrinterResolution().getY();
        Size size2 = new Size(n2 * n4, n3 * n5);
        Bitmap bitmap = null;
        bitmap = printPageEventArgs.getPageSettings().getLandscape() ? new Bitmap(size2.getWidth(), size2.getHeight()) : new Bitmap(size2.getHeight(), size2.getWidth());
        PreviewPageInfo previewPageInfo = new PreviewPageInfo(bitmap, size);
        this.c.addItem(previewPageInfo);
        this.d = Graphics.fromImage(bitmap);
        this.d.fillRectangle((Brush)new SolidBrush(Color.getWhite().Clone()), new Rectangle(new Point(0, 0), new Size(bitmap.getWidth(), bitmap.getHeight())));
        if (printDocument.getOriginAtMargins()) {
            this.d.translateTransform(printDocument.getDefaultPageSettings().getMargins().getLeft(), printDocument.getDefaultPageSettings().getMargins().getTop());
        }
        if (this.getUseAntiAlias()) {
            this.d.setTextRenderingHint(4);
            this.d.setSmoothingMode(4);
        }
        return this.d;
    }

    @Override
    public void onEndPage(PrintDocument printDocument, PrintPageEventArgs printPageEventArgs) {
        this.d.dispose();
        this.d = null;
        super.onEndPage(printDocument, printPageEventArgs);
    }

    @Override
    public void onEndPrint(PrintDocument printDocument, PrintEventArgs printEventArgs) {
        super.onEndPrint(printDocument, printEventArgs);
    }

    public boolean getUseAntiAlias() {
        return this.b;
    }

    public void setUseAntiAlias(boolean bl2) {
        this.b = bl2;
    }

    public PreviewPageInfo[] getPreviewPageInfo() {
        PreviewPageInfo[] previewPageInfoArray = new PreviewPageInfo[this.c.size()];
        this.c.copyTo(Array.boxing(previewPageInfoArray));
        return previewPageInfoArray;
    }
}

