/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing;

import com.aspose.html.IDisposable;
import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Drawing.Bitmap;
import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ColorPalette;
import com.aspose.html.utils.ms.System.Drawing.Imaging.Encoder;
import com.aspose.html.utils.ms.System.Drawing.Imaging.EncoderParameter;
import com.aspose.html.utils.ms.System.Drawing.Imaging.EncoderParameters;
import com.aspose.html.utils.ms.System.Drawing.Imaging.FrameDimension;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ImageCodecInfo;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ImageFormat;
import com.aspose.html.utils.ms.System.Drawing.Imaging.Metafile;
import com.aspose.html.utils.ms.System.Drawing.Imaging.PixelFormat;
import com.aspose.html.utils.ms.System.Drawing.Imaging.PlainImage;
import com.aspose.html.utils.ms.System.Drawing.Imaging.PlainImageCollection;
import com.aspose.html.utils.ms.System.Drawing.Imaging.PropertyItem;
import com.aspose.html.utils.ms.System.Drawing.RectangleF;
import com.aspose.html.utils.ms.System.Drawing.Size;
import com.aspose.html.utils.ms.System.Drawing.SizeF;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.Guid;
import com.aspose.html.utils.ms.System.ICloneable;
import com.aspose.html.utils.ms.System.IO.File;
import com.aspose.html.utils.ms.System.IO.FileNotFoundException;
import com.aspose.html.utils.ms.System.IO.FileStream;
import com.aspose.html.utils.ms.System.IntPtr;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.OutOfMemoryException;
import com.aspose.html.utils.ms.System.Runtime.InteropServices.ExternalException;
import com.aspose.html.utils.ms.System.msArray;
import com.aspose.html.utils.ms.core.System.Drawing.GraphicsUtils;
import com.aspose.html.utils.ms.core.System.Drawing.Imaging.ImageCodec;
import com.aspose.html.utils.ms.core.drawing.a.c;
import com.aspose.html.utils.ms.core.drawing.c.b;
import com.aspose.html.utils.ms.lang.Ref;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public abstract class Image
implements IDisposable,
ICloneable {
    private PlainImageCollection a;
    protected int _flags = 0;
    protected boolean isMultiframe = false;
    private ImageCodec b = null;
    private ImageOutputStream c = null;
    private Stream d = null;

    @Override
    public void dispose() {
        this.a.clear();
    }

    protected void disposeResources() {
    }

    protected void dispose(boolean bl2) {
    }

    public Image() {
        this.initialize(new PlainImageCollection());
    }

    protected Image(java.awt.Image image) {
        this(image, ImageFormat.getMemoryBmp());
    }

    protected Image(java.awt.Image image, ImageFormat imageFormat) {
        PlainImage plainImage = new PlainImage(image, null, imageFormat, this.a(image, "dpiX"), this.a(image, "dpiY"), FrameDimension.getPage());
        this.a = new PlainImageCollection();
        this.a.add(plainImage);
    }

    private float a(java.awt.Image image, String string) {
        Object object = image.getProperty(string, null);
        if (object != null && !java.awt.Image.UndefinedProperty.equals(object) && object instanceof Float) {
            return ((Float)object).floatValue();
        }
        return GraphicsUtils.getDefaultScreenResolution();
    }

    public void initialize(PlainImageCollection plainImageCollection) {
        this.a = plainImageCollection;
        this._flags |= 0x12000;
    }

    private void a(int n2) {
        this.getNativeObject().setCurrentImageIndex(n2);
    }

    public PlainImage getPlainImageItem(int n2) {
        if (n2 < this.a.getCount()) {
            return this.a.get_Item(n2);
        }
        return this.getNativeObject().get_Item(n2);
    }

    public PlainImageCollection getNativeObject() {
        return this.a;
    }

    protected PlainImage getCurrentImage() {
        return this.a.getCurrentImage();
    }

    public static Image fromFile(String string) {
        if (string == null) {
            throw new ArgumentNullException();
        }
        if (string.length() == 0) {
            throw new ArgumentException();
        }
        if (!File.exists(string)) {
            throw new FileNotFoundException();
        }
        try {
            return new Bitmap(false, string);
        }
        catch (ArgumentException argumentException) {
            try {
                return new Metafile(string);
            }
            catch (ArgumentException argumentException2) {
                throw argumentException;
            }
        }
    }

    public static Image fromFile(String string, boolean bl2) {
        if (!File.exists(string)) {
            throw new FileNotFoundException(string);
        }
        return new Bitmap(string, bl2);
    }

    @Override
    public abstract Object deepClone();

    public static Image fromStream(Stream stream) {
        try {
            return new Bitmap(false, stream);
        }
        catch (ArgumentException argumentException) {
            try {
                stream.setPosition(0L);
                return new Metafile(stream);
            }
            catch (ArgumentException argumentException2) {
                throw argumentException;
            }
        }
    }

    public static Image fromStream(Stream stream, boolean bl2) {
        return new Bitmap(stream, bl2);
    }

    public static Image fromStream(Stream stream, boolean bl2, boolean bl3) {
        return Image.fromStream(stream, bl2);
    }

    public static int getPixelFormatSize(int n2) {
        return (n2 & 0xFF00) > 0 ? n2 >> 8 & 0xFF : 0;
    }

    public static boolean isIndexedPixelFormat(int n2) {
        return (n2 & 0x10000) != 0;
    }

    public static boolean isAlphaPixelFormat(int n2) {
        return (n2 & 0x40000) != 0;
    }

    public static boolean isPAlphaPixelFormat(int n2) {
        return (n2 & 0x80000) != 0;
    }

    public static boolean isCanonicalPixelFormat(int n2) {
        return (n2 & 0x200000) != 0;
    }

    public static boolean isExtendedPixelFormat(int n2) {
        return (n2 & 0x100000) != 0;
    }

    public RectangleF getBounds(Ref<Integer> ref) {
        ref.value = 2;
        return new RectangleF(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public EncoderParameters getEncoderParameterList(Guid guid) {
        throw new NotImplementedException();
    }

    public int getFrameCount(FrameDimension frameDimension) {
        this.a(frameDimension);
        return this.getNativeObject().getCount();
    }

    public void rotateFlip(int n2) {
        AffineTransform affineTransform;
        if (!(this.getCurrentImage().getNativeImage() instanceof BufferedImage)) {
            throw new NotImplementedException("Only raster formats are supported");
        }
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
                affineTransform.translate(0.0, -this.getHeight());
                break;
            }
            case 2: {
                affineTransform = AffineTransform.getScaleInstance(-1.0, -1.0);
                affineTransform.translate(-this.getWidth(), -this.getHeight());
                break;
            }
            case 3: {
                affineTransform = AffineTransform.getRotateInstance(-1.5707963267948966);
                affineTransform.translate(-this.getWidth(), 0.0);
                break;
            }
            case 4: {
                affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
                affineTransform.translate(-this.getWidth(), 0.0);
                break;
            }
            case 5: {
                affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
                affineTransform.scale(1.0, -1.0);
                break;
            }
            case 6: {
                affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
                affineTransform.translate(0.0, -this.getHeight());
                break;
            }
            case 7: {
                affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-this.getWidth(), -this.getHeight());
                break;
            }
            default: {
                throw new ArgumentException();
            }
        }
        b b2 = new b(affineTransform, 2);
        this.getCurrentImage().setNativeImage(b2.a((BufferedImage)this.getCurrentImage().getNativeImage(), null));
    }

    protected abstract void internalSave(ImageOutputStream var1, ImageCodec var2, EncoderParameters var3, Stream var4);

    public void save(Stream stream, ImageCodecInfo imageCodecInfo, EncoderParameters encoderParameters) {
        if (imageCodecInfo == null) {
            throw new ArgumentNullException("encoder", "Value cannot be null.");
        }
        this.isMultiframe = this.a(encoderParameters);
        ImageCodec imageCodec = ImageCodec.createWriter(imageCodecInfo.getClsid().Clone());
        imageCodec.setMultiframe(this.isMultiframe);
        try {
            OutputStream outputStream = stream.toOutputStream();
            MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(outputStream);
            this.internalSave(memoryCacheImageOutputStream, imageCodec, encoderParameters, stream);
            if (!this.isMultiframe) {
                memoryCacheImageOutputStream.flush();
                stream.flush();
            } else {
                this.c = memoryCacheImageOutputStream;
            }
        }
        catch (IOException iOException) {
            throw new com.aspose.html.utils.ms.System.IO.IOException(iOException.getMessage(), iOException);
        }
        finally {
            if (!this.isMultiframe) {
                imageCodec.dispose();
            } else {
                this.b = imageCodec;
                this.d = stream;
            }
        }
    }

    public void save(String string, ImageCodecInfo imageCodecInfo, EncoderParameters encoderParameters) {
        FileStream fileStream = new FileStream(string, 2);
        this.save(fileStream, imageCodecInfo, encoderParameters);
        if (!this.isMultiframe) {
            fileStream.close();
        }
    }

    public void save(String string) {
        this.save(string, this.getRawFormat());
    }

    public void save(Stream stream, ImageFormat imageFormat) {
        this.a(stream, imageFormat, true);
    }

    private void a(Stream stream, ImageFormat imageFormat) {
        this.a(stream, imageFormat, false);
    }

    private void a(Stream stream, ImageFormat imageFormat, boolean bl2) {
        if (!this.getRawFormat().getGuid().equals(ImageFormat.getIcon().getGuid()) && ImageFormat.getIcon().getGuid().equals(imageFormat.getGuid())) {
            imageFormat = ImageFormat.getPng();
        }
        ImageCodecInfo imageCodecInfo = ImageCodec.findEncoder(ImageCodec.imageFormatToClsid(imageFormat).Clone());
        if (bl2 && imageCodecInfo != null && !imageCodecInfo.getClsid().equals(ImageCodec.imageFormatToClsid(imageFormat).Clone())) {
            throw new ArgumentNullException("codec not found (" + imageFormat.getGuid().toString() + ") codec=" + imageCodecInfo.getCodecName() + ":" + imageCodecInfo.getFormatID());
        }
        this.save(stream, imageCodecInfo, null);
    }

    public void setResolution(float f2, float f3) {
        if (f2 <= 0.0f || f3 <= 0.0f || Float.valueOf(f2).isNaN() || Float.valueOf(f3).isNaN()) {
            throw new ArgumentException("Parameter is not valid");
        }
        this.getCurrentImage().setHorizontalResolution(f2);
        this.getCurrentImage().setVerticalResolution(f3);
        this._flags |= 0x1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, ImageFormat imageFormat) {
        FileStream fileStream = new FileStream(string, 2);
        try {
            this.a(fileStream, imageFormat);
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAdd(EncoderParameters encoderParameters) {
        if (encoderParameters == null) {
            throw new ArgumentException("Parameter is not valid.", "encoderParams");
        }
        if (this.isMultiframe) {
            boolean bl2 = this.b(encoderParameters);
            try {
                if (bl2) {
                    this.b.endWriteToSequence();
                }
                if (this.a(this.b, encoderParameters)) {
                    PlainImage plainImage = this.getCurrentImage();
                    this.setPlainImageProperties(encoderParameters, plainImage);
                    this.b.writeToSequence(plainImage);
                }
                throw new ArgumentException("Parameter is not valid.", "encoderParams");
            }
            finally {
                if (bl2) {
                    this.b.setMultiframe(false);
                    this.b.dispose();
                    this.b = null;
                    if (this.c != null) {
                        try {
                            this.c.flush();
                            this.c.close();
                            this.c = null;
                        }
                        catch (IOException iOException) {}
                        try {
                            this.d.flush();
                            this.d = null;
                        }
                        catch (com.aspose.html.utils.ms.System.IO.IOException iOException) {}
                    }
                }
            }
        } else {
            throw new InvalidOperationException("Save method should be called before");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveAdd(Image image, EncoderParameters encoderParameters) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        if (encoderParameters == null) {
            throw new ArgumentException("Parameter is not valid.", "encoderParams");
        }
        if (!this.isMultiframe) throw new InvalidOperationException("Save method should be called before");
        if (!this.a(this.b, encoderParameters)) throw new ArgumentException("Parameter is not valid.", "encoderParams");
        PlainImage plainImage = image.getCurrentImage();
        if (plainImage == null) return;
        this.setPlainImageProperties(encoderParameters, plainImage);
        this.b.writeToSequence(plainImage);
    }

    private boolean a(EncoderParameters encoderParameters) {
        return this.a(encoderParameters, 18);
    }

    private boolean a(ImageCodec imageCodec, EncoderParameters encoderParameters) {
        if (imageCodec.getImageFormat().equals(ImageFormat.getTiff())) {
            return this.c(encoderParameters);
        }
        if (imageCodec.getImageFormat().equals(ImageFormat.getGif())) {
            return this.d(encoderParameters);
        }
        if (imageCodec.getImageFormat().equals(ImageFormat.getIcon())) {
            return this.e(encoderParameters);
        }
        return false;
    }

    private boolean b(EncoderParameters encoderParameters) {
        return this.a(encoderParameters, 20);
    }

    private boolean c(EncoderParameters encoderParameters) {
        return this.a(encoderParameters, 23);
    }

    private boolean d(EncoderParameters encoderParameters) {
        return this.a(encoderParameters, 21);
    }

    private boolean e(EncoderParameters encoderParameters) {
        return this.a(encoderParameters, 22);
    }

    private boolean a(EncoderParameters encoderParameters, int n2) {
        boolean bl2 = false;
        if (encoderParameters != null && encoderParameters.getParam() != null) {
            EncoderParameter[] encoderParameterArray;
            for (EncoderParameter encoderParameter : encoderParameterArray = encoderParameters.getParam()) {
                if (encoderParameter == null) {
                    throw new ArgumentNullException("param can't be null");
                }
                if (!encoderParameter.getEncoder().equals(Encoder.SaveFlag) || encoderParameter.intValue() != n2) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    protected void setPlainImageProperties(EncoderParameters encoderParameters, PlainImage plainImage) {
        int n2 = this.getPixelFormat();
        plainImage.setProperty("pixelFormat", n2);
        plainImage.setProperty("bitspPixel", Image.getPixelFormatSize(n2));
        plainImage.setProperty("dpiX", Float.valueOf(this.getHorizontalResolution()));
        plainImage.setProperty("dpiY", Float.valueOf(this.getVerticalResolution()));
        if (encoderParameters != null) {
            EncoderParameter[] encoderParameterArray = encoderParameters.getParam();
            Object[] objectArray = new Object[encoderParameterArray.length];
            int n3 = 0;
            for (EncoderParameter encoderParameter : encoderParameterArray) {
                Object[] objectArray2 = new Object[]{encoderParameter.getEncoder().getGuid(), encoderParameter.intValue(), encoderParameter.getType(), encoderParameter.getNumberOfValues()};
                objectArray[n3++] = objectArray2;
            }
            plainImage.setProperty("encoderParameters", objectArray);
        }
    }

    public int selectActiveFrame(FrameDimension frameDimension, int n2) {
        this.a(frameDimension);
        if (n2 < 0 || n2 >= this.getFrameCount(frameDimension)) {
            throw new ExternalException("A generic error occurred in GDI+.");
        }
        this.a(n2);
        return 0;
    }

    public int getFlags() {
        if (this.getRawFormat().isBitmapType()) {
            return this.a();
        }
        if (this.getRawFormat().isMetafileType()) {
            return 327683;
        }
        throw new IllegalStateException("unknown type of image");
    }

    private int a(ColorModel colorModel) {
        if (this.getRawFormat().equals(ImageFormat.getJpeg()) && colorModel.getColorSpace().getType() == 5 && colorModel.getPixelSize() == 24) {
            return 3;
        }
        return colorModel.getColorSpace().getType();
    }

    private int a() {
        ColorModel colorModel = ((BufferedImage)this.getCurrentImage().getNativeImage()).getColorModel();
        int n2 = this.a(colorModel);
        if (n2 == 5) {
            this._flags |= 0x10;
        } else if (n2 == 9) {
            this._flags |= 0x20;
        } else if (n2 == 6) {
            this._flags |= 0x40;
        } else if (n2 == 3) {
            this._flags |= 0x80;
        }
        if (colorModel.hasAlpha()) {
            this._flags |= 2;
        }
        if (!this.getRawFormat().equals(ImageFormat.getBmp()) && (this.getCurrentImage().getHorizontalResolution() > 0.0f || this.getCurrentImage().getVerticalResolution() > 0.0f)) {
            this._flags |= 0x1000;
        }
        if (this.getRawFormat().equals(ImageFormat.getJpeg())) {
            this._flags |= 8;
        }
        return this._flags;
    }

    public Guid[] getFrameDimensionsList() {
        Guid[] guidArray = new Guid[]{this.getCurrentImage().getDimension().getGuid()};
        return guidArray;
    }

    public int getHeight() {
        return this.getCurrentImage().getNativeImage().getHeight(null);
    }

    public float getHorizontalResolution() {
        if (this.getCurrentImage().getHorizontalResolution() <= 1.0f) {
            return GraphicsUtils.getDefaultScreenResolution();
        }
        return this.getCurrentImage().getHorizontalResolution();
    }

    public ColorPalette getPalette() {
        if (!(this.getCurrentImage().getNativeImage() instanceof BufferedImage)) {
            throw new NotImplementedException("Only raster formats are supported");
        }
        ColorModel colorModel = ((BufferedImage)this.getCurrentImage().getNativeImage()).getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return this.a((IndexColorModel)colorModel);
        }
        if (this.getPixelFormat() == 198659) {
            return ColorPalette.createGgreyscalePalette(256);
        }
        return ColorPalette.createEmptyPalette();
    }

    private ColorPalette a(IndexColorModel indexColorModel) {
        int n2 = this.getPixelFormat();
        if (n2 == 196865 && ImageFormat.getPng().equals(this.getCurrentImage().getImageFormat())) {
            return ColorPalette.createPalette(0, this.b(indexColorModel));
        }
        return ColorPalette.createPalette((indexColorModel.hasAlpha() && PixelFormat.containsFormat(n2, 262144) ? 1 : 0) | (n2 == 196865 ? 2 : 0) | (n2 != 196865 && n2 != 197634 ? 4 : 0), this.b(indexColorModel));
    }

    private Color[] b(IndexColorModel indexColorModel) {
        Color[] colorArray = msArray.createArrayWithInitialization(Color.class, indexColorModel.getMapSize());
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            colorArray[i2] = Color.fromArgb(indexColorModel.getRGB(i2));
        }
        return colorArray;
    }

    public void setPalette(ColorPalette colorPalette) {
        if (!(this.getCurrentImage().getNativeImage() instanceof BufferedImage)) {
            throw new NotImplementedException("Only raster formats are supported");
        }
        BufferedImage bufferedImage = (BufferedImage)this.getCurrentImage().getNativeImage();
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.a(colorPalette, bufferedImage, (IndexColorModel)colorModel);
        }
    }

    private void a(ColorPalette colorPalette, BufferedImage bufferedImage, IndexColorModel indexColorModel) {
        boolean bl2 = this.a(colorPalette);
        int n2 = indexColorModel.getNumComponents();
        if (n2 < 4 && bl2) {
            ++n2;
        }
        int n3 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n3 * n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            Color color = colorPalette.getEntries()[i2 % colorPalette.getEntries().length];
            byArray[i2 * n2] = color.getR();
            byArray[i2 * n2 + 1] = color.getG();
            byArray[i2 * n2 + 2] = color.getB();
            if (n2 <= 3) continue;
            byArray[i2 * n2 + 3] = color.getA();
        }
        IndexColorModel indexColorModel2 = new IndexColorModel(indexColorModel.getPixelSize(), colorPalette.getEntries().length, byArray, 0, bl2 || indexColorModel.hasAlpha());
        this.a(bufferedImage, indexColorModel2);
    }

    private void a(BufferedImage bufferedImage, IndexColorModel indexColorModel) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(null), bufferedImage.getHeight(null), Image.toBufferedImageFormat(this.getPixelFormat()), indexColorModel);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((java.awt.Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        this.getCurrentImage().setNativeImage(bufferedImage2);
    }

    private boolean a(ColorPalette colorPalette) {
        Color[] colorArray;
        for (Color color : colorArray = colorPalette.getEntries()) {
            if (color.getA() != 0) continue;
            return true;
        }
        return false;
    }

    public SizeF getPhysicalDimension() {
        return new SizeF(this.getWidth(), this.getHeight());
    }

    protected abstract java.awt.Image[] cloneNativeObjects(java.awt.Image[] var1);

    protected abstract int getInternalPixelFormat();

    public static int getInternalPixelFormat(int n2, int n3) {
        switch (n2) {
            case 11: {
                return 0x101004;
            }
            case 10: 
            case 13: {
                return 198659;
            }
            case 1: {
                return 139273;
            }
            case 2: 
            case 6: {
                return 2498570;
            }
            case 3: 
            case 7: {
                return 925707;
            }
            case 9: {
                return 135173;
            }
            case 8: {
                return 135174;
            }
            case 5: {
                return 137224;
            }
            case 12: {
                int n4 = n3;
                if (n4 == 1) {
                    return 196865;
                }
                if (n4 == 8) {
                    return 198659;
                }
                return 197634;
            }
        }
        return 0;
    }

    public static int toBufferedImageFormat(int n2) {
        switch (n2) {
            case 0x101004: {
                return 11;
            }
            case 196865: 
            case 197634: {
                return 12;
            }
            case 139273: {
                return 1;
            }
            case 2498570: {
                return 6;
            }
            case 925707: {
                return 7;
            }
            case 135173: {
                return 9;
            }
            case 135174: {
                return 8;
            }
            case 198659: {
                return 13;
            }
            case 137224: {
                return 5;
            }
        }
        return 2;
    }

    public int getPixelFormat() {
        return this.getInternalPixelFormat();
    }

    public int[] getPropertyIdList() {
        List<PropertyItem> list = this.getCurrentImage().getPropertyItems();
        if (list != null) {
            int[] nArray = new int[list.size()];
            int n2 = 0;
            for (PropertyItem propertyItem : list) {
                nArray[n2++] = propertyItem.getId();
            }
            return nArray;
        }
        return new int[0];
    }

    public void setPropertyItem(PropertyItem propertyItem) {
        List<PropertyItem> list = this.getCurrentImage().getPropertyItems();
        if (list != null) {
            list.add(propertyItem);
        }
    }

    public PropertyItem[] getPropertyItems() {
        List<PropertyItem> list = this.getCurrentImage().getPropertyItems();
        if (list != null) {
            return list.toArray(new PropertyItem[0]);
        }
        return new PropertyItem[0];
    }

    public PropertyItem getPropertyItem(int n2) {
        List<PropertyItem> list = this.getCurrentImage().getPropertyItems();
        if (list != null) {
            for (PropertyItem propertyItem : list) {
                if (propertyItem.getId() != n2) continue;
                return propertyItem;
            }
        }
        return null;
    }

    public void removePropertyItem(int n2) {
        List<PropertyItem> list = this.getCurrentImage().getPropertyItems();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2).getId() != n2) continue;
                list.remove(i2);
            }
        }
    }

    public ImageFormat getRawFormat() {
        return this.getCurrentImage().getImageFormat();
    }

    public Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public float getVerticalResolution() {
        if (this.getCurrentImage().getVerticalResolution() <= 1.0f) {
            return GraphicsUtils.getDefaultScreenResolution();
        }
        return this.getCurrentImage().getVerticalResolution();
    }

    public int getWidth() {
        return this.getCurrentImage().getNativeImage().getWidth(null);
    }

    public Image getThumbnailImage(int n2, int n3, GetThumbnailImageAbort getThumbnailImageAbort, IntPtr intPtr) {
        if (n2 < 0 || n3 < 0 || n2 > 0 && n3 == 0) {
            throw new OutOfMemoryException();
        }
        java.awt.Image image = this.getCurrentImage().getNativeImage().getScaledInstance(n2, n3, 1);
        return Image.a(image, this.getRawFormat(), this.getInternalPixelFormat());
    }

    static Image a(java.awt.Image image, ImageFormat imageFormat, int n2) {
        if (image instanceof BufferedImage) {
            return new Bitmap(image, imageFormat);
        }
        BufferedImage bufferedImage = com.aspose.html.utils.ms.core.drawing.a.c.a(image.getWidth(null), image.getHeight(null), n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return new Bitmap(bufferedImage, imageFormat);
    }

    public static ImageInputStream InputStreamToImageInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[10240];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream = null;
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray2));
        return imageInputStream;
    }

    public static InputStream ImageInputStreamToInputStream(ImageInputStream imageInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[10240];
        int n2 = 0;
        while ((n2 = imageInputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream = null;
        return new ByteArrayInputStream(byArray2);
    }

    private void a(FrameDimension frameDimension) {
        FrameDimension[] frameDimensionArray;
        for (FrameDimension frameDimension2 : frameDimensionArray = this.b()) {
            if (!Guid.op_Equality(frameDimension.getGuid(), frameDimension2.getGuid())) continue;
            return;
        }
        throw new ExternalException("A generic error occurred in GDI+.");
    }

    private FrameDimension[] b() {
        ImageFormat imageFormat = this.getRawFormat();
        if (imageFormat.equals(ImageFormat.getTiff())) {
            return new FrameDimension[]{FrameDimension.getPage()};
        }
        if (imageFormat.equals(ImageFormat.getGif())) {
            return new FrameDimension[]{FrameDimension.getTime()};
        }
        if (imageFormat.equals(ImageFormat.getIcon())) {
            return new FrameDimension[]{FrameDimension.getPage(), FrameDimension.getTime(), FrameDimension.getResolution()};
        }
        return new FrameDimension[]{FrameDimension.getPage()};
    }

    public static interface GetThumbnailImageAbort {
        public boolean invoke();
    }

    public static final class ImageFlags {
        public static final int ImageFlagsNone = 0;
        public static final int ImageFlagsScalable = 1;
        public static final int ImageFlagsHasAlpha = 2;
        public static final int ImageFlagsHasTranslucent = 4;
        public static final int ImageFlagsPartiallyScalable = 8;
        public static final int ImageFlagsColorSpaceRGB = 16;
        public static final int ImageFlagsColorSpaceCMYK = 32;
        public static final int ImageFlagsColorSpaceGRAY = 64;
        public static final int ImageFlagsColorSpaceYCBCR = 128;
        public static final int ImageFlagsColorSpaceYCCK = 256;
        public static final int ImageFlagsHasRealDPI = 4096;
        public static final int ImageFlagsHasRealPixelSize = 8192;
        public static final int ImageFlagsReadOnly = 65536;
        public static final int ImageFlagsCaching = 131072;
        public static final int ImageFlagsUndocumented = 262144;

        static {
            Enum.register(new Enum.FlaggedEnum((Class)ImageFlags.class, Integer.class){
                {
                    this.addConstant("ImageFlagsNone", 0L);
                    this.addConstant("ImageFlagsScalable", 1L);
                    this.addConstant("ImageFlagsHasAlpha", 2L);
                    this.addConstant("ImageFlagsHasTranslucent", 4L);
                    this.addConstant("ImageFlagsPartiallyScalable", 8L);
                    this.addConstant("ImageFlagsColorSpaceRGB", 16L);
                    this.addConstant("ImageFlagsColorSpaceCMYK", 32L);
                    this.addConstant("ImageFlagsColorSpaceGRAY", 64L);
                    this.addConstant("ImageFlagsColorSpaceYCBCR", 128L);
                    this.addConstant("ImageFlagsColorSpaceYCCK", 256L);
                    this.addConstant("ImageFlagsHasRealDPI", 4096L);
                    this.addConstant("ImageFlagsHasRealPixelSize", 8192L);
                    this.addConstant("ImageFlagsReadOnly", 65536L);
                    this.addConstant("ImageFlagsCaching", 131072L);
                }
            });
        }
    }
}

