/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.System.StringExtensions;
import java.util.HashMap;
import java.util.Map;

public final class Char {
    public static final char MaxValue = '\uffff';
    public static final char MinValue = '\u0000';
    private static Map<Integer, Integer> a = new HashMap<Integer, Integer>();

    private static void a(int n2, int n3, int n4) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            a.put(i2, n4);
        }
    }

    public static int compareTo(char c2, char c3) {
        return c2 - c3;
    }

    public static int compareTo(char c2, Object object) {
        if (object == null) {
            return 1;
        }
        if (object.getClass() != Character.class) {
            throw new ArgumentException("Value is not a System.Char");
        }
        return c2 - Convert.toChar(object);
    }

    public static String convertFromUtf32(int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new ArgumentOutOfRangeException("utf32", "The argument must be from 0 to 0x10FFFF.");
        }
        if (55296 <= n2 && n2 <= 57343) {
            throw new ArgumentOutOfRangeException("utf32", "The argument must not be in surrogate pair range.");
        }
        if (n2 < 65536) {
            return StringExtensions.newString((char)n2, 1);
        }
        return StringExtensions.newString(new char[]{(char)(((n2 -= 65536) >> 10) + 55296), (char)(n2 % 1024 + 56320)});
    }

    public static int convertToUtf32(char c2, char c3) {
        if (c2 < '\ud800' || '\udbff' < c2) {
            throw new ArgumentOutOfRangeException("highSurrogate");
        }
        if (c3 < '\udc00' || '\udfff' < c3) {
            throw new ArgumentOutOfRangeException("lowSurrogate");
        }
        return 65536 + (c2 - 55296 << 10) + (c3 - 56320);
    }

    public static int convertToUtf32(String string, int n2) {
        Char.a(string, n2);
        if (!Char.isSurrogate(string.charAt(n2))) {
            return string.charAt(n2);
        }
        if (!Char.isHighSurrogate(string.charAt(n2)) || n2 == string.length() - 1 || !Char.isLowSurrogate(string.charAt(n2 + 1))) {
            throw new ArgumentException(StringExtensions.format("The string contains invalid surrogate pair character at {0}", n2));
        }
        return Char.convertToUtf32(string.charAt(n2), string.charAt(n2 + 1));
    }

    public static boolean equals(char c2, char c3) {
        return c2 == c3;
    }

    public static boolean equals(char c2, Object object) {
        return object.getClass() == Character.class && c2 == Convert.toChar(object);
    }

    public static int getHashCode(char c2) {
        return c2 | c2 << 16;
    }

    public static double getNumericValue(char c2) {
        return Character.getNumericValue(c2);
    }

    public static double getNumericValue(String string, int n2) {
        Char.a(string, n2);
        return Character.getNumericValue(string.charAt(n2));
    }

    public int getTypeCode() {
        return 4;
    }

    public static int getUnicodeCategory(char c2) {
        if (a.containsKey(c2)) {
            return a.get(c2);
        }
        int n2 = Character.getType(c2);
        return Char.a(n2);
    }

    private static int a(int n2) {
        int n3;
        switch (n2) {
            case 8: {
                n3 = 6;
                break;
            }
            case 23: {
                n3 = 18;
                break;
            }
            case 15: {
                n3 = 14;
                break;
            }
            case 26: {
                n3 = 26;
                break;
            }
            case 20: {
                n3 = 19;
                break;
            }
            case 9: {
                n3 = 8;
                break;
            }
            case 7: {
                n3 = 7;
                break;
            }
            case 22: {
                n3 = 21;
                break;
            }
            case 30: {
                n3 = 23;
                break;
            }
            case 16: {
                n3 = 15;
                break;
            }
            case 29: {
                n3 = 22;
                break;
            }
            case 10: {
                n3 = 9;
                break;
            }
            case 13: {
                n3 = 12;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 25: {
                n3 = 25;
                break;
            }
            case 4: {
                n3 = 3;
                break;
            }
            case 27: {
                n3 = 27;
                break;
            }
            case 6: {
                n3 = 5;
                break;
            }
            case 5: {
                n3 = 4;
                break;
            }
            case 11: {
                n3 = 10;
                break;
            }
            case 24: {
                n3 = 24;
                break;
            }
            case 28: {
                n3 = 28;
                break;
            }
            case 14: {
                n3 = 13;
                break;
            }
            case 18: {
                n3 = 17;
                break;
            }
            case 12: {
                n3 = 11;
                break;
            }
            case 21: {
                n3 = 20;
                break;
            }
            case 19: {
                n3 = 16;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            default: {
                n3 = 29;
                break;
            }
            case 1: {
                n3 = 0;
            }
        }
        return n3;
    }

    public static int getUnicodeCategory(String string, int n2) {
        Char.a(string, n2);
        if (Char.a(string.charAt(n2))) {
            return Char.getUnicodeCategory(string.charAt(n2));
        }
        return Char.a(Character.getType(Character.codePointAt(string, n2)));
    }

    public static boolean isControl(char c2) {
        return Char.getUnicodeCategory(c2) == 14;
    }

    public static boolean isControl(String string, int n2) {
        return Char.getUnicodeCategory(string, n2) == 14;
    }

    public static boolean isDigit(char c2) {
        return Char.getUnicodeCategory(c2) == 8;
    }

    public static boolean isDigit(String string, int n2) {
        return Char.getUnicodeCategory(string, n2) == 8;
    }

    public static boolean isHighSurrogate(char c2) {
        return c2 >= '\ud800' && c2 <= '\udbff';
    }

    public static boolean isHighSurrogate(String string, int n2) {
        Char.a(string, n2);
        return Char.isHighSurrogate(string.charAt(n2));
    }

    private static boolean a(char c2) {
        return c2 <= '\u00ff';
    }

    public static boolean isLetter(char c2) {
        return Char.getUnicodeCategory(c2) <= 4;
    }

    public static boolean isLetter(String string, int n2) {
        Char.a(string, n2);
        return Char.isLetter(string.charAt(n2));
    }

    public static boolean isLetterOrDigit(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 <= 4 || n2 == 8;
    }

    public static boolean isLetterOrDigit(String string, int n2) {
        Char.a(string, n2);
        return Char.isLetterOrDigit(string.charAt(n2));
    }

    public static boolean isLower(char c2) {
        return Char.getUnicodeCategory(c2) == 1;
    }

    public static boolean isLower(String string, int n2) {
        Char.a(string, n2);
        return Char.isLower(string.charAt(n2));
    }

    public static boolean isLowSurrogate(char c2) {
        return c2 >= '\udc00' && c2 <= '\udfff';
    }

    public static boolean isLowSurrogate(String string, int n2) {
        Char.a(string, n2);
        return Char.isLowSurrogate(string.charAt(n2));
    }

    public static boolean isNumber(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 >= 8 && n2 <= 10;
    }

    public static boolean isNumber(String string, int n2) {
        Char.a(string, n2);
        return Char.isNumber(string.charAt(n2));
    }

    public static boolean isPunctuation(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 >= 18 && n2 <= 24;
    }

    public static boolean isPunctuation(String string, int n2) {
        Char.a(string, n2);
        return Char.isPunctuation(string.charAt(n2));
    }

    public static boolean isSeparator(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 >= 11 && n2 <= 13;
    }

    public static boolean isSeparator(String string, int n2) {
        Char.a(string, n2);
        return Char.isSeparator(string.charAt(n2));
    }

    public static boolean isSurrogate(char c2) {
        return c2 >= '\ud800' && c2 <= '\udfff';
    }

    public static boolean isSurrogate(String string, int n2) {
        Char.a(string, n2);
        return Char.isSurrogate(string.charAt(n2));
    }

    public static boolean isSurrogatePair(char c2, char c3) {
        if (c2 < '\ud800' || c2 > '\udbff') {
            return false;
        }
        return c3 >= '\udc00' && c3 <= '\udfff';
    }

    public static boolean isSurrogatePair(String string, int n2) {
        Char.a(string, n2);
        return n2 + 1 < string.length() && Char.isSurrogatePair(string.charAt(n2), string.charAt(n2 + 1));
    }

    public static boolean isSymbol(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 >= 25 && n2 <= 28;
    }

    public static boolean isSymbol(String string, int n2) {
        Char.a(string, n2);
        return Char.isSymbol(string.charAt(n2));
    }

    public static boolean isUpper(char c2) {
        return Char.getUnicodeCategory(c2) == 0;
    }

    public static boolean isUpper(String string, int n2) {
        Char.a(string, n2);
        return Char.isUpper(string.charAt(n2));
    }

    public static boolean isWhiteSpace(char c2) {
        if (c2 < '\u1680') {
            return c2 == ' ' || c2 >= '\t' && c2 <= '\r' || c2 == '\u0085' || c2 == '\u00a0';
        }
        int n2 = Char.a(Character.getType(c2));
        return n2 > 10 && n2 <= 13 && c2 != '\u200b';
    }

    public static boolean isWhiteSpace(String string, int n2) {
        Char.a(string, n2);
        return Char.isWhiteSpace(string.charAt(n2));
    }

    public static char parse(String string) {
        if (string == null) {
            throw new ArgumentNullException("s");
        }
        if (string.length() != 1) {
            throw new FormatException("s contains more than one character.");
        }
        return string.charAt(0);
    }

    public static char toLower(char c2) {
        return Char.toLower(c2, CultureInfo.getCurrentCulture());
    }

    public static char toLower(char c2, CultureInfo cultureInfo) {
        if (cultureInfo == null) {
            throw new ArgumentNullException("culture");
        }
        return cultureInfo.getTextInfo().toLower(c2);
    }

    public static char toLowerInvariant(char c2) {
        return Character.toLowerCase(c2);
    }

    public static String toString(char c2) {
        return StringExtensions.newString(c2, 1);
    }

    public static String toString(char c2, IFormatProvider iFormatProvider) {
        return Char.toString(c2);
    }

    public static char toUpper(char c2) {
        return Char.toUpper(c2, CultureInfo.getCurrentCulture());
    }

    public static char toUpper(char c2, CultureInfo cultureInfo) {
        if (cultureInfo == null) {
            throw new ArgumentNullException("culture");
        }
        return cultureInfo.getTextInfo().toUpper(c2);
    }

    public static char toUpperInvariant(char c2) {
        return Character.toUpperCase(c2);
    }

    public static boolean tryParse(String string, char[] cArray) {
        if (string == null || string.length() != 1) {
            cArray[0] = '\u0000';
            return false;
        }
        cArray[0] = string.charAt(0);
        return true;
    }

    private static void a(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("s");
        }
        if (n2 < 0 || n2 >= string.length()) {
            throw new ArgumentOutOfRangeException("The value of index is less than zero, or greater than or equal to the length of s.");
        }
    }

    static {
        Char.a(2209, 2228, 4);
        Char.a(3558, 3567, 8);
        Char.a(5024, 5109, 0);
        Char.a(5112, 5117, 1);
        Char.a(5873, 5880, 4);
        Char.a(6576, 6592, 4);
        Char.a(6832, 6845, 5);
        Char.a(7084, 7085, 5);
        Char.a(7655, 7669, 5);
        Char.a(8294, 8297, 15);
        Char.a(8379, 8382, 26);
        Char.a(8586, 8587, 28);
        Char.a(9204, 9210, 28);
        Char.a(11085, 11087, 28);
        Char.a(11098, 11123, 28);
        Char.a(11126, 11157, 28);
        Char.a(11160, 11193, 28);
        Char.a(11197, 11208, 28);
        Char.a(11210, 11217, 28);
        Char.a(11244, 11247, 28);
        Char.a(11836, 11839, 24);
        Char.a(40909, 40917, 4);
        Char.a(42900, 42901, 1);
        Char.a(42923, 42925, 0);
        Char.a(42928, 42935, 0);
        Char.a(43488, 43492, 4);
        Char.a(43495, 43503, 4);
        Char.a(43504, 43513, 8);
        Char.a(43514, 43518, 4);
        Char.a(43646, 43647, 4);
        Char.a(43824, 43866, 1);
        Char.a(43868, 43871, 3);
        Char.a(43872, 43877, 1);
        Char.a(43888, 43967, 1);
        Char.a(65063, 65071, 5);
        a.put(167, 28);
        a.put(170, 1);
        a.put(173, 19);
        a.put(182, 28);
        a.put(186, 1);
        a.put(895, 0);
        a.put(1320, 0);
        a.put(1321, 1);
        a.put(1322, 0);
        a.put(1323, 1);
        a.put(1324, 0);
        a.put(1325, 1);
        a.put(1326, 0);
        a.put(1327, 1);
        a.put(1421, 28);
        a.put(1422, 28);
        a.put(1541, 15);
        a.put(1564, 15);
        a.put(2275, 5);
        a.put(2303, 5);
        a.put(2424, 4);
        a.put(2432, 4);
        a.put(2809, 4);
        a.put(3072, 5);
        a.put(3124, 4);
        a.put(3162, 4);
        a.put(3201, 5);
        a.put(3329, 5);
        a.put(3423, 4);
        a.put(6158, 15);
        a.put(6429, 4);
        a.put(6430, 4);
        a.put(6430, 4);
        a.put(6600, 4);
        a.put(6601, 4);
        a.put(6683, 5);
        a.put(6846, 7);
        a.put(7416, 5);
        a.put(7417, 5);
        a.put(8968, 20);
        a.put(8969, 21);
        a.put(8970, 20);
        a.put(8971, 21);
        a.put(9984, 28);
        a.put(11840, 19);
        a.put(11841, 24);
        a.put(11842, 20);
        a.put(42648, 0);
        a.put(42649, 1);
        a.put(42650, 0);
        a.put(42651, 1);
        a.put(42652, 3);
        a.put(42653, 3);
        a.put(42654, 5);
        a.put(42895, 4);
        a.put(42902, 0);
        a.put(42903, 1);
        a.put(42904, 0);
        a.put(42905, 1);
        a.put(42906, 0);
        a.put(42907, 1);
        a.put(42908, 0);
        a.put(42909, 1);
        a.put(42910, 0);
        a.put(42911, 1);
        a.put(42933, 1);
        a.put(42935, 1);
        a.put(42999, 4);
        a.put(43260, 24);
        a.put(43261, 4);
        a.put(43493, 5);
        a.put(43494, 3);
        a.put(43644, 5);
        a.put(43645, 6);
        a.put(43867, 27);
        a.put(64830, 21);
        a.put(64831, 20);
    }
}

