/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aAY;
import com.aspose.html.utils.aBA;
import com.aspose.html.utils.aBK;
import com.aspose.html.utils.aBL;
import com.aspose.html.utils.aBN;
import com.aspose.html.utils.aBW;
import com.aspose.html.utils.aBd;
import com.aspose.html.utils.aBk;
import com.aspose.html.utils.aBn;
import com.aspose.html.utils.aBv;
import com.aspose.html.utils.aVl;
import com.aspose.html.utils.aXl;
import com.aspose.html.utils.aXu;
import com.aspose.html.utils.atE;
import com.aspose.html.utils.atH;
import com.aspose.html.utils.atJ;
import com.aspose.html.utils.atK;
import com.aspose.html.utils.atP;
import com.aspose.html.utils.ats;
import com.aspose.html.utils.aum;
import com.aspose.html.utils.auu;
import com.aspose.html.utils.auv;
import com.aspose.html.utils.auxx;
import com.aspose.html.utils.azt;
import com.aspose.html.utils.azu;
import com.aspose.html.utils.azv;
import com.aspose.html.utils.azx;
import com.aspose.html.utils.bfJ;
import com.aspose.html.utils.bfS;
import com.aspose.html.utils.bfy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class aXs
extends X509Certificate {
    private final aVl lWc;
    private final aBA lWd;
    private final aBv lWe;
    private final boolean[] lWf;
    private volatile PublicKey publicKeyValue;
    private volatile boolean hashValueSet;
    private volatile int hashValue;

    public aXs(aVl aVl2, aBA aBA2) throws CertificateParsingException {
        byte[] byArray;
        this.lWc = aVl2;
        this.lWd = aBA2;
        try {
            byArray = this.getExtensionBytes("2.5.29.19");
            this.lWe = byArray != null ? aBv.gO(atJ.aP(byArray)) : null;
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
        try {
            byArray = this.getExtensionBytes("2.5.29.15");
            if (byArray != null) {
                aum aum2 = aum.bM(atJ.aP(byArray));
                int n2 = (byArray = aum2.getBytes()).length * 8 - aum2.getPadBits();
                this.lWf = new boolean[n2 < 9 ? 9 : n2];
                for (int i2 = 0; i2 != n2; ++i2) {
                    this.lWf[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
                }
            } else {
                this.lWf = null;
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.lWd.beZ().getTime());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.lWd.beY().getTime());
        }
    }

    public int getVersion() {
        return this.lWd.getVersionNumber();
    }

    public BigInteger getSerialNumber() {
        return this.lWd.aYV().getValue();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            atH atH2 = new atH(byteArrayOutputStream);
            atH2.b(this.lWd.bah());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            atH atH2 = new atH(byteArrayOutputStream);
            atH2.b(this.lWd.baj());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Date getNotBefore() {
        return this.lWd.beY().getDate();
    }

    public Date getNotAfter() {
        return this.lWd.beZ().getDate();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.lWd.beX().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.lWd.baG().getOctets();
    }

    public String getSigAlgName() {
        Object object;
        aVl aVl2 = this.lWc;
        if (aVl2 != null && (object = aVl2.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i2 = 0; i2 != ((Provider[])object).length; ++i2) {
            String string = object[i2].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.lWd.aYH().bdQ().getId();
    }

    public byte[] getSigAlgParams() {
        if (this.lWd.aYH().bdR() != null) {
            try {
                return this.lWd.aYH().bdR().aWp().getEncoded("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        aum aum2 = this.lWd.beX().bfY();
        if (aum2 != null) {
            byte[] byArray = aum2.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - aum2.getPadBits()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        aum aum2 = this.lWd.beX().bfZ();
        if (aum2 != null) {
            byte[] byArray = aum2.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - aum2.getPadBits()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        return this.lWf;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.getExtensionBytes("2.5.29.37");
        if (byArray != null) {
            try {
                atK atK2 = atK.bH(byArray);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i2 = 0; i2 != atK2.size(); ++i2) {
                    arrayList.add(((atE)atK2.lB(i2)).getId());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        if (this.lWe != null) {
            if (this.lWe.isCA()) {
                if (this.lWe.getPathLenConstraint() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.lWe.getPathLenConstraint().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return aXs.getAlternativeNames(this.getExtensionBytes(aBK.kaK.getId()));
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return aXs.getAlternativeNames(this.getExtensionBytes(aBK.kaL.getId()));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            aBL aBL2 = this.lWd.beX().ban();
            if (aBL2 != null) {
                Enumeration enumeration = aBL2.oids();
                while (enumeration.hasMoreElements()) {
                    atE atE2 = (atE)enumeration.nextElement();
                    aBK aBK2 = aBL2.q(atE2);
                    if (!aBK2.isCritical()) continue;
                    hashSet.add(atE2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] getExtensionBytes(String string) {
        aBK aBK2;
        aBL aBL2 = this.lWd.beX().ban();
        if (aBL2 != null && (aBK2 = aBL2.q(new atE(string))) != null) {
            return aBK2.bfo().getOctets();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        aBK aBK2;
        aBL aBL2 = this.lWd.beX().ban();
        if (aBL2 != null && (aBK2 = aBL2.q(new atE(string))) != null) {
            try {
                return aBK2.bfo().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            aBL aBL2 = this.lWd.beX().ban();
            if (aBL2 != null) {
                Enumeration enumeration = aBL2.oids();
                while (enumeration.hasMoreElements()) {
                    atE atE2 = (atE)enumeration.nextElement();
                    aBK aBK2 = aBL2.q(atE2);
                    if (aBK2.isCritical()) continue;
                    hashSet.add(atE2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        aBL aBL2;
        if (this.getVersion() == 3 && (aBL2 = this.lWd.beX().ban()) != null) {
            Set set = this.getCriticalExtensionOIDs();
            set.removeAll(aXl.lVQ);
            return !set.isEmpty();
        }
        return false;
    }

    public PublicKey getPublicKey() {
        try {
            if (this.publicKeyValue == null) {
                this.publicKeyValue = this.lWc.q(this.lWd.bdc());
            }
            return this.publicKeyValue;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.lWd.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof aXs) {
            aXs aXs2 = (aXs)object;
            if (this.hashValueSet && aXs2.hashValueSet && this.hashValue != aXs2.hashValue) {
                return false;
            }
            return this.lWd.equals(aXs2.lWd);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = super.hashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = bfJ.lineSeparator();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(bfJ.fromByteArray(bfS.encode(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(bfJ.fromByteArray(bfS.encode(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(bfJ.fromByteArray(bfS.encode(byArray, i2, byArray.length - i2))).append(string);
        }
        aBL aBL2 = this.lWd.beX().ban();
        if (aBL2 != null) {
            Enumeration enumeration = aBL2.oids();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                atE atE2 = (atE)enumeration.nextElement();
                aBK aBK2 = aBL2.q(atE2);
                if (aBK2.bfo() != null) {
                    byte[] byArray2 = aBK2.bfo().getOctets();
                    stringBuffer.append("                       critical(").append(aBK2.isCritical()).append(") ");
                    try {
                        atJ atJ2 = atJ.aP(byArray2);
                        if (atE2.equals(aBK.kaM)) {
                            stringBuffer.append(aBv.gO(atJ2)).append(string);
                            continue;
                        }
                        if (atE2.equals(aBK.kaI)) {
                            stringBuffer.append(aBW.hn(atJ2)).append(string);
                            continue;
                        }
                        if (atE2.equals(azt.jLg)) {
                            stringBuffer.append(new azu((aum)atJ2)).append(string);
                            continue;
                        }
                        if (atE2.equals(azt.jLi)) {
                            stringBuffer.append(new azv((auu)atJ2)).append(string);
                            continue;
                        }
                        if (atE2.equals(azt.jLp)) {
                            stringBuffer.append(new azx((auu)atJ2)).append(string);
                            continue;
                        }
                        stringBuffer.append(atE2.getId());
                        stringBuffer.append(" value = ").append(aAY.dumpAsString(atJ2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(atE2.getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = aXu.v(this.lWd.aYH());
        Signature signature = this.getSignatureFromProvider(this.lWc, string);
        this.checkSignature(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = aXu.v(this.lWd.aYH());
        Signature signature = string != null ? Signature.getInstance(string2, string) : Signature.getInstance(string2);
        this.checkSignature(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String string = aXu.v(this.lWd.aYH());
        Signature signature = this.getSignatureFromProvider(provider, string);
        this.checkSignature(publicKey, signature);
    }

    private Signature getSignatureFromProvider(Provider provider, String string) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return Signature.getInstance(string, provider);
            }
            catch (Exception exception) {
                return Signature.getInstance(string);
            }
        }
        return Signature.getInstance(string);
    }

    private void checkSignature(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.a(this.lWd.aYH(), this.lWd.beX().beQ())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        ats ats2 = this.lWd.aYH().bdR();
        aXu.a(signature, ats2);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private boolean a(aBn aBn2, aBn aBn3) {
        if (!aBn2.bdQ().equals(aBn3.bdQ())) {
            return false;
        }
        if (aBn2.bdR() == null) {
            return aBn3.bdR() == null || aBn3.bdR().equals(auv.jqJ);
        }
        if (aBn3.bdR() == null) {
            return aBn2.bdR() == null || aBn2.bdR().equals(auv.jqJ);
        }
        return aBn2.bdR().equals(aBn3.bdR());
    }

    private static Collection getAlternativeNames(byte[] byArray) throws CertificateParsingException {
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = atK.bH(byArray).getObjects();
            block11: while (enumeration.hasMoreElements()) {
                aBN aBN2 = aBN.hf(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(bfy.valueOf(aBN2.getTagNo()));
                switch (aBN2.getTagNo()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(aBN2.getEncoded());
                        break;
                    }
                    case 4: {
                        arrayList2.add(aBd.a(aBk.jZC, aBN2.bfl()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((atP)((Object)aBN2.bfl())).getString());
                        break;
                    }
                    case 8: {
                        arrayList2.add(atE.bF(aBN2.bfl()).getId());
                        break;
                    }
                    case 7: {
                        String string;
                        byte[] byArray2 = auxx.bG(aBN2.bfl()).getOctets();
                        try {
                            string = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + aBN2.getTagNo());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }
}

