/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aAY;
import com.aspose.html.utils.aBB;
import com.aspose.html.utils.aBK;
import com.aspose.html.utils.aBL;
import com.aspose.html.utils.aBO;
import com.aspose.html.utils.aBU;
import com.aspose.html.utils.aBd;
import com.aspose.html.utils.aBw;
import com.aspose.html.utils.aBx;
import com.aspose.html.utils.aCp;
import com.aspose.html.utils.aCq;
import com.aspose.html.utils.aXl;
import com.aspose.html.utils.aXq;
import com.aspose.html.utils.aXu;
import com.aspose.html.utils.atB;
import com.aspose.html.utils.atD;
import com.aspose.html.utils.atE;
import com.aspose.html.utils.atF;
import com.aspose.html.utils.atJ;
import com.aspose.html.utils.bfJ;
import com.aspose.html.utils.bfS;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class aXr
extends X509CRL {
    private final Provider lVX;
    private final aBB lVY;
    private final String lVZ;
    private final byte[] lWa;
    private final boolean lWb;
    private volatile boolean isHashCodeSet = false;
    private volatile int hashCodeValue;

    static boolean isIndirectCRL(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(aBK.kaS.getId());
            return byArray != null && aBU.hl(atF.bG(byArray).getOctets()).isIndirectCRL();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected aXr(Provider provider, aBB aBB2) throws CRLException {
        this.lVX = provider;
        this.lVY = aBB2;
        try {
            this.lVZ = aXu.v(aBB2.aYH());
            this.lWa = (byte[])(aBB2.aYH().bdR() != null ? aBB2.aYH().bdR().aWp().getEncoded("DER") : null);
            this.lWb = aXr.isIndirectCRL(this);
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(aXl.lVR);
        return !set.isEmpty();
    }

    private Set getExtensionOIDs(boolean bl2) {
        aBL aBL2;
        if (this.getVersion() == 2 && (aBL2 = this.lVY.bfa().ban()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = aBL2.oids();
            while (enumeration.hasMoreElements()) {
                atE atE2 = (atE)enumeration.nextElement();
                aBK aBK2 = aBL2.q(atE2);
                if (bl2 != aBK2.isCritical()) continue;
                hashSet.add(atE2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String string) {
        aBK aBK2;
        aBL aBL2 = this.lVY.bfa().ban();
        if (aBL2 != null && (aBK2 = aBL2.q(new atE(string))) != null) {
            try {
                return aBK2.bfo().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        try {
            return this.lVY.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.lVX);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.doVerify(publicKey, signature);
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null ? Signature.getInstance(this.getSigAlgName(), string) : Signature.getInstance(this.getSigAlgName());
        this.doVerify(publicKey, signature);
    }

    public void verify(PublicKey publicKey, Provider provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = provider != null ? Signature.getInstance(this.getSigAlgName(), provider) : Signature.getInstance(this.getSigAlgName());
        this.doVerify(publicKey, signature);
    }

    private void doVerify(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.lVY.aYH().equals(this.lVY.bfa().beQ())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.lWa != null) {
            try {
                aXu.a(signature, atJ.aP(this.lWa));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    public int getVersion() {
        return this.lVY.getVersionNumber();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.lVY.bah().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getThisUpdate() {
        return this.lVY.bfc().getDate();
    }

    public Date getNextUpdate() {
        if (this.lVY.bfd() != null) {
            return this.lVY.bfd().getDate();
        }
        return null;
    }

    private Set loadCRLEntries() {
        HashSet<aXq> hashSet = new HashSet<aXq>();
        Enumeration enumeration = this.lVY.getRevokedCertificateEnumeration();
        aBd aBd2 = null;
        while (enumeration.hasMoreElements()) {
            aBK aBK2;
            aCp.a a2 = (aCp.a)enumeration.nextElement();
            aXq aXq2 = new aXq(a2, this.lWb, aBd2);
            hashSet.add(aXq2);
            if (!this.lWb || !a2.hasExtensions() || (aBK2 = a2.ban().q(aBK.kaT)) == null) continue;
            aBd2 = aBd.gE(aBO.hg(aBK2.bfp()).bfu()[0].bfl());
        }
        return hashSet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.lVY.getRevokedCertificateEnumeration();
        aBd aBd2 = null;
        while (enumeration.hasMoreElements()) {
            aBK aBK2;
            aCp.a a2 = (aCp.a)enumeration.nextElement();
            if (bigInteger.equals(a2.bfW().getValue())) {
                return new aXq(a2, this.lWb, aBd2);
            }
            if (!this.lWb || !a2.hasExtensions() || (aBK2 = a2.ban().q(aBK.kaT)) == null) continue;
            aBd2 = aBd.gE(aBO.hg(aBK2.bfp()).bfu()[0].bfl());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.loadCRLEntries();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.lVY.bfa().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.lVY.baG().getOctets();
    }

    public String getSigAlgName() {
        return this.lVZ;
    }

    public String getSigAlgOID() {
        return this.lVY.aYH().bdQ().getId();
    }

    public byte[] getSigAlgParams() {
        if (this.lWa != null) {
            byte[] byArray = new byte[this.lWa.length];
            System.arraycopy(this.lWa, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = bfJ.lineSeparator();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(bfJ.fromByteArray(bfS.encode(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(bfJ.fromByteArray(bfS.encode(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(bfJ.fromByteArray(bfS.encode(byArray, i2, byArray.length - i2))).append(string);
        }
        aBL aBL2 = this.lVY.bfa().ban();
        if (aBL2 != null) {
            object2 = aBL2.oids();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (atE)object2.nextElement();
                aBK aBK2 = aBL2.q((atE)object);
                if (aBK2.bfo() != null) {
                    byte[] byArray2 = aBK2.bfo().getOctets();
                    stringBuffer.append("                       critical(").append(aBK2.isCritical()).append(") ");
                    try {
                        atJ atJ2 = atJ.aP(byArray2);
                        if (((atJ)object).equals(aBK.kaN)) {
                            stringBuffer.append(new aBx(atB.bD(atJ2).getPositiveValue())).append(string);
                            continue;
                        }
                        if (((atJ)object).equals(aBK.kaR)) {
                            stringBuffer.append("Base CRL: " + new aBx(atB.bD(atJ2).getPositiveValue())).append(string);
                            continue;
                        }
                        if (((atJ)object).equals(aBK.kaS)) {
                            stringBuffer.append(aBU.hl(atJ2)).append(string);
                            continue;
                        }
                        if (((atJ)object).equals(aBK.kaV)) {
                            stringBuffer.append(aBw.gP(atJ2)).append(string);
                            continue;
                        }
                        if (((atJ)object).equals(aBK.kbb)) {
                            stringBuffer.append(aBw.gP(atJ2)).append(string);
                            continue;
                        }
                        stringBuffer.append(((atE)object).getId());
                        stringBuffer.append(" value = ").append(aAY.dumpAsString(atJ2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((atE)object).getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.lVY.getRevokedCertificateEnumeration();
        aBd aBd2 = this.lVY.bah();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                atD atD2;
                aCp.a a2 = aCp.a.hC(enumeration.nextElement());
                if (this.lWb && a2.hasExtensions() && (atD2 = a2.ban().q(aBK.kaT)) != null) {
                    aBd2 = aBd.gE(aBO.hg(atD2.bfp()).bfu()[0].bfl());
                }
                if (!a2.bfW().getValue().equals(bigInteger)) continue;
                if (certificate instanceof X509Certificate) {
                    atD2 = aBd.gE(((X509Certificate)certificate).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        atD2 = aCq.hD(certificate.getEncoded()).bah();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return aBd2.equals(atD2);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        if (object instanceof aXr) {
            boolean bl2;
            aXr aXr2 = (aXr)object;
            if (this.isHashCodeSet && (bl2 = aXr2.isHashCodeSet) && aXr2.hashCodeValue != this.hashCodeValue) {
                return false;
            }
            return this.lVY.equals(aXr2.lVY);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.isHashCodeSet) {
            this.hashCodeValue = super.hashCode();
            this.isHashCodeSet = true;
        }
        return this.hashCodeValue;
    }
}

