/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aBK;
import com.aspose.html.utils.atB;
import com.aspose.html.utils.atF;
import com.aspose.html.utils.bfE;
import com.aspose.html.utils.bfr;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class aUu<T extends CRL>
implements bfE<T> {
    private final CRLSelector lrl;
    private final boolean lrm;
    private final boolean lrn;
    private final BigInteger lro;
    private final byte[] lrp;
    private final boolean lrq;

    private aUu(a a2) {
        this.lrl = a2.lrr;
        this.lrm = a2.deltaCRLIndicator;
        this.lrn = a2.completeCRLEnabled;
        this.lro = a2.maxBaseCRLNumber;
        this.lrp = a2.issuingDistributionPoint;
        this.lrq = a2.issuingDistributionPointEnabled;
    }

    public boolean isIssuingDistributionPointEnabled() {
        return this.lrq;
    }

    @Override
    public boolean match(CRL cRL) {
        byte[] byArray;
        if (!(cRL instanceof X509CRL)) {
            return this.lrl.match(cRL);
        }
        X509CRL x509CRL = (X509CRL)cRL;
        atB atB2 = null;
        try {
            byArray = x509CRL.getExtensionValue(aBK.kaR.getId());
            if (byArray != null) {
                atB2 = atB.bD(atF.bG(byArray).getOctets());
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (this.isDeltaCRLIndicatorEnabled() && atB2 == null) {
            return false;
        }
        if (this.isCompleteCRLEnabled() && atB2 != null) {
            return false;
        }
        if (atB2 != null && this.lro != null && atB2.getPositiveValue().compareTo(this.lro) == 1) {
            return false;
        }
        if (this.lrq) {
            byArray = x509CRL.getExtensionValue(aBK.kaS.getId());
            if (this.lrp == null ? byArray != null : !bfr.areEqual(byArray, this.lrp)) {
                return false;
            }
        }
        return this.lrl.match(cRL);
    }

    public boolean isDeltaCRLIndicatorEnabled() {
        return this.lrm;
    }

    @Override
    public Object clone() {
        return this;
    }

    public boolean isCompleteCRLEnabled() {
        return this.lrn;
    }

    public BigInteger getMaxBaseCRLNumber() {
        return this.lro;
    }

    public byte[] getIssuingDistributionPoint() {
        return bfr.clone(this.lrp);
    }

    public X509Certificate getCertificateChecking() {
        if (this.lrl instanceof X509CRLSelector) {
            return ((X509CRLSelector)this.lrl).getCertificateChecking();
        }
        return null;
    }

    public static Collection<? extends CRL> a(aUu aUu2, CertStore certStore) throws CertStoreException {
        return certStore.getCRLs(new b(aUu2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class a {
        private final CRLSelector lrr;
        private boolean deltaCRLIndicator = false;
        private boolean completeCRLEnabled = false;
        private BigInteger maxBaseCRLNumber = null;
        private byte[] issuingDistributionPoint = null;
        private boolean issuingDistributionPointEnabled = false;

        public a(CRLSelector cRLSelector) {
            this.lrr = (CRLSelector)cRLSelector.clone();
        }

        public a fd(boolean bl2) {
            this.completeCRLEnabled = bl2;
            return this;
        }

        public a fe(boolean bl2) {
            this.deltaCRLIndicator = bl2;
            return this;
        }

        public void setMaxBaseCRLNumber(BigInteger bigInteger) {
            this.maxBaseCRLNumber = bigInteger;
        }

        public void setIssuingDistributionPointEnabled(boolean bl2) {
            this.issuingDistributionPointEnabled = bl2;
        }

        public void setIssuingDistributionPoint(byte[] byArray) {
            this.issuingDistributionPoint = bfr.clone(byArray);
        }

        public aUu<? extends CRL> bon() {
            return new aUu(this);
        }
    }

    static class b
    extends X509CRLSelector {
        private final aUu lrs;

        b(aUu aUu2) {
            this.lrs = aUu2;
            if (aUu2.lrl instanceof X509CRLSelector) {
                X509CRLSelector x509CRLSelector = (X509CRLSelector)aUu2.lrl;
                this.setCertificateChecking(x509CRLSelector.getCertificateChecking());
                this.setDateAndTime(x509CRLSelector.getDateAndTime());
                this.setIssuers(x509CRLSelector.getIssuers());
                this.setMinCRLNumber(x509CRLSelector.getMinCRL());
                this.setMaxCRLNumber(x509CRLSelector.getMaxCRL());
            }
        }

        public boolean match(CRL cRL) {
            return this.lrs == null ? cRL != null : this.lrs.match(cRL);
        }
    }
}

