/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aBa;
import com.aspose.html.utils.aBc;
import com.aspose.html.utils.aBd;
import com.aspose.html.utils.aBi;
import com.aspose.html.utils.aTF;
import com.aspose.html.utils.aUc;
import com.aspose.html.utils.bfJ;
import com.aspose.html.utils.bfS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class aUa
implements aUc {
    private static Logger LOG = Logger.getLogger(aUa.class.getName());
    private final Set<String> lqs;

    public aUa(Set<String> set) {
        this.lqs = set;
    }

    @Override
    public boolean verified(String string, SSLSession sSLSession) throws IOException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(sSLSession.getPeerCertificates()[0].getEncoded()));
            return this.verify(string, x509Certificate);
        }
        catch (Exception exception) {
            if (exception instanceof aTF) {
                throw (aTF)exception;
            }
            throw new aTF(exception.getMessage(), exception);
        }
    }

    public boolean verify(String string, X509Certificate x509Certificate) throws IOException {
        aBc[] aBcArray;
        try {
            aBcArray = x509Certificate.getSubjectAlternativeNames();
            if (aBcArray != null) {
                block6: for (List<?> list : aBcArray) {
                    int n2 = ((Number)list.get(0)).intValue();
                    switch (n2) {
                        case 2: {
                            if (!aUa.isValidNameMatch(string, list.get(1).toString(), this.lqs)) continue block6;
                            return true;
                        }
                        case 7: {
                            if (!InetAddress.getByName(string).equals(InetAddress.getByName(list.get(1).toString()))) continue block6;
                            return true;
                        }
                    }
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    String string2 = list.get(1) instanceof byte[] ? bfS.toHexString((byte[])list.get(1)) : list.get(1).toString();
                    LOG.log(Level.INFO, "ignoring type " + n2 + " value = " + string2);
                }
                return false;
            }
        }
        catch (Exception exception) {
            throw new aTF(exception.getMessage(), exception);
        }
        if (x509Certificate.getSubjectX500Principal() == null) {
            return false;
        }
        aBcArray = aBd.gE(x509Certificate.getSubjectX500Principal().getEncoded()).beD();
        for (int i2 = aBcArray.length - 1; i2 >= 0; --i2) {
            aBc aBc2 = aBcArray[i2];
            aBa[] aBaArray = aBc2.beC();
            for (int i3 = 0; i3 != aBaArray.length; ++i3) {
                aBa aBa2 = aBaArray[i3];
                if (!aBa2.aZt().equals(aBi.jXZ)) continue;
                return aUa.isValidNameMatch(string, aBa2.aZu().toString(), this.lqs);
            }
        }
        return false;
    }

    public static boolean isValidNameMatch(String string, String string2, Set<String> set) throws IOException {
        if (string2.contains("*")) {
            int n2 = string2.indexOf(42);
            if (n2 == string2.lastIndexOf("*")) {
                if (string2.contains("..") || string2.charAt(string2.length() - 1) == '*') {
                    return false;
                }
                int n3 = string2.indexOf(46, n2);
                if (set != null && set.contains(bfJ.toLowerCase(string2.substring(n3)))) {
                    throw new IOException("Wildcard `" + string2 + "` matches known public suffix.");
                }
                String string3 = bfJ.toLowerCase(string2.substring(n2 + 1));
                String string4 = bfJ.toLowerCase(string);
                if (string4.equals(string3)) {
                    return false;
                }
                if (string3.length() > string4.length()) {
                    return false;
                }
                if (n2 > 0) {
                    if (string4.startsWith(string2.substring(0, n2)) && string4.endsWith(string3)) {
                        return string4.substring(n2, string4.length() - string3.length()).indexOf(46) < 0;
                    }
                    return false;
                }
                String string5 = string4.substring(0, string4.length() - string3.length());
                if (string5.indexOf(46) > 0) {
                    return false;
                }
                return string4.endsWith(string3);
            }
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }
}

