/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aPV;
import com.aspose.html.utils.aQa;
import com.aspose.html.utils.aQp;
import com.aspose.html.utils.aRb;
import com.aspose.html.utils.aRs;

public class aQT
implements aQp {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private aPV kVG;
    private aRs kXB;
    private int macSize;

    public aQT(aPV aPV2) {
        this(aPV2, aPV2.getBlockSize() * 8 / 2, null);
    }

    public aQT(aPV aPV2, aRs aRs2) {
        this(aPV2, aPV2.getBlockSize() * 8 / 2, aRs2);
    }

    public aQT(aPV aPV2, int n2) {
        this(aPV2, n2, null);
    }

    public aQT(aPV aPV2, int n2, aRs aRs2) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.kVG = new aRb(aPV2);
        this.kXB = aRs2;
        this.macSize = n2 / 8;
        this.mac = new byte[aPV2.getBlockSize()];
        this.buf = new byte[aPV2.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return this.kVG.getAlgorithmName();
    }

    public void a(aQa aQa2) {
        this.reset();
        this.kVG.a(true, aQa2);
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by2) {
        if (this.bufOff == this.buf.length) {
            this.kVG.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by2;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.kVG.getBlockSize();
        int n5 = n4 - this.bufOff;
        if (n3 > n5) {
            System.arraycopy(byArray, n2, this.buf, this.bufOff, n5);
            this.kVG.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            n3 -= n5;
            n2 += n5;
            while (n3 > n4) {
                this.kVG.processBlock(byArray, n2, this.mac, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.kVG.getBlockSize();
        if (this.kXB == null) {
            while (this.bufOff < n3) {
                this.buf[this.bufOff] = 0;
                ++this.bufOff;
            }
        } else {
            if (this.bufOff == n3) {
                this.kVG.processBlock(this.buf, 0, this.mac, 0);
                this.bufOff = 0;
            }
            this.kXB.addPadding(this.buf, this.bufOff);
        }
        this.kVG.processBlock(this.buf, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, byArray, n2, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.kVG.reset();
    }
}

