/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aIz;
import com.aspose.html.utils.aPV;
import com.aspose.html.utils.bfS;
import java.util.HashMap;
import java.util.Map;

class aPP {
    private static final long liE = 32768L;
    private static final long liF = 0x800000L;
    private static final int liG = 4096;
    private static final int liH = 262144;
    private static final Map<String, byte[][]> liI = new HashMap<String, byte[][]>();
    private aPV laf;
    private aIz kvl;
    private final byte[] liJ;
    private final byte[] liK;
    private final byte[] liL;
    private byte[] V;
    private long reseedCounter = 1L;

    public aPP(aPV aPV2, byte[] byArray, aIz aIz2) {
        this.laf = aPV2;
        this.kvl = aIz2;
        this.liJ = new byte[aPV2.getBlockSize()];
        System.arraycopy(byArray, 0, this.liJ, 0, this.liJ.length);
        this.liK = new byte[aPV2.getBlockSize()];
        this.liL = new byte[aPV2.getBlockSize()];
    }

    public int getBlockSize() {
        return this.laf.getBlockSize() * 8;
    }

    int generate(byte[] byArray, boolean bl2) {
        int n2;
        if (this.liL.length == 8) {
            if (this.reseedCounter > 32768L) {
                return -1;
            }
            if (aPP.isTooLarge(byArray, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this.reseedCounter > 0x800000L) {
                return -1;
            }
            if (aPP.isTooLarge(byArray, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (bl2 || this.V == null) {
            this.V = this.getEntropy();
        }
        int n3 = byArray.length / this.liL.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.laf.processBlock(this.liJ, 0, this.liK, 0);
            this.process(this.liL, this.liK, this.V);
            this.process(this.V, this.liL, this.liK);
            System.arraycopy(this.liL, 0, byArray, n2 * this.liL.length, this.liL.length);
            this.increment(this.liJ);
        }
        n2 = byArray.length - n3 * this.liL.length;
        if (n2 > 0) {
            this.laf.processBlock(this.liJ, 0, this.liK, 0);
            this.process(this.liL, this.liK, this.V);
            this.process(this.V, this.liL, this.liK);
            System.arraycopy(this.liL, 0, byArray, n3 * this.liL.length, n2);
            this.increment(this.liJ);
        }
        ++this.reseedCounter;
        return byArray.length;
    }

    void reseed() {
        this.V = this.getEntropy();
        this.reseedCounter = 1L;
    }

    private byte[] getEntropy() {
        byte[] byArray = this.kvl.getEntropy();
        if (byArray.length != this.laf.getBlockSize()) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    private void process(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = (byte)(byArray2[i2] ^ byArray3[i2]);
        }
        this.laf.processBlock(byArray, 0, byArray, 0);
    }

    private void increment(byte[] byArray) {
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            int n3 = n2--;
            byArray[n3] = (byte)(byArray[n3] + 1);
            if (byArray[n3] != 0) break;
        }
    }

    private static boolean isTooLarge(byte[] byArray, int n2) {
        return byArray != null && byArray.length > n2;
    }

    static {
        liI.put("AES", new byte[][]{bfS.decode("f7d36762b9915f1ed585eb8e91700eb2"), bfS.decode("259e67249288597a4d61e7c0e690afae"), bfS.decode("35cc0ea481fc8a4f5f05c7d4667233b2"), bfS.decode("15f013af5a8e9df9a8e37500edaeac43")});
        liI.put("DESede", new byte[][]{bfS.decode("ef16ec643e5db5892cbc6eabba310b3410e6f8759e3e382c"), bfS.decode("55df103deaf68dc4"), bfS.decode("96d872b9122c5e74"), bfS.decode("9c960bb9662ce6de")});
    }
}

