/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aIu;
import com.aspose.html.utils.bfr;

public class aLH {
    private final byte[] kFn;
    private final long kFo;
    private final int kFp;
    private long counterValue;
    private boolean counterExhausted;

    public aLH(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new NullPointerException("'baseNonce' cannot be null");
        }
        if (byArray.length < 8) {
            throw new IllegalArgumentException("'baseNonce' must be at least 8 bytes");
        }
        if (n2 < 1 || n2 > 64) {
            throw new IllegalArgumentException("'counterBits' must be from 1 to 64 bits");
        }
        if (aIu.isInApprovedOnlyMode()) {
            if (byArray.length < 12) {
                throw new IllegalArgumentException("Approved mode requires 'baseNonce' of at least 12 bytes");
            }
            if (n2 < 32) {
                throw new IllegalArgumentException("Approved mode requires 'counterBits' of at least 32 bits");
            }
        }
        this.kFn = bfr.clone(byArray);
        this.kFo = -1L >>> 64 - n2;
        this.kFp = (n2 + 7) / 8;
        this.counterValue = 0L;
        this.counterExhausted = false;
    }

    public void generateNonce(byte[] byArray) {
        if (this.kFn.length != byArray.length) {
            throw new IllegalArgumentException("'nonce' length must match the base nonce length (" + this.kFn.length + " bytes)");
        }
        if (this.counterExhausted) {
            throw new IllegalStateException("TLS nonce generator exhausted");
        }
        System.arraycopy(this.kFn, 0, byArray, 0, this.kFn.length);
        this.xorCounter(byArray, this.kFn.length - this.kFp);
        this.counterExhausted |= (++this.counterValue & this.kFo) == 0L;
    }

    private void xorCounter(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < this.kFp; ++i2) {
            int n3 = n2 + i2;
            byArray[n3] = (byte)(byArray[n3] ^ (byte)(this.counterValue >>> (this.kFp - 1 - i2) * 8));
        }
    }
}

