/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.toolkit.markdown.syntax;

import com.aspose.html.toolkit.markdown.syntax.AtxHeadingSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.AutoLinkSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.BlockProxy;
import com.aspose.html.toolkit.markdown.syntax.BlockQuoteSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.CharacterReferenceSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.CodeSpanSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.EmphasisSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.EmptyLineSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.EscapedCharacterSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.FencedCodeBlockSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.HTMLFragmentSyntax;
import com.aspose.html.toolkit.markdown.syntax.HardBreakSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.IndentedCodeBlockSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.InlineContainerSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.InlineImageSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.InlineLinkSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.InlineProxy;
import com.aspose.html.toolkit.markdown.syntax.LinkDestinationSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.LinkReferenceDefinitionSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.LinkTitleSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.ListItemMarker;
import com.aspose.html.toolkit.markdown.syntax.ListItemSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.MarkdownSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.MarkdownSyntaxToken;
import com.aspose.html.toolkit.markdown.syntax.MarkdownSyntaxTree;
import com.aspose.html.toolkit.markdown.syntax.OrderedListItemMarker;
import com.aspose.html.toolkit.markdown.syntax.OrderedListSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.ParagraphSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.ReferenceImageSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.ReferenceLinkSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.SetextHeadingSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.SoftBreakSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.TableCellSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.TableDelimiterSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.TableRowSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.TableSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.TaskListItemMarker;
import com.aspose.html.toolkit.markdown.syntax.TaskListItemSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.TextSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.ThematicBreakSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.UnorderedListItemMarker;
import com.aspose.html.toolkit.markdown.syntax.UnorderedListSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.WhitespaceSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.extensions.HugoShortCodeSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.extensions.HugoYamlBasedFrontMatterSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.extensions.ShortCodeParameterSyntaxNode;
import com.aspose.html.toolkit.markdown.syntax.parser.DelimiterRun;
import com.aspose.html.toolkit.markdown.syntax.text.SourceText;
import com.aspose.html.toolkit.markdown.syntax.text.TextSpan;
import com.aspose.html.utils.Yi;
import com.aspose.html.utils.Yn;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.StringExtensions;

public class MarkdownSyntaxFactory {
    private final MarkdownSyntaxTree hmt;
    private static final String hmu = "#";
    private static final String hmv = "##";
    private static final String hmw = "###";
    private static final String hmx = "####";
    private static final String hmy = "#####";
    private static final String hmz = "######";

    public MarkdownSyntaxFactory(MarkdownSyntaxTree markdownSyntaxTree) {
        this.hmt = markdownSyntaxTree;
    }

    public final AtxHeadingSyntaxNode atxHeading(String string) {
        return this.atxHeading(string, 1);
    }

    public final AtxHeadingSyntaxNode atxHeading(String string, int n2) {
        SourceText sourceText;
        switch (n2) {
            case 1: {
                sourceText = SourceText.from(hmu);
                break;
            }
            case 2: {
                sourceText = SourceText.from(hmv);
                break;
            }
            case 3: {
                sourceText = SourceText.from(hmw);
                break;
            }
            case 4: {
                sourceText = SourceText.from(hmx);
                break;
            }
            case 5: {
                sourceText = SourceText.from(hmy);
                break;
            }
            case 6: {
                sourceText = SourceText.from(hmz);
                break;
            }
            default: {
                throw new ArgumentException("The heading level must be between 1 and 6.");
            }
        }
        MarkdownSyntaxToken markdownSyntaxToken = this.token(sourceText);
        markdownSyntaxToken.getTrailingTrivia().addItem(this.trivia(SourceText.from(" "), new TextSpan(0, 1)));
        MarkdownSyntaxToken markdownSyntaxToken2 = this.token(sourceText);
        markdownSyntaxToken2.getLeadingTrivia().addItem(this.trivia(SourceText.from(" "), new TextSpan(0, 1)));
        AtxHeadingSyntaxNode atxHeadingSyntaxNode = this.atxHeading(markdownSyntaxToken, markdownSyntaxToken2);
        atxHeadingSyntaxNode.appendChild(this.text(string));
        return atxHeadingSyntaxNode;
    }

    public final AtxHeadingSyntaxNode atxHeading(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2) {
        return AtxHeadingSyntaxNode.a(this.hmt, markdownSyntaxToken, markdownSyntaxToken2);
    }

    public final HTMLFragmentSyntax HTMLFragment(SourceText sourceText, TextSpan textSpan) {
        return HTMLFragmentSyntax.d(this.hmt);
    }

    public final HTMLFragmentSyntax HTMLFragment() {
        return HTMLFragmentSyntax.d(this.hmt);
    }

    public final AutoLinkSyntaxNode autoLink(MarkdownSyntaxToken markdownSyntaxToken, TextSyntaxNode textSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken2, boolean bl2) {
        return AutoLinkSyntaxNode.a(this.hmt, markdownSyntaxToken, textSyntaxNode, markdownSyntaxToken2, bl2);
    }

    public final AutoLinkSyntaxNode autoLink(MarkdownSyntaxToken markdownSyntaxToken, TextSyntaxNode textSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken2) {
        return this.autoLink(markdownSyntaxToken, textSyntaxNode, markdownSyntaxToken2, false);
    }

    public final MarkdownSyntaxToken token(SourceText sourceText, TextSpan textSpan) {
        return MarkdownSyntaxToken.b(this.hmt, sourceText, textSpan.apI());
    }

    public final MarkdownSyntaxToken token(SourceText sourceText) {
        return MarkdownSyntaxToken.b(this.hmt, sourceText, sourceText.getSpan().apI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextSyntaxNode text(String string) {
        SourceText sourceText = SourceText.from(string);
        try {
            TextSyntaxNode textSyntaxNode = this.text(sourceText);
            return textSyntaxNode;
        }
        finally {
            if (sourceText != null) {
                sourceText.dispose();
            }
        }
    }

    public final TextSyntaxNode text(SourceText sourceText) {
        return this.text(sourceText, new TextSpan(0, sourceText.getLength()));
    }

    public final TextSyntaxNode text(SourceText sourceText, TextSpan textSpan) {
        return TextSyntaxNode.e(this.hmt, sourceText, textSpan.apI());
    }

    public final TextSyntaxNode escapedCharacter(char c2) {
        return this.escapedCharacter(SourceText.from(StringExtensions.concat("\\", Character.valueOf(c2))), new TextSpan(0, 2));
    }

    public final TextSyntaxNode escapedCharacter(SourceText sourceText, TextSpan textSpan) {
        return EscapedCharacterSyntaxNode.a(this.hmt, sourceText, textSpan.apI());
    }

    public final InlineProxy inlineProxy(MarkdownSyntaxNode markdownSyntaxNode) {
        return InlineProxy.b(this.hmt, markdownSyntaxNode);
    }

    public final BlockProxy blockProxy(MarkdownSyntaxNode markdownSyntaxNode) {
        return BlockProxy.a(this.hmt, markdownSyntaxNode);
    }

    public final HugoYamlBasedFrontMatterSyntaxNode hugoYamlBasedFrontMatter(MarkdownSyntaxToken markdownSyntaxToken, TextSyntaxNode textSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken2) {
        return HugoYamlBasedFrontMatterSyntaxNode.c(this.hmt, markdownSyntaxToken, textSyntaxNode, markdownSyntaxToken2);
    }

    public final HugoShortCodeSyntaxNode hugoShortCode(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2, MarkdownSyntaxToken markdownSyntaxToken3) {
        return HugoShortCodeSyntaxNode.b(this.hmt, markdownSyntaxToken, markdownSyntaxToken2, markdownSyntaxToken3);
    }

    public final ShortCodeParameterSyntaxNode hugoShortCodeParameter(TextSyntaxNode textSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2, TextSyntaxNode textSyntaxNode2, MarkdownSyntaxToken markdownSyntaxToken3) {
        return ShortCodeParameterSyntaxNode.a(this.hmt, textSyntaxNode, markdownSyntaxToken, markdownSyntaxToken2, textSyntaxNode2, markdownSyntaxToken3);
    }

    public final EmptyLineSyntaxNode emptyLine() {
        return EmptyLineSyntaxNode.c(this.hmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WhitespaceSyntaxNode whitespace(int n2) {
        SourceText sourceText = SourceText.from(StringExtensions.newString(' ', n2));
        try {
            WhitespaceSyntaxNode whitespaceSyntaxNode = this.whitespace(sourceText, sourceText.getSpan().apI());
            return whitespaceSyntaxNode;
        }
        finally {
            if (sourceText != null) {
                sourceText.dispose();
            }
        }
    }

    public final WhitespaceSyntaxNode whitespace() {
        return this.whitespace(1);
    }

    public final WhitespaceSyntaxNode whitespace(SourceText sourceText) {
        return this.whitespace(sourceText, sourceText.getSpan().apI());
    }

    public final WhitespaceSyntaxNode whitespace(SourceText sourceText, TextSpan textSpan) {
        return WhitespaceSyntaxNode.f(this.hmt, sourceText, textSpan.apI());
    }

    public final ReferenceLinkSyntaxNode referenceLink(MarkdownSyntaxToken markdownSyntaxToken, InlineContainerSyntaxNode inlineContainerSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken2, MarkdownSyntaxToken markdownSyntaxToken3, InlineContainerSyntaxNode inlineContainerSyntaxNode2, MarkdownSyntaxToken markdownSyntaxToken4) {
        return ReferenceLinkSyntaxNode.a(this.hmt, markdownSyntaxToken, inlineContainerSyntaxNode, markdownSyntaxToken2, markdownSyntaxToken3, inlineContainerSyntaxNode2, markdownSyntaxToken4);
    }

    public final CodeSpanSyntaxNode codeSpan(int n2) {
        if (n2 < 1) {
            throw new ArgumentException("The backticks count must be >= 1", "backticksCount");
        }
        SourceText sourceText = SourceText.from(StringExtensions.newString('`', n2));
        return this.codeSpan(this.token(sourceText), this.token(sourceText));
    }

    public final CodeSpanSyntaxNode codeSpan() {
        return this.codeSpan(this.token(SourceText.from("`")), this.token(SourceText.from("`")));
    }

    public final CodeSpanSyntaxNode codeSpan(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2) {
        return CodeSpanSyntaxNode.b(this.hmt, markdownSyntaxToken, markdownSyntaxToken2);
    }

    public final InlineContainerSyntaxNode inlineContainer() {
        return InlineContainerSyntaxNode.f(this.hmt);
    }

    public final LinkTitleSyntaxNode linkTitle(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2) {
        return LinkTitleSyntaxNode.e(this.hmt, markdownSyntaxToken, markdownSyntaxToken2);
    }

    public final LinkTitleSyntaxNode linkTitle(MarkdownSyntaxToken markdownSyntaxToken) {
        return this.linkTitle(markdownSyntaxToken, null);
    }

    public final LinkTitleSyntaxNode linkTitle() {
        return this.linkTitle(null, null);
    }

    public final LinkDestinationSyntaxNode linkDestination(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2) {
        return LinkDestinationSyntaxNode.d(this.hmt, markdownSyntaxToken, markdownSyntaxToken2);
    }

    public final LinkDestinationSyntaxNode linkDestination(MarkdownSyntaxToken markdownSyntaxToken) {
        return this.linkDestination(markdownSyntaxToken, null);
    }

    public final LinkDestinationSyntaxNode linkDestination() {
        return this.linkDestination(null, null);
    }

    public final FencedCodeBlockSyntaxNode fencedCodeBlock(MarkdownSyntaxToken markdownSyntaxToken, TextSyntaxNode textSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken2) {
        return FencedCodeBlockSyntaxNode.b(this.hmt, markdownSyntaxToken, textSyntaxNode, markdownSyntaxToken2);
    }

    public final FencedCodeBlockSyntaxNode fencedCodeBlock(MarkdownSyntaxToken markdownSyntaxToken, TextSyntaxNode textSyntaxNode) {
        return this.fencedCodeBlock(markdownSyntaxToken, textSyntaxNode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EmphasisSyntaxNode emphasis(int n2) {
        String string = StringExtensions.Empty;
        switch (n2) {
            case 2: {
                string = "*";
                break;
            }
            case 1: {
                string = "**";
                break;
            }
            case 3: {
                string = "~";
            }
        }
        SourceText sourceText = SourceText.from(string);
        try {
            EmphasisSyntaxNode emphasisSyntaxNode = this.emphasis(this.token(sourceText, sourceText.getSpan().apI()), this.token(sourceText, sourceText.getSpan().apI()));
            return emphasisSyntaxNode;
        }
        finally {
            if (sourceText != null) {
                sourceText.dispose();
            }
        }
    }

    public final EmphasisSyntaxNode emphasis(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2) {
        return EmphasisSyntaxNode.c(this.hmt, markdownSyntaxToken, markdownSyntaxToken2);
    }

    public final MarkdownSyntaxToken emphasisOpening(SourceText sourceText, TextSpan textSpan) {
        return this.token(sourceText, textSpan.apI());
    }

    public final MarkdownSyntaxToken emphasisClosing(SourceText sourceText, TextSpan textSpan) {
        return this.token(sourceText, textSpan.apI());
    }

    public final MarkdownSyntaxToken hardBreakingTag(SourceText sourceText, TextSpan textSpan) {
        return this.token(sourceText, textSpan.apI());
    }

    public final IndentedCodeBlockSyntaxNode indentedCode(int n2) {
        return IndentedCodeBlockSyntaxNode.a(this.hmt, n2);
    }

    public final IndentedCodeBlockSyntaxNode indentedCode() {
        return this.indentedCode(0);
    }

    public final InlineImageSyntaxNode inlineImage(String string, String string2, String string3) {
        LinkDestinationSyntaxNode linkDestinationSyntaxNode = this.linkDestination();
        linkDestinationSyntaxNode.appendChild(this.text(string2));
        linkDestinationSyntaxNode.getTrailingTrivia().addItem(this.trivia(SourceText.from(" "), new TextSpan(0, 1)));
        LinkTitleSyntaxNode linkTitleSyntaxNode = this.linkTitle(this.token(SourceText.from("\"")), this.token(SourceText.from("\"")));
        linkTitleSyntaxNode.appendChild(this.text(string3));
        InlineImageSyntaxNode inlineImageSyntaxNode = InlineImageSyntaxNode.a(this.hmt, this.token(SourceText.from("![")), this.token(SourceText.from("]")), this.token(SourceText.from("(")), linkDestinationSyntaxNode, linkTitleSyntaxNode, this.token(SourceText.from(")")));
        inlineImageSyntaxNode.appendChild(this.text(string));
        return inlineImageSyntaxNode;
    }

    public final InlineImageSyntaxNode inlineImage(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2, MarkdownSyntaxToken markdownSyntaxToken3, LinkDestinationSyntaxNode linkDestinationSyntaxNode, LinkTitleSyntaxNode linkTitleSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken4) {
        return InlineImageSyntaxNode.a(this.hmt, markdownSyntaxToken, markdownSyntaxToken2, markdownSyntaxToken3, linkDestinationSyntaxNode, linkTitleSyntaxNode, markdownSyntaxToken4);
    }

    public final ReferenceImageSyntaxNode referenceImage(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2, MarkdownSyntaxToken markdownSyntaxToken3, InlineContainerSyntaxNode inlineContainerSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken4) {
        return ReferenceImageSyntaxNode.a(this.hmt, markdownSyntaxToken, markdownSyntaxToken2, markdownSyntaxToken3, inlineContainerSyntaxNode, markdownSyntaxToken4);
    }

    public final BlockQuoteSyntaxNode blockQuote() {
        return BlockQuoteSyntaxNode.b(this.hmt);
    }

    public final InlineLinkSyntaxNode inlineLink(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2, MarkdownSyntaxToken markdownSyntaxToken3, LinkDestinationSyntaxNode linkDestinationSyntaxNode, LinkTitleSyntaxNode linkTitleSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken4) {
        return InlineLinkSyntaxNode.b(this.hmt, markdownSyntaxToken, markdownSyntaxToken2, markdownSyntaxToken3, linkDestinationSyntaxNode, linkTitleSyntaxNode, markdownSyntaxToken4);
    }

    public final InlineLinkSyntaxNode inlineLink(String string, String string2, String string3) {
        LinkDestinationSyntaxNode linkDestinationSyntaxNode = this.linkDestination();
        linkDestinationSyntaxNode.appendChild(this.text(string2));
        linkDestinationSyntaxNode.getTrailingTrivia().addItem(this.trivia(SourceText.from(" "), new TextSpan(0, 1)));
        LinkTitleSyntaxNode linkTitleSyntaxNode = this.linkTitle(this.token(SourceText.from("\"")), this.token(SourceText.from("\"")));
        linkTitleSyntaxNode.appendChild(this.text(string3));
        InlineLinkSyntaxNode inlineLinkSyntaxNode = InlineLinkSyntaxNode.b(this.hmt, this.token(SourceText.from("[")), this.token(SourceText.from("]")), this.token(SourceText.from("(")), linkDestinationSyntaxNode, linkTitleSyntaxNode, this.token(SourceText.from(")")));
        inlineLinkSyntaxNode.appendChild(this.text(string));
        return inlineLinkSyntaxNode;
    }

    public final LinkReferenceDefinitionSyntaxNode linkReferenceDefinition(MarkdownSyntaxToken markdownSyntaxToken, TextSyntaxNode textSyntaxNode, MarkdownSyntaxToken markdownSyntaxToken2, LinkDestinationSyntaxNode linkDestinationSyntaxNode, LinkTitleSyntaxNode linkTitleSyntaxNode) {
        return LinkReferenceDefinitionSyntaxNode.a(this.hmt, markdownSyntaxToken, textSyntaxNode, markdownSyntaxToken2, linkDestinationSyntaxNode, linkTitleSyntaxNode);
    }

    public final ParagraphSyntaxNode paragraph() {
        return this.paragraph(true);
    }

    public final SetextHeadingSyntaxNode setextHeading(MarkdownSyntaxToken markdownSyntaxToken) {
        return SetextHeadingSyntaxNode.c(this.hmt, markdownSyntaxToken);
    }

    public final OrderedListSyntaxNode orderedList() {
        return OrderedListSyntaxNode.i(this.hmt);
    }

    public final TableCellSyntaxNode tableCell() {
        return TableCellSyntaxNode.k(this.hmt);
    }

    public final TableDelimiterSyntaxNode tableDelimiter(MarkdownSyntaxToken markdownSyntaxToken) {
        return TableDelimiterSyntaxNode.d(this.hmt, markdownSyntaxToken);
    }

    public final TableRowSyntaxNode tableRow() {
        return TableRowSyntaxNode.l(this.hmt);
    }

    public final ListItemMarker listItemMarker(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2) {
        return OrderedListItemMarker.f(this.hmt, markdownSyntaxToken, markdownSyntaxToken2);
    }

    public final ListItemMarker listItemMarker(MarkdownSyntaxToken markdownSyntaxToken) {
        return UnorderedListItemMarker.f(this.hmt, markdownSyntaxToken);
    }

    public final ListItemSyntaxNode listItem(ListItemMarker listItemMarker) {
        return ListItemSyntaxNode.a(this.hmt, listItemMarker);
    }

    public final ListItemSyntaxNode unorderedListItem(String string) {
        MarkdownSyntaxToken markdownSyntaxToken = this.token(SourceText.from(string));
        UnorderedListItemMarker unorderedListItemMarker = UnorderedListItemMarker.f(this.hmt, markdownSyntaxToken);
        ListItemSyntaxNode listItemSyntaxNode = ListItemSyntaxNode.a(this.hmt, unorderedListItemMarker);
        unorderedListItemMarker.getTrailingTrivia().addItem(this.trivia(SourceText.from(" "), new TextSpan(0, 1)));
        return listItemSyntaxNode;
    }

    public final ListItemSyntaxNode orderedListItem(int n2) {
        MarkdownSyntaxToken markdownSyntaxToken = this.token(SourceText.from(Int32Extensions.toString(n2)));
        MarkdownSyntaxToken markdownSyntaxToken2 = this.token(SourceText.from("."));
        OrderedListItemMarker orderedListItemMarker = OrderedListItemMarker.f(this.hmt, markdownSyntaxToken, markdownSyntaxToken2);
        ListItemSyntaxNode listItemSyntaxNode = ListItemSyntaxNode.a(this.hmt, orderedListItemMarker);
        orderedListItemMarker.getTrailingTrivia().addItem(this.trivia(SourceText.from(" "), new TextSpan(0, 1)));
        return listItemSyntaxNode;
    }

    public final UnorderedListSyntaxNode unorderedList() {
        return UnorderedListSyntaxNode.n(this.hmt);
    }

    public final SoftBreakSyntaxNode softBreak(SourceText sourceText, TextSpan textSpan) {
        return SoftBreakSyntaxNode.c(this.hmt, sourceText, textSpan.apI());
    }

    public final TableSyntaxNode table() {
        return TableSyntaxNode.m(this.hmt);
    }

    public final ThematicBreakSyntaxNode thematicBreak(MarkdownSyntaxToken markdownSyntaxToken) {
        return ThematicBreakSyntaxNode.e(this.hmt, markdownSyntaxToken);
    }

    public final HardBreakSyntaxNode hardBreak(MarkdownSyntaxToken markdownSyntaxToken, SourceText sourceText, TextSpan textSpan) {
        return HardBreakSyntaxNode.a(this.hmt, markdownSyntaxToken, sourceText, textSpan.apI());
    }

    public final CharacterReferenceSyntaxNode characterReference(SourceText sourceText, TextSpan textSpan, String string) {
        return CharacterReferenceSyntaxNode.a(this.hmt, sourceText, textSpan.apI(), string);
    }

    public final WhitespaceSyntaxNode trivia(SourceText sourceText, TextSpan textSpan) {
        return this.whitespace(sourceText, textSpan.apI());
    }

    public final WhitespaceSyntaxNode newLineTrivia() {
        SourceText sourceText = SourceText.from(Environment.get_NewLine());
        try {
            WhitespaceSyntaxNode whitespaceSyntaxNode = this.whitespace(sourceText);
            return whitespaceSyntaxNode;
        }
        finally {
            if (sourceText != null) {
                sourceText.dispose();
            }
        }
    }

    public final TaskListItemMarker taskListItemMarker(MarkdownSyntaxToken markdownSyntaxToken, MarkdownSyntaxToken markdownSyntaxToken2, MarkdownSyntaxToken markdownSyntaxToken3) {
        return TaskListItemMarker.a(this.hmt, markdownSyntaxToken, markdownSyntaxToken2, markdownSyntaxToken3);
    }

    public final TaskListItemSyntaxNode taskListItem(ListItemMarker listItemMarker, TaskListItemMarker taskListItemMarker) {
        return TaskListItemSyntaxNode.a(this.hmt, listItemMarker, taskListItemMarker);
    }

    public final ParagraphSyntaxNode paragraph(boolean bl2) {
        ParagraphSyntaxNode paragraphSyntaxNode = ParagraphSyntaxNode.j(this.hmt);
        if (bl2) {
            paragraphSyntaxNode.getTrailingTrivia().addItem(this.newLineTrivia());
        }
        return paragraphSyntaxNode;
    }

    public final Yn a(SourceText sourceText, TextSpan textSpan) {
        return Yn.d(this.hmt, sourceText, textSpan.apI());
    }

    public final Yi b(DelimiterRun delimiterRun) {
        return Yi.a(this.hmt, delimiterRun);
    }
}

