/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering.image;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.drawing.IBrush;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.rendering.CharacterInfo;
import com.aspose.html.rendering.Device;
import com.aspose.html.rendering.DeviceConfiguration;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.image.ImageFormat;
import com.aspose.html.rendering.image.ImageRenderingOptions;
import com.aspose.html.utils.JE;
import com.aspose.html.utils.JG;
import com.aspose.html.utils.JH;
import com.aspose.html.utils.JI;
import com.aspose.html.utils.JL;
import com.aspose.html.utils.QU;
import com.aspose.html.utils.QV;
import com.aspose.html.utils.QW;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.bZ;
import com.aspose.html.utils.bhx;
import com.aspose.html.utils.collections.generic.IGenericList;
import com.aspose.html.utils.dM;
import com.aspose.html.utils.dN;
import com.aspose.html.utils.dO;
import com.aspose.html.utils.dr;
import com.aspose.html.utils.dt;
import com.aspose.html.utils.ms.System.Char;
import com.aspose.html.utils.ms.System.Collections.Generic.Stack;
import com.aspose.html.utils.ms.System.Drawing.Bitmap;
import com.aspose.html.utils.ms.System.Drawing.Brush;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.GraphicsState;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.utils.ms.System.Drawing.Font;
import com.aspose.html.utils.ms.System.Drawing.Graphics;
import com.aspose.html.utils.ms.System.Drawing.Image;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ImageAttributes;
import com.aspose.html.utils.ms.System.Drawing.Pen;
import com.aspose.html.utils.ms.System.Drawing.PointF;
import com.aspose.html.utils.ms.System.Drawing.RectangleF;
import com.aspose.html.utils.ms.System.Drawing.Region;
import com.aspose.html.utils.ms.System.Drawing.SizeF;
import com.aspose.html.utils.ms.System.Drawing.StringFormat;
import com.aspose.html.utils.ms.System.EnumExtensions;
import com.aspose.html.utils.ms.System.IO.MemoryStream;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Ref;

public class ImageDevice
extends Device<ImageGraphicContext, ImageRenderingOptions> {
    private bhx<IBrush, Brush> gNU;
    private dr eBH;
    private dM GZ;
    private final JL gNV = new JL();
    private dN cfa;
    private final Stack<GraphicsState> gNW = new Stack();
    private StringFormat cfc;
    private QU gNX;

    protected ImageGraphicContext aeJ() {
        return new ImageGraphicContext();
    }

    @Override
    public DeviceConfiguration Ui() {
        return this.aeL().Ui();
    }

    public Graphics getGraphics() {
        return this.aeL().aeR();
    }

    public final Stream aeK() {
        return this.getOutputStream();
    }

    public final QU aeL() {
        return this.gNX;
    }

    private void a(QU qU2) {
        this.gNX = qU2;
    }

    public ImageDevice(ICreateStreamProvider iCreateStreamProvider) {
        this(new ImageRenderingOptions(), iCreateStreamProvider);
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, ICreateStreamProvider iCreateStreamProvider) {
        super(imageRenderingOptions, iCreateStreamProvider);
        this.sN();
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, Stream stream) {
        super(imageRenderingOptions, stream);
        this.sN();
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, String string) {
        super(imageRenderingOptions, string);
        this.sN();
    }

    public ImageDevice(Stream stream) {
        this(new ImageRenderingOptions(), stream);
    }

    public ImageDevice(String string) {
        this(new ImageRenderingOptions(), string);
    }

    @Override
    public void addRect(RectangleF rectangleF) {
        this.gNV.y(rectangleF.Clone());
    }

    @Override
    public void beginDocument(Document document) {
        if (!Device.a.c(this)) {
            this.eBH = document.getContext().getService(dr.class);
            this.GZ = document.getContext().getService(dM.class);
        }
        super.beginDocument(document);
        this.gNV.Uq();
        this.cfa = this.GZ.ix();
    }

    @Override
    public boolean beginElement(Element element, RectangleF rectangleF) {
        return true;
    }

    @Override
    public void beginPage(SizeF sizeF) {
        super.beginPage(sizeF.Clone());
        this.aeL().beginPage(sizeF.Clone());
        JE.a(this.eBH, this, sizeF.Clone());
    }

    @Override
    public void clip(int n2) {
        this.gNV.Un().setFillMode(n2);
        this.getGraphics().setClip(new Region(this.gNV.Un()), 1);
        this.gNV.Uq();
    }

    @Override
    public void closePath() {
        this.gNV.Ur();
    }

    private Pen sL() {
        Pen pen = new Pen(this.gNU.invoke(((ImageGraphicContext)this.getGraphicContext()).getStrokeBrush()));
        pen.setWidth(((ImageGraphicContext)this.getGraphicContext()).getLineWidth());
        pen.setStartCap(((ImageGraphicContext)this.getGraphicContext()).getLineCap());
        pen.setEndCap(((ImageGraphicContext)this.getGraphicContext()).getLineCap());
        pen.setLineJoin(((ImageGraphicContext)this.getGraphicContext()).getLineJoin());
        pen.setMiterLimit(((ImageGraphicContext)this.getGraphicContext()).getMiterLimit());
        pen.setDashOffset(((ImageGraphicContext)this.getGraphicContext()).getLineDashOffset() / pen.getWidth());
        pen.setDashStyle(((ImageGraphicContext)this.getGraphicContext()).getLineDashStyle());
        pen.setDashCap(GraphicContext.a.a(this.getGraphicContext()));
        if (pen.getDashStyle() == 5) {
            int n2 = ((ImageGraphicContext)this.getGraphicContext()).getLineDashPattern().length;
            float[] fArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = ((ImageGraphicContext)this.getGraphicContext()).getLineDashPattern()[i2] / ((ImageGraphicContext)this.getGraphicContext()).getLineWidth();
            }
            pen.setDashPattern(fArray);
        }
        return pen;
    }

    private QU aeM() {
        switch (((ImageRenderingOptions)this.getOptions()).getFormat()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new QV(this);
            }
            case 5: {
                return new QW(this);
            }
        }
        throw new NotSupportedException();
    }

    @Override
    public void cubicBezierTo(PointF pointF, PointF pointF2, PointF pointF3) {
        this.gNV.f(pointF.Clone(), pointF2.Clone(), pointF3.Clone());
    }

    @Override
    public void dispose(boolean bl2) {
        if (this.aeL() != null && bl2) {
            this.aeL().dispose();
            this.a((QU)null);
        }
        super.dispose(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(byte[] byArray, int n2, RectangleF rectangleF) {
        Image image = Image.fromStream(new MemoryStream(byArray));
        try {
            Integer n3 = 2;
            Integer[] integerArray = new Integer[]{n3};
            RectangleF rectangleF2 = image.getBounds(new Ref<Integer>(n3)).Clone();
            n3 = integerArray[0];
            PointF[] pointFArray = new PointF[]{rectangleF.getLocation(), new PointF(rectangleF.getX() + rectangleF.getWidth(), rectangleF.getY()), new PointF(rectangleF.getX(), rectangleF.getY() + rectangleF.getHeight())};
            ImageAttributes imageAttributes = null;
            this.getGraphics().drawImage(image, pointFArray, rectangleF2.Clone(), (int)n3, imageAttributes);
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
    }

    @Override
    public void endDocument() {
        if (Device.a.c(this)) {
            this.cfa.dispose();
            this.cfa = null;
        }
        super.endDocument();
    }

    @Override
    public void endElement(Element element) {
    }

    @Override
    public void endPage() {
        this.aeL().endPage();
        super.endPage();
    }

    @Override
    public void fill(int n2) {
        this.gk(n2);
        this.gNV.Uq();
    }

    private void gk(int n2) {
        Brush brush = this.gNU.invoke(((ImageGraphicContext)this.getGraphicContext()).getFillBrush());
        try {
            this.gNV.Un().setFillMode(n2);
            this.getGraphics().fillPath(brush, this.gNV.Un());
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillText(String string, PointF pointF) {
        if (((ImageGraphicContext)this.getGraphicContext()).getFontSize() < 0.1f) {
            return;
        }
        pointF.setY(pointF.getY() - ((ImageGraphicContext)this.getGraphicContext()).getFont().getAscent(((ImageGraphicContext)this.getGraphicContext()).getFontSize()));
        Brush brush = this.gNU.invoke(((ImageGraphicContext)this.getGraphicContext()).getFillBrush());
        try {
            Font font = this.GZ.a(Font.class, (dO)((bZ)((Object)((ImageGraphicContext)this.getGraphicContext()).getFont())).gc(), ((ImageGraphicContext)this.getGraphicContext()).getFontSize(), ((ImageGraphicContext)this.getGraphicContext()).getFontStyle(), this.cfa);
            try {
                IGenericList<CharacterInfo> iGenericList = ((ImageGraphicContext)this.getGraphicContext()).getTextInfo().getCharacterInfos();
                for (int i2 = 0; i2 < iGenericList.size(); ++i2) {
                    this.getGraphics().drawString(Char.toString(string.charAt(i2)), font, brush, pointF.Clone(), this.cfc);
                    pointF.setX(pointF.getX() + (iGenericList.get_Item(i2).getWidth() + iGenericList.get_Item(i2).getOffset()));
                }
            }
            finally {
                if (font != null) {
                    font.dispose();
                }
            }
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    @Override
    public void flush() {
        this.aeL().flush();
        this.gNW.clear();
        super.flush();
    }

    @Override
    public String getExtension() {
        return StringExtensions.concat(".", StringExtensions.toLowerInvariant(EnumExtensions.toString(ImageFormat.class, ((ImageRenderingOptions)this.getOptions()).getFormat())));
    }

    @Override
    public void initialize() {
        super.initialize();
        ((ImageGraphicContext)this.getGraphicContext()).d(this);
    }

    private void sN() {
        this.gNU = new bhx<IBrush, Brush>(){

            public String aM() {
                return "Aspose.Html.Rendering.Image.ImageDevice.ToNativeBrush(Aspose.Html.Drawing.IBrush)";
            }

            public Brush c(IBrush iBrush) {
                return ImageDevice.this.a(iBrush);
            }

            @Override
            public /* synthetic */ Object invoke(Object object) {
                return this.c((IBrush)object);
            }
        };
        this.cfc = new StringFormat(StringFormat.getGenericTypographic());
        this.cfc.setFormatFlags(this.cfc.getFormatFlags() | 0x800);
        this.a(this.aeM());
    }

    @Override
    public void lineTo(PointF pointF) {
        this.gNV.r(pointF.Clone());
    }

    @Override
    public void moveTo(PointF pointF) {
        this.gNV.s(pointF.Clone());
    }

    @Override
    public void restoreGraphicContext() {
        this.getGraphics().restore(this.gNW.pop());
        super.restoreGraphicContext();
    }

    @Override
    public void saveGraphicContext() {
        this.gNW.push(this.getGraphics().save());
        super.saveGraphicContext();
    }

    @Override
    public void stroke() {
        this.aeN();
        this.gNV.Uq();
    }

    @Override
    public void strokeAndFill(int n2) {
        this.gk(n2);
        this.aeN();
        this.gNV.Uq();
    }

    private void aeN() {
        Pen pen = this.sL();
        try {
            this.getGraphics().drawPath(pen, this.gNV.Un());
        }
        finally {
            if (pen != null) {
                pen.dispose();
            }
        }
    }

    @Override
    public void strokeText(String string, PointF pointF) {
    }

    private Brush a(IBrush iBrush) {
        switch (iBrush.getType()) {
            case 1: {
                return this.eBH.a(Brush.class, (dt)((JI)iBrush).gc());
            }
            case 2: {
                return this.eBH.a(Brush.class, (dt)((JG)iBrush).gc());
            }
            case 0: {
                return this.eBH.a(Brush.class, (dt)((JH)iBrush).gc());
            }
        }
        return null;
    }

    @Override
    public /* synthetic */ GraphicContext sP() {
        return this.aeJ();
    }

    public static class ImageGraphicContext
    extends GraphicContext {
        private Matrix cfi;
        private ImageDevice gNZ;

        public final ImageDevice aeO() {
            return this.gNZ;
        }

        public final void d(ImageDevice imageDevice) {
            this.gNZ = imageDevice;
        }

        @Override
        public Matrix getTransformationMatrix() {
            return this.cfi;
        }

        @Override
        public void setTransformationMatrix(Matrix matrix) {
            this.cfi = matrix;
            if (this.aeO().getGraphics() != null) {
                this.aeO().getGraphics().setTransform(matrix);
            }
        }

        @Override
        public GraphicContext deepClone() {
            ImageGraphicContext imageGraphicContext = (ImageGraphicContext)super.deepClone();
            if (this.cfi != null) {
                imageGraphicContext.cfi = this.cfi.deepClone();
            }
            return imageGraphicContext;
        }

        @Override
        public void transform(Matrix matrix) {
            if (this.getTransformationMatrix() != null) {
                this.getTransformationMatrix().multiply(matrix);
                if (this.aeO().getGraphics() != null) {
                    this.aeO().getGraphics().setTransform(this.cfi);
                }
            } else {
                this.setTransformationMatrix(matrix.deepClone());
            }
        }
    }

    public static class a {
        public static bhx<IBrush, Brush> b(ImageDevice imageDevice) {
            return imageDevice.gNU;
        }

        public static Bitmap c(ImageDevice imageDevice) {
            return imageDevice.aeL().aeP();
        }

        public static void b(ImageDevice imageDevice, bhx<IBrush, Brush> bhx2) {
            imageDevice.gNU = bhx2;
        }
    }
}

