/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.Configuration;
import com.aspose.html.HTMLElement;
import com.aspose.html.IDisposable;
import com.aspose.html.Url;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.IDocumentInit;
import com.aspose.html.dom.css.ICSSStyleDeclaration;
import com.aspose.html.dom.css.IDocumentCSS;
import com.aspose.html.dom.css.IViewCSS;
import com.aspose.html.dom.events.Event;
import com.aspose.html.io.IOutputStorage;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.saving.HTMLSaveOptions;
import com.aspose.html.saving.MHTMLSaveOptions;
import com.aspose.html.saving.MarkdownSaveOptions;
import com.aspose.html.saving.TextSaveOptions;
import com.aspose.html.serialization.manager.resources.handlers.MHTMLHandlerFactory;
import com.aspose.html.serialization.manager.resources.handlers.SingleDocumentHandlerFactory;
import com.aspose.html.utils.CU;
import com.aspose.html.utils.CV;
import com.aspose.html.utils.DN;
import com.aspose.html.utils.EW;
import com.aspose.html.utils.Jo;
import com.aspose.html.utils.K;
import com.aspose.html.utils.KeyValuePair;
import com.aspose.html.utils.O;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.TP;
import com.aspose.html.utils.Vn;
import com.aspose.html.utils.Vo;
import com.aspose.html.utils.Vr;
import com.aspose.html.utils.Vz;
import com.aspose.html.utils.Xq;
import com.aspose.html.utils.ag;
import com.aspose.html.utils.bO;
import com.aspose.html.utils.bgt;
import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.fW;
import com.aspose.html.utils.jg;
import com.aspose.html.utils.jw;
import com.aspose.html.utils.lr;
import com.aspose.html.utils.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.utils.ms.System.IO.Directory;
import com.aspose.html.utils.ms.System.IO.Path;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.vd;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class HTMLDocument
extends Document
implements IDocumentCSS {
    private String Hf;
    private IViewCSS Hg;

    public HTMLDocument() {
        this("about:blank");
    }

    public HTMLDocument(InputStream inputStream, String string) {
        this(Stream.fromJava(inputStream), string, new Configuration());
    }

    public HTMLDocument(K k2) {
        super(HTMLDocument.e(k2));
    }

    public HTMLDocument(Configuration configuration) {
        this("about:blank", configuration);
    }

    public HTMLDocument(RequestMessage requestMessage) {
        this(requestMessage, new Configuration());
    }

    public HTMLDocument(RequestMessage requestMessage, Configuration configuration) {
        this(requestMessage, configuration, 1);
    }

    private HTMLDocument(final RequestMessage requestMessage, Configuration configuration, final byte by2) {
        super(HTMLDocument.a(new K(configuration), new Document.c(){
            {
                this.a(vd.duP);
                this.a(requestMessage);
                this.setFlags(by2);
            }
        }));
    }

    public HTMLDocument(Stream stream, Url url) {
        this(stream, url, new Configuration());
    }

    public HTMLDocument(Stream stream, Url url, Configuration configuration) {
        this(Jo.a(stream, url), configuration, 3);
    }

    public HTMLDocument(Stream stream, String string) {
        this(stream, string, new Configuration());
    }

    public HTMLDocument(Stream stream, String string, Configuration configuration) {
        this(Jo.f(stream, string), configuration, 3);
    }

    public HTMLDocument(Url url) {
        this(url, new Configuration());
    }

    public HTMLDocument(Url url, Configuration configuration) {
        this(Jo.i(url), configuration, 3);
    }

    public HTMLDocument(String string) {
        this(new O(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public HTMLDocument(String string, Configuration configuration) {
        this(new O(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), configuration);
    }

    public HTMLDocument(String string, Url url) {
        this(string, url, new Configuration());
    }

    public HTMLDocument(String string, Url url, Configuration configuration) {
        this(Jo.a(string, url), configuration, 3);
    }

    public HTMLDocument(String string, String string2) {
        this(string, string2, new Configuration());
    }

    public HTMLDocument(String string, String string2, Configuration configuration) {
        this(Jo.af(string, string2), configuration, 3);
    }

    private static IDocumentInit e(K k2) {
        return HTMLDocument.a(k2, null);
    }

    private static IDocumentInit a(K k2, Document.c c2) {
        jw jw2 = k2.aa().l(k2);
        jw2.cI(1);
        jw2.b(new bgt<Document, Event>(){

            public void a(Document document, Event event) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                if (hTMLDocument.getBody() != null) {
                    hTMLDocument.getBody().dispatchEvent(event);
                } else {
                    hTMLDocument.dispatchEvent(event);
                }
            }

            @Override
            public /* synthetic */ void invoke(Object object, Object object2) {
                this.a((Document)object, (Event)object2);
            }
        });
        jw2.a(c2);
        return jw2;
    }

    public final HTMLCollection getAnchors() {
        return new bO(this, new CV("A"));
    }

    public final HTMLCollection getApplets() {
        Dictionary dictionary = new Dictionary(2);
        dictionary.addItem("APPLET", null);
        List<KeyValuePair<String, String>> list = new List<KeyValuePair<String, String>>(2);
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:CAFEEFAC-00"));
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"));
        dictionary.addItem("OBJECT", list);
        List<KeyValuePair<String, String>> list2 = new List<KeyValuePair<String, String>>(3);
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-applet"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-bean"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-vm"));
        dictionary.addItem("EMBED", list2);
        return new bO(this, new CV("APPLET", "OBJECT", "EMBED"));
    }

    public final HTMLElement getBody() {
        bO bO2 = new bO(this, new CV("BODY", "FRAMESET"));
        return (HTMLElement)DN.c(bO2);
    }

    public final void setBody(HTMLElement hTMLElement) {
        fW.d(hTMLElement, "value");
        HTMLElement hTMLElement2 = this.getBody();
        if (hTMLElement2 != null) {
            this.getDocumentElement().replaceChild(hTMLElement2, hTMLElement);
        } else {
            this.getDocumentElement().appendChild(hTMLElement);
        }
    }

    public final String bJ() {
        return this.Hf;
    }

    final void P(String string) {
        this.Hf = string;
    }

    public final String getDomain() {
        return this.getLocation().getHost();
    }

    public final HTMLCollection getForms() {
        return new bO(this, new CU("FORM"));
    }

    public final HTMLCollection getImages() {
        return this.getElementsByTagName("IMG");
    }

    public final HTMLCollection getLinks() {
        return new bO(this, new CV("A", "AREA"));
    }

    public final String getReferrer() {
        return StringExtensions.Empty;
    }

    public final String getTitle() {
        Element element = DN.c(this.getElementsByTagName(jg.i.bQA.de()));
        if (element != null) {
            return element.getTextContent();
        }
        return StringExtensions.Empty;
    }

    public final void setTitle(String string) {
        if (this.getDocumentElement() != null && StringExtensions.equals(this.getDocumentElement().getNamespaceURI(), jg.g.bMG)) {
            Element element = DN.c(this.getElementsByTagName(ag.a(jg.i.bQA)));
            if (element != null) {
                element.setTextContent(string);
                return;
            }
            Element element2 = DN.c(this.getElementsByTagName(ag.a(jg.i.bOL)));
            if (element2 == null) {
                return;
            }
            element = this.createElement(jg.i.bQA.de());
            element.setTextContent(string);
            element2.appendChild(element);
        }
    }

    @Override
    public final ICSSStyleDeclaration getOverrideStyle(Element element, String string) {
        K k2 = (K)this.getContext();
        return ((lr)k2.Y()).getOverrideStyle(element, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTo(IDevice iDevice) {
        Xq xq2 = this.getContext().getService(Xq.class);
        IDisposable iDisposable = xq2.akf();
        try {
            xq2.a(iDisposable, iDevice, this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(IOutputStorage iOutputStorage) {
        this.save(iOutputStorage, 0);
    }

    public final void save(IOutputStorage iOutputStorage, int n2) {
        switch (n2) {
            case 0: {
                this.save(iOutputStorage, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(iOutputStorage, MarkdownSaveOptions.getDefault());
                break;
            }
            case 10: {
                this.save(iOutputStorage, TextSaveOptions.getDefault());
                break;
            }
            case 2: {
                this.save(iOutputStorage, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, HTMLSaveOptions hTMLSaveOptions) {
        Vo vo2 = new Vo((K)this.getContext());
        IDisposable iDisposable = vo2.a((Url)this.getLocation(), hTMLSaveOptions);
        try {
            Vn vn2 = vo2.amK();
            vn2.a(iOutputStorage);
            vn2.c(this.getLocation(), ".htm");
            vo2.G(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MHTMLSaveOptions mHTMLSaveOptions) {
        Vo vo2 = new Vo((K)this.getContext());
        IDisposable iDisposable = vo2.a((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            Vn vn2 = vo2.amK();
            vn2.cm(false);
            vn2.a(new MHTMLHandlerFactory());
            vn2.a(new Vr());
            vn2.a(new EW(iOutputStorage, vn2.getBoundary()));
            vn2.c(this.getLocation(), ".mht");
            vo2.G(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MarkdownSaveOptions markdownSaveOptions) {
        Vo vo2 = new Vo((K)this.getContext());
        IDisposable iDisposable = vo2.a((Url)this.getLocation(), markdownSaveOptions);
        try {
            Vn vn2 = vo2.amK();
            vn2.a(new Vz(markdownSaveOptions));
            vn2.a(new SingleDocumentHandlerFactory());
            vn2.a(iOutputStorage);
            vn2.c(this.getLocation(), ".md");
            vo2.h(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(Url url) {
        this.save(url, 0);
    }

    public final void save(Url url, int n2) {
        switch (n2) {
            case 0: {
                this.save(url, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(url, MarkdownSaveOptions.getDefault());
                break;
            }
            case 10: {
                this.save(url, new MHTMLSaveOptions());
                break;
            }
            case 2: {
                this.save(url, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, HTMLSaveOptions hTMLSaveOptions) {
        Vo vo2 = new Vo((K)this.getContext());
        IDisposable iDisposable = vo2.a((Url)this.getLocation(), hTMLSaveOptions);
        try {
            Vn vn2 = vo2.amK();
            vn2.m(url);
            vo2.G(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MHTMLSaveOptions mHTMLSaveOptions) {
        Vo vo2 = new Vo((K)this.getContext());
        IDisposable iDisposable = vo2.a((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            Vn vn2 = vo2.amK();
            vn2.cm(false);
            vn2.a(new MHTMLHandlerFactory());
            vn2.a(new Vr());
            vn2.a(new EW(vn2.amy(), vn2.getBoundary()));
            vn2.k(url);
            vn2.m(url);
            vo2.G(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MarkdownSaveOptions markdownSaveOptions) {
        Vo vo2 = new Vo((K)this.getContext());
        IDisposable iDisposable = vo2.a((Url)this.getLocation(), markdownSaveOptions);
        try {
            Vn vn2 = vo2.amK();
            vn2.a(new Vz(markdownSaveOptions));
            vn2.a(new SingleDocumentHandlerFactory());
            vn2.m(url);
            vo2.h(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(String string) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public final void save(String string, int n2) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), n2);
    }

    public final void save(String string, HTMLSaveOptions hTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), hTMLSaveOptions);
    }

    public final void save(String string, MHTMLSaveOptions mHTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), mHTMLSaveOptions);
    }

    public final void save(String string, MarkdownSaveOptions markdownSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), markdownSaveOptions);
    }

    public final void save(String string, TextSaveOptions textSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), textSaveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, TextSaveOptions textSaveOptions) {
        Vo vo2 = new Vo((K)this.getContext());
        IDisposable iDisposable = vo2.a((Url)this.getLocation(), textSaveOptions);
        try {
            Vn vn2 = vo2.amK();
            vn2.a(new SingleDocumentHandlerFactory());
            vn2.m(url);
            String string = TP.f(this);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(vn2.amx(), new String[0]), new OpenOption[0]);){
                string = string.replace("\u00a0", " ");
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public void save(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        this.a(iOutputStorage, textSaveOptions);
    }

    private void a(Url url, TextSaveOptions textSaveOptions) {
        String string = TP.f(this);
        TP.save(url.toString(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        Vo vo2 = new Vo((K)this.getContext());
        IDisposable iDisposable = vo2.a((Url)this.getLocation(), textSaveOptions);
        try {
            Vn vn2 = vo2.amK();
            vn2.a(new SingleDocumentHandlerFactory());
            vn2.a(iOutputStorage);
            vn2.c(this.getLocation(), ".txt");
            String string = TP.f(this);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(URI.create(iOutputStorage.toString())), new OpenOption[0]);){
                string = string.replace("\u00a0", " ");
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }
}

