/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.util;

import com.aspose.html.utils.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsOutputXOFCalculator;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsXOFOperatorFactory;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.io.IOException;

public class Fingerprint {
    private static char[] encodingTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] fingerprint;

    public Fingerprint(byte[] byArray) {
        this(byArray, 160);
    }

    public Fingerprint(byte[] byArray, int n2) {
        this.fingerprint = Fingerprint.calculateFingerprint(byArray, n2);
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.fingerprint);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 != this.fingerprint.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(":");
            }
            stringBuilder.append(encodingTable[this.fingerprint[i2] >>> 4 & 0xF]);
            stringBuilder.append(encodingTable[this.fingerprint[i2] & 0xF]);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Fingerprint) {
            return Arrays.areEqual(((Fingerprint)object).fingerprint, this.fingerprint);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fingerprint);
    }

    public static byte[] calculateFingerprint(byte[] byArray) {
        return Fingerprint.calculateFingerprint(byArray, 160);
    }

    public static byte[] calculateFingerprint(byte[] byArray, int n2) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("bitLength must be a multiple of 8");
        }
        FipsSHS.XOFOperatorFactory<FipsSHS.Parameters> xOFOperatorFactory = new FipsSHS.XOFOperatorFactory<FipsSHS.Parameters>();
        FipsOutputXOFCalculator<FipsSHS.Parameters> fipsOutputXOFCalculator = ((FipsXOFOperatorFactory)xOFOperatorFactory).createOutputXOFCalculator(FipsSHS.SHAKE256);
        try {
            UpdateOutputStream updateOutputStream = fipsOutputXOFCalculator.getFunctionStream();
            updateOutputStream.write(byArray);
            updateOutputStream.close();
            return fipsOutputXOFCalculator.getFunctionOutput(n2 / 8);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("finger print calculation failed");
        }
    }
}

