/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.tsp;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.utils.ms.core.bc.asn1.cms.Attribute;
import com.aspose.html.utils.ms.core.bc.asn1.cms.AttributeTable;
import com.aspose.html.utils.ms.core.bc.asn1.cms.ContentInfo;
import com.aspose.html.utils.ms.core.bc.asn1.cms.IssuerAndSerialNumber;
import com.aspose.html.utils.ms.core.bc.asn1.ess.ESSCertID;
import com.aspose.html.utils.ms.core.bc.asn1.ess.ESSCertIDv2;
import com.aspose.html.utils.ms.core.bc.asn1.ess.SigningCertificate;
import com.aspose.html.utils.ms.core.bc.asn1.ess.SigningCertificateV2;
import com.aspose.html.utils.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.tsp.TSTInfo;
import com.aspose.html.utils.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.utils.ms.core.bc.asn1.x509.IssuerSerial;
import com.aspose.html.utils.ms.core.bc.cert.X509AttributeCertificateHolder;
import com.aspose.html.utils.ms.core.bc.cert.X509CRLHolder;
import com.aspose.html.utils.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.utils.ms.core.bc.cms.CMSException;
import com.aspose.html.utils.ms.core.bc.cms.CMSSignedData;
import com.aspose.html.utils.ms.core.bc.cms.CMSTypedData;
import com.aspose.html.utils.ms.core.bc.cms.SignerId;
import com.aspose.html.utils.ms.core.bc.cms.SignerInformation;
import com.aspose.html.utils.ms.core.bc.cms.SignerInformationVerifier;
import com.aspose.html.utils.ms.core.bc.operator.DigestCalculator;
import com.aspose.html.utils.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.utils.ms.core.bc.tsp.TSPException;
import com.aspose.html.utils.ms.core.bc.tsp.TSPUtil;
import com.aspose.html.utils.ms.core.bc.tsp.TSPValidationException;
import com.aspose.html.utils.ms.core.bc.tsp.TimeStampTokenInfo;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.Store;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeStampToken {
    CMSSignedData tsToken;
    SignerInformation tsaSignerInfo;
    TimeStampTokenInfo tstInfo;
    CertID certID;

    public TimeStampToken(ContentInfo contentInfo) throws TSPException, IOException {
        this(TimeStampToken.getSignedData(contentInfo));
    }

    private static CMSSignedData getSignedData(ContentInfo contentInfo) throws TSPException {
        try {
            return new CMSSignedData(contentInfo);
        }
        catch (CMSException cMSException) {
            throw new TSPException("TSP parsing error: " + cMSException.getMessage(), cMSException.getCause());
        }
    }

    public TimeStampToken(CMSSignedData cMSSignedData) throws TSPException, IOException {
        this.tsToken = cMSSignedData;
        if (!this.tsToken.getSignedContentTypeOID().equals(PKCSObjectIdentifiers.id_ct_TSTInfo.getId())) {
            throw new TSPValidationException("ContentInfo object not for a time stamp.");
        }
        Collection<SignerInformation> collection = this.tsToken.getSignerInfos().getSigners();
        if (collection.size() != 1) {
            throw new IllegalArgumentException("Time-stamp token signed by " + collection.size() + " signers, but it must contain just the TSA signature.");
        }
        this.tsaSignerInfo = collection.iterator().next();
        try {
            CMSTypedData cMSTypedData = this.tsToken.getSignedContent();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cMSTypedData.write(byteArrayOutputStream);
            this.tstInfo = new TimeStampTokenInfo(TSTInfo.getInstance(ASN1Primitive.fromByteArray(byteArrayOutputStream.toByteArray())));
            Attribute attribute = this.tsaSignerInfo.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificate);
            if (attribute != null) {
                SigningCertificate signingCertificate = SigningCertificate.getInstance(attribute.getAttrValues().getObjectAt(0));
                this.certID = new CertID(ESSCertID.getInstance(signingCertificate.getCerts()[0]));
            } else {
                attribute = this.tsaSignerInfo.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
                if (attribute == null) {
                    throw new TSPValidationException("no signing certificate attribute found, time stamp invalid.");
                }
                SigningCertificateV2 signingCertificateV2 = SigningCertificateV2.getInstance(attribute.getAttrValues().getObjectAt(0));
                this.certID = new CertID(ESSCertIDv2.getInstance(signingCertificateV2.getCerts()[0]));
            }
        }
        catch (CMSException cMSException) {
            throw new TSPException(cMSException.getMessage(), cMSException.getUnderlyingException());
        }
    }

    public TimeStampTokenInfo getTimeStampInfo() {
        return this.tstInfo;
    }

    public SignerId getSID() {
        return this.tsaSignerInfo.getSID();
    }

    public AttributeTable getSignedAttributes() {
        return this.tsaSignerInfo.getSignedAttributes();
    }

    public AttributeTable getUnsignedAttributes() {
        return this.tsaSignerInfo.getUnsignedAttributes();
    }

    public Store<X509CertificateHolder> getCertificates() {
        return this.tsToken.getCertificates();
    }

    public Store<X509CRLHolder> getCRLs() {
        return this.tsToken.getCRLs();
    }

    public Store<X509AttributeCertificateHolder> getAttributeCertificates() {
        return this.tsToken.getAttributeCertificates();
    }

    public void validate(SignerInformationVerifier signerInformationVerifier) throws TSPException, TSPValidationException {
        if (!signerInformationVerifier.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("verifier provider needs an associated certificate");
        }
        try {
            X509CertificateHolder x509CertificateHolder = signerInformationVerifier.getAssociatedCertificate();
            DigestCalculator digestCalculator = signerInformationVerifier.getDigestCalculator(this.certID.getHashAlgorithm());
            OutputStream outputStream = digestCalculator.getOutputStream();
            outputStream.write(x509CertificateHolder.getEncoded());
            outputStream.close();
            if (!Arrays.constantTimeAreEqual(this.certID.getCertHash(), digestCalculator.getDigest())) {
                throw new TSPValidationException("certificate hash does not match certID hash.");
            }
            if (this.certID.getIssuerSerial() != null) {
                IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateHolder.toASN1Structure());
                if (!this.certID.getIssuerSerial().getSerial().equals(issuerAndSerialNumber.getSerialNumber())) {
                    throw new TSPValidationException("certificate serial number does not match certID for signature.");
                }
                GeneralName[] generalNameArray = this.certID.getIssuerSerial().getIssuer().getNames();
                boolean bl2 = false;
                for (int i2 = 0; i2 != generalNameArray.length; ++i2) {
                    if (generalNameArray[i2].getTagNo() != 4 || !X500Name.getInstance(generalNameArray[i2].getName()).equals(X500Name.getInstance(issuerAndSerialNumber.getName()))) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    throw new TSPValidationException("certificate name does not match certID for signature. ");
                }
            }
            TSPUtil.validateCertificate(x509CertificateHolder);
            if (!x509CertificateHolder.isValidOn(this.tstInfo.getGenTime())) {
                throw new TSPValidationException("certificate not valid when time stamp created.");
            }
            if (!this.tsaSignerInfo.verify(signerInformationVerifier)) {
                throw new TSPValidationException("signature not created by certificate.");
            }
        }
        catch (CMSException cMSException) {
            if (cMSException.getUnderlyingException() != null) {
                throw new TSPException(cMSException.getMessage(), cMSException.getUnderlyingException());
            }
            throw new TSPException("CMS exception: " + cMSException, cMSException);
        }
        catch (IOException iOException) {
            throw new TSPException("problem processing certificate: " + iOException, iOException);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new TSPException("unable to create digest: " + operatorCreationException.getMessage(), operatorCreationException);
        }
    }

    public boolean isSignatureValid(SignerInformationVerifier signerInformationVerifier) throws TSPException {
        try {
            return this.tsaSignerInfo.verify(signerInformationVerifier);
        }
        catch (CMSException cMSException) {
            if (cMSException.getUnderlyingException() != null) {
                throw new TSPException(cMSException.getMessage(), cMSException.getUnderlyingException());
            }
            throw new TSPException("CMS exception: " + cMSException, cMSException);
        }
    }

    public CMSSignedData toCMSSignedData() {
        return this.tsToken;
    }

    public byte[] getEncoded() throws IOException {
        return this.tsToken.getEncoded("DL");
    }

    public byte[] getEncoded(String string) throws IOException {
        return this.tsToken.getEncoded(string);
    }

    class CertID {
        private ESSCertID certID;
        private ESSCertIDv2 certIDv2;

        CertID(ESSCertID eSSCertID) {
            this.certID = eSSCertID;
            this.certIDv2 = null;
        }

        CertID(ESSCertIDv2 eSSCertIDv2) {
            this.certIDv2 = eSSCertIDv2;
            this.certID = null;
        }

        public AlgorithmIdentifier getHashAlgorithm() {
            if (this.certID != null) {
                return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
            }
            return this.certIDv2.getHashAlgorithm();
        }

        public byte[] getCertHash() {
            if (this.certID != null) {
                return this.certID.getCertHash();
            }
            return this.certIDv2.getCertHash();
        }

        public IssuerSerial getIssuerSerial() {
            if (this.certID != null) {
                return this.certID.getIssuerSerial();
            }
            return this.certIDv2.getIssuerSerial();
        }
    }
}

