/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.tsp;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Set;
import com.aspose.html.utils.ms.core.bc.asn1.cms.Attribute;
import com.aspose.html.utils.ms.core.bc.asn1.cms.AttributeTable;
import com.aspose.html.utils.ms.core.bc.asn1.cms.ContentInfo;
import com.aspose.html.utils.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.nist.NISTObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.x509.ExtendedKeyUsage;
import com.aspose.html.utils.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.utils.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.utils.ms.core.bc.asn1.x509.ExtensionsGenerator;
import com.aspose.html.utils.ms.core.bc.asn1.x509.KeyPurposeId;
import com.aspose.html.utils.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.utils.ms.core.bc.cms.SignerInformation;
import com.aspose.html.utils.ms.core.bc.operator.DigestCalculator;
import com.aspose.html.utils.ms.core.bc.operator.DigestCalculatorProvider;
import com.aspose.html.utils.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.utils.ms.core.bc.tsp.TSPException;
import com.aspose.html.utils.ms.core.bc.tsp.TSPIOException;
import com.aspose.html.utils.ms.core.bc.tsp.TSPValidationException;
import com.aspose.html.utils.ms.core.bc.tsp.TimeStampToken;
import com.aspose.html.utils.ms.core.bc.tsp.TimeStampTokenInfo;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.Integers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TSPUtil {
    private static List EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private static final Map digestLengths = new HashMap();
    private static final Map digestNames = new HashMap();

    public static Collection getSignatureTimestamps(SignerInformation signerInformation, DigestCalculatorProvider digestCalculatorProvider) throws TSPValidationException {
        ArrayList<TimeStampToken> arrayList = new ArrayList<TimeStampToken>();
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        if (attributeTable != null) {
            ASN1EncodableVector aSN1EncodableVector = attributeTable.getAll(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            for (int i2 = 0; i2 < aSN1EncodableVector.size(); ++i2) {
                Attribute attribute = (Attribute)aSN1EncodableVector.get(i2);
                ASN1Set aSN1Set = attribute.getAttrValues();
                for (int i3 = 0; i3 < aSN1Set.size(); ++i3) {
                    try {
                        ContentInfo contentInfo = ContentInfo.getInstance(aSN1Set.getObjectAt(i3));
                        TimeStampToken timeStampToken = new TimeStampToken(contentInfo);
                        TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
                        DigestCalculator digestCalculator = digestCalculatorProvider.get(timeStampTokenInfo.getHashAlgorithm());
                        OutputStream outputStream = digestCalculator.getOutputStream();
                        outputStream.write(signerInformation.getSignature());
                        outputStream.close();
                        byte[] byArray = digestCalculator.getDigest();
                        if (!Arrays.constantTimeAreEqual(byArray, timeStampTokenInfo.getMessageImprintDigest())) {
                            throw new TSPValidationException("Incorrect digest in message imprint");
                        }
                        arrayList.add(timeStampToken);
                        continue;
                    }
                    catch (OperatorCreationException operatorCreationException) {
                        throw new TSPValidationException("Unknown hash algorithm specified in timestamp");
                    }
                    catch (Exception exception) {
                        throw new TSPValidationException("Timestamp could not be parsed");
                    }
                }
            }
        }
        return arrayList;
    }

    public static void validateCertificate(X509CertificateHolder x509CertificateHolder) throws TSPValidationException {
        if (x509CertificateHolder.toASN1Structure().getVersionNumber() != 3) {
            throw new IllegalArgumentException("Certificate must have an ExtendedKeyUsage extension.");
        }
        Extension extension = x509CertificateHolder.getExtension(Extension.extendedKeyUsage);
        if (extension == null) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension.");
        }
        if (!extension.isCritical()) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension marked as critical.");
        }
        ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance(extension.getParsedValue());
        if (!extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_timeStamping) || extendedKeyUsage.size() != 1) {
            throw new TSPValidationException("ExtendedKeyUsage not solely time stamping.");
        }
    }

    static int getDigestLength(String string) throws TSPException {
        Integer n2 = (Integer)digestLengths.get(string);
        if (n2 != null) {
            return n2;
        }
        throw new TSPException("digest algorithm cannot be found.");
    }

    static List getExtensionOIDs(Extensions extensions) {
        if (extensions == null) {
            return EMPTY_LIST;
        }
        return Collections.unmodifiableList(java.util.Arrays.asList(extensions.getExtensionOIDs()));
    }

    static void addExtension(ExtensionsGenerator extensionsGenerator, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) throws TSPIOException {
        try {
            extensionsGenerator.addExtension(aSN1ObjectIdentifier, bl2, aSN1Encodable);
        }
        catch (IOException iOException) {
            throw new TSPIOException("cannot encode extension: " + iOException.getMessage(), iOException);
        }
    }

    static {
        digestLengths.put(PKCSObjectIdentifiers.md5.getId(), Integers.valueOf(16));
        digestLengths.put(OIWObjectIdentifiers.idSHA1.getId(), Integers.valueOf(20));
        digestLengths.put(NISTObjectIdentifiers.id_sha224.getId(), Integers.valueOf(28));
        digestLengths.put(NISTObjectIdentifiers.id_sha256.getId(), Integers.valueOf(32));
        digestLengths.put(NISTObjectIdentifiers.id_sha384.getId(), Integers.valueOf(48));
        digestLengths.put(NISTObjectIdentifiers.id_sha512.getId(), Integers.valueOf(64));
        digestLengths.put(TeleTrusTObjectIdentifiers.ripemd128.getId(), Integers.valueOf(16));
        digestLengths.put(TeleTrusTObjectIdentifiers.ripemd160.getId(), Integers.valueOf(20));
        digestLengths.put(TeleTrusTObjectIdentifiers.ripemd256.getId(), Integers.valueOf(32));
        digestLengths.put(CryptoProObjectIdentifiers.gostR3411.getId(), Integers.valueOf(32));
        digestNames.put(PKCSObjectIdentifiers.md5.getId(), "MD5");
        digestNames.put(OIWObjectIdentifiers.idSHA1.getId(), "SHA1");
        digestNames.put(NISTObjectIdentifiers.id_sha224.getId(), "SHA224");
        digestNames.put(NISTObjectIdentifiers.id_sha256.getId(), "SHA256");
        digestNames.put(NISTObjectIdentifiers.id_sha384.getId(), "SHA384");
        digestNames.put(NISTObjectIdentifiers.id_sha512.getId(), "SHA512");
        digestNames.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "SHA1");
        digestNames.put(PKCSObjectIdentifiers.sha224WithRSAEncryption.getId(), "SHA224");
        digestNames.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), "SHA256");
        digestNames.put(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), "SHA384");
        digestNames.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), "SHA512");
        digestNames.put(TeleTrusTObjectIdentifiers.ripemd128.getId(), "RIPEMD128");
        digestNames.put(TeleTrusTObjectIdentifiers.ripemd160.getId(), "RIPEMD160");
        digestNames.put(TeleTrusTObjectIdentifiers.ripemd256.getId(), "RIPEMD256");
        digestNames.put(CryptoProObjectIdentifiers.gostR3411.getId(), "GOST3411");
    }
}

