/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.pkcs;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Set;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.Attribute;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.CRLBag;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.CertBag;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.SafeBag;
import com.aspose.html.utils.ms.core.bc.asn1.x509.Certificate;
import com.aspose.html.utils.ms.core.bc.asn1.x509.CertificateList;
import com.aspose.html.utils.ms.core.bc.cert.X509CRLHolder;
import com.aspose.html.utils.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.utils.ms.core.bc.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class PKCS12SafeBag {
    public static final ASN1ObjectIdentifier friendlyNameAttribute = PKCSObjectIdentifiers.pkcs_9_at_friendlyName;
    public static final ASN1ObjectIdentifier localKeyIdAttribute = PKCSObjectIdentifiers.pkcs_9_at_localKeyId;
    private SafeBag safeBag;

    public PKCS12SafeBag(SafeBag safeBag) {
        this.safeBag = safeBag;
    }

    public SafeBag toASN1Structure() {
        return this.safeBag;
    }

    public ASN1ObjectIdentifier getType() {
        return this.safeBag.getBagId();
    }

    public Attribute[] getAttributes() {
        ASN1Set aSN1Set = this.safeBag.getBagAttributes();
        if (aSN1Set == null) {
            return null;
        }
        Attribute[] attributeArray = new Attribute[aSN1Set.size()];
        for (int i2 = 0; i2 != aSN1Set.size(); ++i2) {
            attributeArray[i2] = Attribute.getInstance(aSN1Set.getObjectAt(i2));
        }
        return attributeArray;
    }

    public Object getBagValue() {
        if (this.getType().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
            return new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance(this.safeBag.getBagValue()));
        }
        if (this.getType().equals(PKCSObjectIdentifiers.certBag)) {
            CertBag certBag = CertBag.getInstance(this.safeBag.getBagValue());
            return new X509CertificateHolder(Certificate.getInstance(ASN1OctetString.getInstance(certBag.getCertValue()).getOctets()));
        }
        if (this.getType().equals(PKCSObjectIdentifiers.keyBag)) {
            return PrivateKeyInfo.getInstance(this.safeBag.getBagValue());
        }
        if (this.getType().equals(PKCSObjectIdentifiers.crlBag)) {
            CRLBag cRLBag = CRLBag.getInstance(this.safeBag.getBagValue());
            return new X509CRLHolder(CertificateList.getInstance(ASN1OctetString.getInstance(cRLBag.getCrlValue()).getOctets()));
        }
        return this.safeBag.getBagValue();
    }
}

