/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.crypto.OutputDigestCalculator;
import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsDigestOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSHS;
import java.security.MessageDigest;

final class BaseMessageDigest
extends MessageDigest
implements Cloneable {
    private static FipsDigestOperatorFactory<FipsSHS.Parameters> fipsFactory = new FipsSHS.OperatorFactory<FipsSHS.Parameters>();
    private final OutputDigestCalculator digestCalculator;
    private final UpdateOutputStream digestStream;

    protected BaseMessageDigest(FipsSHS.Parameters parameters) {
        this(fipsFactory.createOutputDigestCalculator(parameters));
    }

    BaseMessageDigest(OutputDigestCalculator outputDigestCalculator) {
        super(((Parameters)outputDigestCalculator.getParameters()).getAlgorithm().getName());
        this.digestCalculator = outputDigestCalculator;
        this.digestStream = outputDigestCalculator.getDigestStream();
    }

    protected void engineReset() {
        this.digestCalculator.reset();
    }

    protected void engineUpdate(byte by2) {
        this.digestStream.update(by2);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.digestStream.update(byArray, n2, n3);
    }

    protected byte[] engineDigest() {
        byte[] byArray = this.digestCalculator.getDigest();
        this.engineReset();
        return byArray;
    }

    protected int engineGetDigestLength() {
        return this.digestCalculator.getDigestSize();
    }

    public Object clone() throws CloneNotSupportedException {
        return new BaseMessageDigest(this.digestCalculator.clone());
    }
}

