/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BlockCipherMode;
import java.security.SecureRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Mode {
    ECB(BlockCipherMode.ECB),
    CBC(BlockCipherMode.CBC),
    CBCMAC(BlockCipherMode.CBCMAC),
    CFB8(BlockCipherMode.CFB8),
    CFB8MAC(BlockCipherMode.CFB8MAC),
    CFB16(BlockCipherMode.CFB16),
    CFB32(BlockCipherMode.CFB32),
    CFB64(BlockCipherMode.CFB64),
    CFB128(BlockCipherMode.CFB128),
    CFB256(BlockCipherMode.CFB256),
    OFB8(BlockCipherMode.OFB8),
    OFB16(BlockCipherMode.OFB16),
    OFB32(BlockCipherMode.OFB32),
    OFB64(BlockCipherMode.OFB64),
    OFB128(BlockCipherMode.OFB128),
    OFB256(BlockCipherMode.OFB256),
    CTR(BlockCipherMode.CTR),
    GCM(BlockCipherMode.GCM),
    CCM(BlockCipherMode.CCM),
    OCB(BlockCipherMode.OCB),
    EAX(BlockCipherMode.EAX),
    GOSTMAC(BlockCipherMode.GOSTMAC),
    CMAC(BlockCipherMode.CMAC),
    GMAC(BlockCipherMode.GMAC),
    WRAP(BlockCipherMode.WRAP),
    WRAPPAD(BlockCipherMode.WRAPPAD),
    RFC3217_WRAP(BlockCipherMode.RFC3217_WRAP),
    RFC3211_WRAP(BlockCipherMode.RFC3211_WRAP),
    OpenPGPCFB(BlockCipherMode.OpenPGPCFB),
    GCFB(BlockCipherMode.GCFB),
    GOFB(BlockCipherMode.GOFB),
    ISO9797alg3(BlockCipherMode.ISO9797alg3);

    private final BlockCipherMode baseMode;

    private Mode(BlockCipherMode blockCipherMode) {
        this.baseMode = blockCipherMode;
    }

    BlockCipherMode getBaseMode() {
        return this.baseMode;
    }

    byte[] checkIv(byte[] byArray, int n2) {
        switch (this.baseMode) {
            case CBC: 
            case CFB8: 
            case CFB16: 
            case CFB32: 
            case CFB64: 
            case CFB128: 
            case CFB256: 
            case OFB8: 
            case OFB16: 
            case OFB32: 
            case OFB64: 
            case OFB128: 
            case OFB256: {
                if (byArray == null || byArray.length == n2) break;
                throw new IllegalArgumentException("IV must be " + n2 + " bytes long");
            }
            case CTR: {
                if (byArray == null || byArray.length <= n2) break;
                throw new IllegalArgumentException("CTR IV must be less than " + n2 + " bytes long");
            }
        }
        return byArray;
    }

    byte[] createDefaultIvIfNecessary(int n2, SecureRandom secureRandom) {
        if (this.baseMode.expectsIV()) {
            return this.baseMode.createDefaultIV(n2, secureRandom);
        }
        return null;
    }

    byte[] createIvIfNecessary(int n2, SecureRandom secureRandom) {
        if (this.baseMode.expectsIV()) {
            byte[] byArray = new byte[n2];
            if (secureRandom != null) {
                secureRandom.nextBytes(byArray);
            } else {
                CryptoServicesRegistrar.getSecureRandom().nextBytes(byArray);
            }
            return byArray;
        }
        return null;
    }
}

