/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.fips.DsaKCalculator;
import com.aspose.html.utils.ms.core.bc.crypto.fips.RandomDsaKCalculator;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.DsaKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.DsaParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.DsaPrivateKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.DsaPublicKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import java.math.BigInteger;
import java.security.SecureRandom;

class DsaSigner
implements DSA {
    private final DsaKCalculator kCalculator;
    private DsaKeyParameters key;
    private SecureRandom random;

    public DsaSigner() {
        this.kCalculator = new RandomDsaKCalculator();
    }

    public DsaSigner(DsaKCalculator dsaKCalculator) {
        this.kCalculator = dsaKCalculator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (!(cipherParameters instanceof ParametersWithRandom)) throw new IllegalArgumentException("No random provided where one required.");
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            this.key = (DsaPrivateKeyParameters)parametersWithRandom.getParameters();
            return;
        } else {
            this.key = (DsaPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        DsaParameters dsaParameters = this.key.getParameters();
        BigInteger bigInteger = this.calculateE(dsaParameters.getQ(), byArray);
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(dsaParameters.getQ(), ((DsaPrivateKeyParameters)this.key).getX(), byArray);
        } else {
            this.kCalculator.init(dsaParameters.getQ(), this.random);
        }
        BigInteger bigInteger2 = this.kCalculator.nextK();
        BigInteger bigInteger3 = dsaParameters.getG().modPow(bigInteger2.add(this.getRandomizer(dsaParameters.getQ(), this.random)), dsaParameters.getP()).mod(dsaParameters.getQ());
        bigInteger2 = bigInteger2.modInverse(dsaParameters.getQ()).multiply(bigInteger.add(((DsaPrivateKeyParameters)this.key).getX().multiply(bigInteger3)));
        BigInteger bigInteger4 = bigInteger2.mod(dsaParameters.getQ());
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        DsaParameters dsaParameters = this.key.getParameters();
        BigInteger bigInteger3 = this.calculateE(dsaParameters.getQ(), byArray);
        BigInteger bigInteger4 = BigInteger.valueOf(0L);
        if (bigInteger4.compareTo(bigInteger) >= 0 || dsaParameters.getQ().compareTo(bigInteger) <= 0) {
            return false;
        }
        if (bigInteger4.compareTo(bigInteger2) >= 0 || dsaParameters.getQ().compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger2.modInverse(dsaParameters.getQ());
        BigInteger bigInteger6 = bigInteger3.multiply(bigInteger5).mod(dsaParameters.getQ());
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger5).mod(dsaParameters.getQ());
        bigInteger6 = dsaParameters.getG().modPow(bigInteger6, dsaParameters.getP());
        bigInteger7 = ((DsaPublicKeyParameters)this.key).getY().modPow(bigInteger7, dsaParameters.getP());
        BigInteger bigInteger8 = bigInteger6.multiply(bigInteger7).mod(dsaParameters.getP()).mod(dsaParameters.getQ());
        return bigInteger8.equals(bigInteger);
    }

    private BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        if (bigInteger.bitLength() >= byArray.length * 8) {
            return new BigInteger(1, byArray);
        }
        byte[] byArray2 = new byte[bigInteger.bitLength() / 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }

    private BigInteger getRandomizer(BigInteger bigInteger, SecureRandom secureRandom) {
        int n2 = 7;
        return new BigInteger(n2, secureRandom).add(BigInteger.valueOf(128L)).multiply(bigInteger);
    }
}

