/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers;

import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.TiffImageException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers.TiffByteConverterWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IAdvancedBufferProcessor;

public class TiffPackBitsWriter
extends TiffByteConverterWriter {
    private BufferProcessor a;
    private TiffByteConverterWriter.ColorConverter b;

    public TiffPackBitsWriter(TiffOptions tiffOptions, int n2, int n3) {
        super(tiffOptions, n2, n3);
    }

    @Override
    public void encode(int[] nArray, Rectangle rectangle, IAdvancedBufferProcessor iAdvancedBufferProcessor) {
        if (this.b == null) {
            int n2 = this.getRowsPerStrip();
            this.b = TiffByteConverterWriter.getColorConverter(this.getOptions(), this.getWidth(), this.getHeight(), n2);
            PackBitsEncoder packBitsEncoder = new PackBitsEncoder(iAdvancedBufferProcessor, n2, this.getOptions().getBitsPerPixel(), this.getWidth());
            packBitsEncoder.startEncoding();
            this.a = new BufferProcessor(packBitsEncoder, this.getHeight(), n2);
        }
        this.b.convert(nArray, this.a);
    }

    static class PackBitsEncoder {
        private final IAdvancedBufferProcessor a;
        private final int b;
        private final int c;
        private byte[] d;
        private int e;

        public PackBitsEncoder(IAdvancedBufferProcessor iAdvancedBufferProcessor, int n2, int n3, int n4) {
            this.a = iAdvancedBufferProcessor;
            int n5 = (n3 * n4 + 7) / 8;
            int n6 = n5 + (n5 + 127) / 128;
            this.c = n6 * n2;
            this.b = n5;
        }

        public void startEncoding() {
            this.d = new byte[this.c];
            this.e = 0;
        }

        public void finishEncoding(int n2) {
            this.a.processBuffer(this.d, this.e);
            this.a.finishRows(n2);
        }

        public void encode(byte[] byArray, int n2) {
            int n3 = n2;
            int n4 = 0;
            do {
                this.e = PackBitsEncoder.a(byArray, n4, this.b, this.d, this.e);
                n4 += this.b;
            } while ((n3 -= this.b) >= this.b);
            if (n3 != 0) {
                throw new TiffImageException("The strip has corrupt data and cannot be decoded.");
            }
        }

        private static int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
            int n5 = n2 + n3 - 1;
            int n6 = n5 - 1;
            while (n2 <= n5) {
                int n7;
                byte by2 = byArray[n2];
                for (n7 = 1; n7 < 127 && n2 < n5 && (byArray[n2] & 0xFF) == (byArray[n2 + 1] & 0xFF); ++n7, ++n2) {
                }
                if (n7 > 1) {
                    ++n2;
                    byArray2[n4++] = (byte)(-(n7 - 1) & 0xFF);
                    byArray2[n4++] = by2;
                }
                int n8 = n4;
                for (n7 = 0; n7 < 128 && (n2 < n5 && (byArray[n2] & 0xFF) != (byArray[n2 + 1] & 0xFF) || n2 < n6 && (byArray[n2] & 0xFF) != (byArray[n2 + 2] & 0xFF)); ++n7) {
                    byArray2[++n4] = byArray[n2++];
                }
                if (n7 > 0) {
                    byArray2[n8] = (byte)(n7 - 1 & 0xFF);
                    ++n4;
                }
                if (n2 != n5) continue;
                if (n7 > 0 && n7 < 128) {
                    int n9 = n8;
                    byArray2[n9] = (byte)(byArray2[n9] + 1);
                    byArray2[n4++] = byArray[n2++];
                    continue;
                }
                byArray2[n4++] = 0;
                byArray2[n4++] = byArray[n2++];
            }
            return n4;
        }
    }

    static class BufferProcessor
    implements IAdvancedBufferProcessor {
        private final PackBitsEncoder a;
        private final int b;
        private int c;
        private int d;

        public BufferProcessor(PackBitsEncoder packBitsEncoder, int n2, int n3) {
            this.a = packBitsEncoder;
            this.b = n3;
            this.c = n2;
            this.d = n3;
        }

        @Override
        public void finishRow() {
            this.finishRows(this.b);
        }

        @Override
        public void finishRows(int n2) {
            this.d -= n2;
            if (this.d == 0) {
                int n3 = msMath.min(this.b, this.c);
                this.a.finishEncoding(n3);
                this.c -= n3;
                if (this.c > 0) {
                    this.d = msMath.min(this.b, this.c);
                    this.a.startEncoding();
                }
            }
        }

        @Override
        public void processBuffer(byte[] byArray, int n2) {
            this.a.encode(byArray, n2);
        }
    }
}

