/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.IO.File;
import com.aspose.html.utils.ms.System.IO.FileStream;
import com.aspose.html.utils.ms.System.IO.MemoryStream;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.DisposableObject;

public class StreamContainer
extends DisposableObject {
    public static final int READ_WRITE_BYTES_COUNT = 4096;
    private final Stream a;
    private final boolean b;
    private final long c;

    public StreamContainer(Stream stream) {
        this(stream, false);
    }

    public StreamContainer(Stream stream, boolean bl2) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a = stream;
        this.b = bl2;
        this.c = this.a.getPosition();
    }

    public long getPosition() {
        this.verifyNotDisposed();
        return this.a.getPosition() - this.c;
    }

    public void setPosition(long l2) {
        this.verifyNotDisposed();
        this.a.setPosition(l2 + this.c);
    }

    public Stream getStream() {
        this.verifyNotDisposed();
        return this.a;
    }

    public boolean isStreamDisposedOnClose() {
        this.verifyNotDisposed();
        return this.b;
    }

    public long getLength() {
        this.verifyNotDisposed();
        return this.a.getLength() - this.c;
    }

    public void setLength(long l2) {
        this.verifyNotDisposed();
        this.a.setLength(l2 + this.c);
    }

    public boolean canRead() {
        this.verifyNotDisposed();
        return this.a.canRead();
    }

    public boolean canSeek() {
        this.verifyNotDisposed();
        return this.a.canSeek();
    }

    public boolean canWrite() {
        this.verifyNotDisposed();
        return this.a.canWrite();
    }

    public static Stream to_Stream(StreamContainer streamContainer) {
        Stream stream = null;
        if (streamContainer != null) {
            stream = streamContainer.a;
        }
        return stream;
    }

    public void flush() {
        this.verifyNotDisposed();
        this.a.flush();
    }

    public void write(byte[] byArray) {
        this.verifyNotDisposed();
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        this.a.write(byArray, 0, byArray.length);
    }

    public void writeByte(byte by2) {
        this.verifyNotDisposed();
        this.a.writeByte(by2);
    }

    public int read(byte[] byArray) {
        this.verifyNotDisposed();
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        return this.a.read(byArray, 0, byArray.length);
    }

    public byte[] toBytes() {
        this.verifyNotDisposed();
        return this.toBytes(0L, this.getLength());
    }

    public void shift(long l2) {
        if (this.getPosition() >= this.getLength() || this.getPosition() < 0L) {
            throw new IllegalStateException("FrameworkException: Cannot perform shift as position is out of stream bounds.");
        }
        if (l2 != 0L) {
            long l3 = this.getLength();
            if (l2 > 0L) {
                this.setLength(l3 + l2);
            }
            if (this.getPosition() + l2 < 0L) {
                throw new ArgumentOutOfRangeException("shift", "The backward shift causes data to pass stream beginning. Cannot proceed.");
            }
            byte[] byArray = new byte[4096];
            long l4 = this.getPosition();
            int n2 = (int)msMath.min((long)byArray.length, l3 - l4);
            long l5 = l2 > 0L ? l3 - (long)n2 : l4;
            while (n2 > 0) {
                this.setPosition(l5);
                if (this.a.read(byArray, 0, n2) != n2) {
                    throw new IllegalStateException("FrameworkException: Shift error occured. Cannot proceed. The data may be corrupted.");
                }
                this.setPosition(l5 + l2);
                this.a.write(byArray, 0, n2);
                if (l2 < 0L) {
                    n2 = (int)msMath.min((long)byArray.length, l3 - (l5 += (long)n2));
                    continue;
                }
                n2 = (int)msMath.min((long)byArray.length, l5 - l4);
                l5 -= (long)n2;
            }
            if (l2 < 0L) {
                this.setLength(this.getLength() + l2);
            }
        }
    }

    public byte[] toBytes(long l2, long l3) {
        this.verifyNotDisposed();
        if (l2 >= this.getLength() || l2 < 0L) {
            throw new ArgumentOutOfRangeException("position", "The starting position is out of stream bounds.");
        }
        if (l3 > this.getLength()) {
            throw new ArgumentOutOfRangeException("bytesCount", "The stream does not contain so many bytes.");
        }
        if (l3 + l2 > this.getLength() && l3 > 0L) {
            throw new ArgumentException("Reading so many bytes will cause passing the stream end.");
        }
        if (this.a.canSeek()) {
            this.setPosition(l2);
        } else if (this.getPosition() != l2) {
            throw new IllegalStateException("Cannot seek to the desired position. The stream does not support seeking.");
        }
        byte[] byArray = new byte[(int)l3];
        long l4 = 0L;
        byte[] byArray2 = new byte[4096];
        while (l3 > 0L) {
            int n2 = (int)msMath.min((long)byArray2.length, l3);
            if (this.a.read(byArray2, 0, n2) != n2) {
                throw new IllegalStateException(StringExtensions.concat("Copy operation cannot complete. Cannot read ", Int32Extensions.toString(n2), " bytes."));
            }
            Array.copy(Array.boxing(byArray2), 0L, Array.boxing(byArray), l4, (long)n2);
            l4 += (long)n2;
            l3 -= (long)n2;
        }
        return byArray;
    }

    public int read(byte[] byArray, int n2, int n3) {
        this.verifyNotDisposed();
        return this.a.read(byArray, n2, n3);
    }

    public int readByte() {
        this.verifyNotDisposed();
        return this.a.readByte();
    }

    public long seek(long l2, int n2) {
        this.verifyNotDisposed();
        if (n2 == 0) {
            this.a.seek(l2 + this.c, n2);
        } else {
            this.a.seek(l2, n2);
        }
        return this.getPosition();
    }

    public void seekBegin() {
        this.verifyNotDisposed();
        this.a.seek(this.c, 0);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.verifyNotDisposed();
        this.a.write(byArray, n2, n3);
    }

    public void save(Stream stream) {
        this.saveInternal(stream, 4096, this.getLength());
    }

    void save(Stream stream, int n2) {
        this.saveInternal(stream, n2, this.getLength());
    }

    public void saveInternal(Stream stream, int n2, long l2) {
        int n3;
        this.verifyNotDisposed();
        if (stream == null) {
            throw new ArgumentNullException("destinationStream");
        }
        if (stream == this.a) {
            throw new IllegalStateException("Saving to the same stream is not allowed.");
        }
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "The buffer must be positive.");
        }
        this.beforeSave(stream);
        byte[] byArray = new byte[(int)msMath.min((long)n2, l2)];
        while (l2 > 0L && (n3 = this.a.read(byArray, 0, (int)msMath.min((long)byArray.length, l2))) > 0) {
            stream.write(byArray, 0, n3);
            l2 -= (long)n3;
        }
    }

    public void save(String string) {
        this.save(string, 4096, this.getLength());
    }

    public void save(String string, int n2) {
        this.save(string, n2, this.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, int n2, long l2) {
        this.verifyNotDisposed();
        if (string == null) {
            throw new ArgumentNullException("filePath");
        }
        this.a.setPosition(0L);
        FileStream fileStream = File.create(string);
        try {
            this.saveInternal(fileStream, n2, l2);
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
    }

    public void writeTo(StreamContainer streamContainer) {
        long l2 = this.getLength() - this.getPosition();
        this.writeTo(streamContainer, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(StreamContainer streamContainer, long l2) {
        MemoryStream memoryStream = new MemoryStream(this.toBytes());
        try {
            byte[] byArray = new byte[4096];
            while (l2 > 0L) {
                int n2 = (int)msMath.min((long)byArray.length, l2);
                if (((Stream)memoryStream).read(byArray, 0, n2) != n2) {
                    throw new IllegalStateException(StringExtensions.concat("Copy operation cannot complete. Cannot read ", Int32Extensions.toString(n2), " bytes."));
                }
                l2 -= (long)n2;
                streamContainer.write(byArray, 0, n2);
            }
        }
        finally {
            if (memoryStream != null) {
                memoryStream.dispose();
            }
        }
    }

    protected void afterStreamDisposed() {
    }

    protected void beforeStreamDisposed() {
    }

    public void beforeSave(Stream stream) {
    }

    @Override
    protected void releaseManagedResources() {
        try {
            this.a();
        }
        finally {
            super.releaseManagedResources();
        }
    }

    private void a() {
        if (this.b) {
            this.beforeStreamDisposed();
            try {
                this.a.dispose();
            }
            finally {
                this.afterStreamDisposed();
            }
        }
    }
}

