/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.ms.System.OutOfMemoryException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorInfo;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import java.awt.Color;

public class ColorHelper {
    private static int a;

    public static int getMaxAllowedAllocation() {
        return a;
    }

    public static void setMaxAllowedAllocation(int n2) {
        a = n2;
    }

    public static ColorInfo allocate(Rectangle rectangle) {
        int[] nArray = null;
        int n2 = 2;
        while (nArray == null) {
            try {
                int n3 = rectangle.getWidth() * rectangle.getHeight();
                if (ColorHelper.getMaxAllowedAllocation() > 0 && n3 > ColorHelper.getMaxAllowedAllocation()) {
                    throw new OutOfMemoryException();
                }
                nArray = ArrayHelper.getColors(n3);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (rectangle.getHeight() > 1) {
                    rectangle.setHeight(rectangle.getHeight() / n2);
                    if (rectangle.getHeight() <= 1) {
                        rectangle.setHeight(1);
                        n2 = 1;
                    }
                } else if (rectangle.getWidth() > 1) {
                    rectangle.setWidth(rectangle.getWidth() / n2);
                    if (rectangle.getWidth() < 1) {
                        rectangle.setWidth(1);
                    }
                } else {
                    throw outOfMemoryError;
                }
                n2 <<= 1;
            }
        }
        return new ColorInfo(rectangle.Clone(), nArray);
    }

    public static Color newColor(Color color) {
        return new Color(color.getRGB(), true);
    }

    public static Color fromArgb(int n2, int n3, int n4, int n5) {
        return new Color(n3, n4, n5, n2);
    }

    public static Color fromArgb(int n2, int n3, int n4) {
        return new Color(n2, n3, n4, 255);
    }

    public static Color fromArgb(int n2) {
        return ColorHelper.fromArgb(n2 >>> 24 & 0xFF, n2 >>> 16 & 0xFF, n2 >>> 8 & 0xFF, n2 & 0xFF);
    }

    public static int toArgb(Color color) {
        return color.getRGB();
    }

    public static int toArgb(int n2, int n3, int n4, int n5) {
        return (n2 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n4 & 0xFF) << 8 | (n5 & 0xFF) << 0;
    }

    public static int toArgb(int n2, int n3, int n4) {
        return ColorHelper.toArgb(255, n2, n3, n4);
    }

    public static byte getA(int n2) {
        return (byte)(n2 >>> 24 & 0xFF);
    }

    public static byte getR(int n2) {
        return (byte)(n2 >>> 16 & 0xFF);
    }

    public static byte getG(int n2) {
        return (byte)(n2 >>> 8 & 0xFF);
    }

    public static byte getB(int n2) {
        return (byte)(n2 >>> 0 & 0xFF);
    }
}

