/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs;

import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public abstract class AwtUtils {
    static long count;

    public static int[] getColors(BufferedImage bufferedImage) {
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getWidth();
        return AwtUtils.getColors(bufferedImage, new Rectangle(0, 0, n3, n2));
    }

    public static int[] getColors(BufferedImage bufferedImage, Rectangle rectangle) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = rectangle.getX();
        int n3 = rectangle.getY();
        int[] nArray = new int[rectangle.getWidth() * rectangle.getHeight()];
        int n4 = rectangle.getHeight();
        int n5 = bufferedImage.getWidth();
        switch (bufferedImage.getType()) {
            case 0: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                AwtUtils.a(bufferedImage, n2, n3, n5, n4, nArray);
                break;
            }
            case 1: {
                AwtUtils.a(writableRaster, n3 * n5 + n2, nArray);
                break;
            }
            case 2: {
                AwtUtils.b(writableRaster, n3 * n5 + n2, nArray);
                break;
            }
            case 4: {
                AwtUtils.c(writableRaster, n3 * n5 + n2, nArray);
                break;
            }
            case 5: {
                AwtUtils.a(writableRaster, n2, n3, n5, n4, nArray);
                break;
            }
            case 6: {
                AwtUtils.b(writableRaster, n2, n3, n5, n4, nArray);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected image type %s", bufferedImage.getType()));
            }
        }
        return nArray;
    }

    private static void a(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int[] nArray) {
        ColorModel colorModel = bufferedImage.getColorModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        Object object = AwtUtils.createDataBufferData(writableRaster);
        int n6 = writableRaster.getDataBuffer().getDataType();
        int n7 = 0;
        Object object2 = null;
        int n8 = 0;
        int n9 = writableRaster.getNumBands();
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                Object object3 = writableRaster.getDataElements(i3, i2, object);
                Object object4 = null;
                if (n9 == 1) {
                    object4 = AwtUtils.getDataBufferItem(n6, object3, 0);
                }
                int n10 = object4 != null && object4.equals(object2) ? n8 : colorModel.getRGB(object3);
                nArray[n7++] = n10;
                object2 = object4;
                n8 = n10;
            }
        }
    }

    private static void a(Raster raster, int n2, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        System.arraycopy(nArray2, n2, nArray, 0, nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = AwtUtils.verifyA(nArray[i2]);
        }
    }

    public static int verifyA(int n2) {
        int n3 = n2 >>> 24 & 0xFF;
        int n4 = n2 >>> 16 & 0xFF;
        int n5 = n2 >>> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        if (n3 != 0) {
            return n2;
        }
        n3 = 255;
        return (n3 << 24) + (n4 << 16) + (n5 << 8) + n6;
    }

    private static void b(Raster raster, int n2, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        System.arraycopy(nArray2, n2, nArray, 0, nArray.length);
    }

    private static void c(Raster raster, int n2, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        int n3 = 0;
        for (int i2 = n2; i2 < nArray2.length; ++i2) {
            int n4 = nArray2[i2];
            int n5 = n4 >> 16 & 0xFF;
            int n6 = n4 >> 8 & 0xFF;
            int n7 = n4 & 0xFF;
            int n8 = 0xFF000000 | n7 << 16 | n6 << 8 | n5;
            nArray[n3++] = n8;
        }
    }

    private static void a(Raster raster, int n2, int n3, int n4, int n5, int[] nArray) {
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n6 = 0;
        int n7 = (n3 * n4 + n2) * 3;
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                int n8 = byArray[n7++] & 0xFF;
                int n9 = byArray[n7++] & 0xFF;
                int n10 = byArray[n7++] & 0xFF;
                int n11 = 0xFF000000 | n10 << 16 | n9 << 8 | n8;
                nArray[n6++] = n11;
            }
        }
    }

    private static void b(Raster raster, int n2, int n3, int n4, int n5, int[] nArray) {
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n6 = 0;
        int n7 = (n3 * n4 + n2) * 4;
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                int n8 = byArray[n7++] & 0xFF;
                int n9 = byArray[n7++] & 0xFF;
                int n10 = byArray[n7++] & 0xFF;
                int n11 = byArray[n7++] & 0xFF;
                int n12 = n8 << 24 | n11 << 16 | n10 << 8 | n9;
                nArray[n6++] = n12;
            }
        }
    }

    public static void setColors(int[] nArray, BufferedImage bufferedImage) {
        AwtUtils.setColors(nArray, bufferedImage, 0, 0);
    }

    public static void setColors(int[] nArray, BufferedImage bufferedImage, int n2, int n3) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n4 = bufferedImage.getHeight();
        int n5 = bufferedImage.getWidth();
        switch (bufferedImage.getType()) {
            case 0: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                AwtUtils.b(bufferedImage, n2, n3, n5, n4, nArray);
                break;
            }
            case 1: 
            case 2: {
                AwtUtils.c(writableRaster, n2, n3, n5, n4, nArray);
                break;
            }
            case 4: {
                AwtUtils.d(writableRaster, n2, n3, n5, n4, nArray);
                break;
            }
            case 5: {
                AwtUtils.e(writableRaster, n2, n3, n5, n4, nArray);
                break;
            }
            case 6: {
                AwtUtils.f(writableRaster, n2, n3, n5, n4, nArray);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected image type %s", bufferedImage.getType()));
            }
        }
    }

    private static void b(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int[] nArray) {
        ColorModel colorModel = bufferedImage.getColorModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        Object object = AwtUtils.createDataBufferData(writableRaster);
        int n6 = n4 * n3 + n2;
        for (int i2 = n3; i2 < n5; ++i2) {
            for (int i3 = n2; i3 < n4; ++i3) {
                int n7 = nArray[n6++];
                writableRaster.setDataElements(i3, i2, colorModel.getDataElements(n7, object));
            }
        }
    }

    private static void c(Raster raster, int n2, int n3, int n4, int n5, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        System.arraycopy(nArray, 0, nArray2, n4 * n3 + n2, nArray.length);
    }

    private static void d(Raster raster, int n2, int n3, int n4, int n5, int[] nArray) {
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        int n6 = n4 * n3 + n2;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n7 = nArray[i2];
            int n8 = n7 >> 16 & 0xFF;
            int n9 = n7 >> 8 & 0xFF;
            int n10 = n7 & 0xFF;
            int n11 = 0xFF000000 | n10 << 16 | n9 << 8 | n8;
            nArray2[n6++] = n11;
        }
    }

    private static void e(Raster raster, int n2, int n3, int n4, int n5, int[] nArray) {
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n6 = (n4 * n3 + n2) * 3;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n7 = nArray[i2];
            byte by2 = (byte)(n7 >> 16 & 0xFF);
            byte by3 = (byte)(n7 >> 8 & 0xFF);
            byte by4 = (byte)(n7 & 0xFF);
            byArray[n6++] = by4;
            byArray[n6++] = by3;
            byArray[n6++] = by2;
        }
    }

    private static void f(Raster raster, int n2, int n3, int n4, int n5, int[] nArray) {
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n6 = (n4 * n3 + n2) * 4;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n7 = nArray[i2];
            byte by2 = (byte)(n7 >> 24 & 0xFF);
            byte by3 = (byte)(n7 >> 16 & 0xFF);
            byte by4 = (byte)(n7 >> 8 & 0xFF);
            byte by5 = (byte)(n7 & 0xFF);
            byArray[n6++] = by2;
            byArray[n6++] = by5;
            byArray[n6++] = by4;
            byArray[n6++] = by3;
        }
    }

    public static Object createDataBufferData(Raster raster) {
        int n2 = raster.getDataBuffer().getDataType();
        switch (n2) {
            case 0: {
                return new byte[raster.getNumBands()];
            }
            case 1: {
                return new short[raster.getNumBands()];
            }
            case 3: {
                return new int[raster.getNumBands()];
            }
            case 4: {
                return new float[raster.getNumBands()];
            }
            case 5: {
                return new double[raster.getNumBands()];
            }
        }
        throw new IllegalArgumentException("Unknown data buffer type: " + n2);
    }

    public static Object getDataBufferItem(int n2, Object object, int n3) {
        switch (n2) {
            case 0: {
                return ((byte[])object)[n3];
            }
            case 1: {
                return ((short[])object)[n3];
            }
            case 3: {
                return ((int[])object)[n3];
            }
            case 4: {
                return Float.valueOf(((float[])object)[n3]);
            }
            case 5: {
                return ((double[])object)[n3];
            }
        }
        throw new IllegalArgumentException("Unknown data buffer type: " + n2);
    }
}

