/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing.Printing;

import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.Drawing.Bitmap;
import com.aspose.html.utils.ms.System.Drawing.Brush;
import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.System.Drawing.Graphics;
import com.aspose.html.utils.ms.System.Drawing.Image;
import com.aspose.html.utils.ms.System.Drawing.Imaging.Metafile;
import com.aspose.html.utils.ms.System.Drawing.Point;
import com.aspose.html.utils.ms.System.Drawing.Printing.InvalidPrinterException;
import com.aspose.html.utils.ms.System.Drawing.Printing.PageSettings;
import com.aspose.html.utils.ms.System.Drawing.Printing.PrintController;
import com.aspose.html.utils.ms.System.Drawing.Printing.PrintDocument;
import com.aspose.html.utils.ms.System.Drawing.Printing.PrintEventArgs;
import com.aspose.html.utils.ms.System.Drawing.Printing.PrintPageEventArgs;
import com.aspose.html.utils.ms.System.Drawing.Printing.PrinterSettings;
import com.aspose.html.utils.ms.System.Drawing.Rectangle;
import com.aspose.html.utils.ms.System.Drawing.Size;
import com.aspose.html.utils.ms.System.Drawing.SolidBrush;
import com.aspose.html.utils.ms.System.SystemException;
import com.aspose.html.utils.ms.core.System.Drawing.Printing.Loaders.PrintAttributesLoader;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

public class StandardPrintController
extends PrintController {
    private List<PrintBitmap> b = new List();
    private Graphics c;
    private boolean d;
    private PrinterJob e;
    private PrintRequestAttributeSet f;
    private PrintAttributesLoader g;
    private boolean h = false;

    public boolean isUseWmf() {
        return this.h;
    }

    public void setUseWmf(boolean bl2) {
        this.h = bl2;
    }

    @Override
    public void onStartPrint(PrintDocument printDocument, PrintEventArgs printEventArgs) {
        super.onStartPrint(printDocument, printEventArgs);
        if (!printDocument.getPrinterSettings().isValid()) {
            throw new InvalidPrinterException(printDocument.getPrinterSettings());
        }
        if (printDocument.getPrinterSettings().getPrintToFile()) {
            // empty if block
        }
        PrinterSettings printerSettings = printDocument.getPrinterSettings();
        String string = printerSettings.getPrinterName();
        this.e = PrinterJob.getPrinterJob();
        MultiPagePrintDocument multiPagePrintDocument = new MultiPagePrintDocument();
        this.e.setPageable(multiPagePrintDocument);
        this.g = new PrintAttributesLoader(printerSettings);
        this.f = this.g.convert().getPrintRequestAttributeSet();
        this.a(this.f, printDocument);
        PrintService printService = this.a(string);
        try {
            this.e.setPrintService(printService);
        }
        catch (PrinterException printerException) {
            this.d = true;
        }
        if (this.d) {
            printEventArgs.setCancel(true);
        }
    }

    @Override
    public Graphics onStartPage(PrintDocument printDocument, PrintPageEventArgs printPageEventArgs) {
        super.onStartPage(printDocument, printPageEventArgs);
        PageSettings pageSettings = printPageEventArgs.getPageSettings();
        PrinterSettings printerSettings = printDocument.getPrinterSettings();
        this.a = printerSettings.a(pageSettings);
        Size size = printPageEventArgs.getPageBounds().getSize();
        this.g.assignPageLandscape(pageSettings);
        float f2 = size.getWidth() - (printPageEventArgs.getPageSettings().getMargins().getLeft() + printPageEventArgs.getPageSettings().getMargins().getRight());
        float f3 = size.getHeight() - (printPageEventArgs.getPageSettings().getMargins().getBottom() + printPageEventArgs.getPageSettings().getMargins().getTop());
        int n2 = printPageEventArgs.getPageSettings().getPrinterResolution().getX();
        int n3 = printPageEventArgs.getPageSettings().getPrinterResolution().getY();
        Size size2 = new Size((int)(f2 * (float)n2 / 72.0f), (int)(f3 * (float)n3 / 72.0f));
        Image image = null;
        image = this.h ? new Metafile(size2.getWidth(), size2.getHeight(), true, null) : new Bitmap(size2.getWidth(), size2.getHeight());
        image.setResolution(n3, n2);
        PageFormat pageFormat = this.getPageFormat(this.f);
        this.b.addItem(new PrintBitmap(image, pageFormat));
        this.c = Graphics.__create_printing_graphics(image);
        this.c.setPageUnit(1);
        this.c.fillRectangle((Brush)new SolidBrush(Color.getWhite().Clone()), new Rectangle(new Point(0, 0), new Size(image.getWidth(), image.getHeight())));
        if (printDocument.getOriginAtMargins()) {
            this.c.translateTransform(printDocument.getDefaultPageSettings().getMargins().getLeft(), printDocument.getDefaultPageSettings().getMargins().getTop());
        }
        return this.c;
    }

    private PageFormat a() {
        PageFormat pageFormat = this.e.defaultPage();
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        Paper paper = pageFormat.getPaper();
        paper.setImageableArea(0.0, 0.0, pageFormat.getWidth(), pageFormat.getHeight());
        pageFormat2.setPaper(paper);
        PageFormat pageFormat3 = this.e.validatePage(pageFormat2);
        return pageFormat3;
    }

    public PageFormat getPageFormat(PrintRequestAttributeSet printRequestAttributeSet) {
        MediaSize mediaSize;
        Object object;
        PrintService printService = this.e.getPrintService();
        PageFormat pageFormat = this.e.defaultPage();
        if (printService == null || printRequestAttributeSet == null) {
            return pageFormat;
        }
        Media media = (Media)printRequestAttributeSet.get(Media.class);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
        if (media == null && mediaPrintableArea == null && orientationRequested == null) {
            return pageFormat;
        }
        Paper paper = pageFormat.getPaper();
        if (mediaPrintableArea == null && media != null && printService.isAttributeCategorySupported(MediaPrintableArea.class) && (object = printService.getSupportedAttributeValues(MediaPrintableArea.class, null, printRequestAttributeSet)) instanceof MediaPrintableArea[] && ((MediaPrintableArea[])object).length > 0) {
            mediaPrintableArea = ((MediaPrintableArea[])object)[0];
        }
        if (media != null && printService.isAttributeValueSupported(media, null, printRequestAttributeSet) && media instanceof MediaSizeName && (mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)(object = (MediaSizeName)media))) != null) {
            double d2 = 72.0;
            double d3 = (double)mediaSize.getX(25400) * d2;
            double d4 = (double)mediaSize.getY(25400) * d2;
            paper.setSize(d3, d4);
            paper.setImageableArea(5.0, 5.0, d3 - 10.0, d4 - 10.0);
        }
        if (mediaPrintableArea != null && printService.isAttributeValueSupported(mediaPrintableArea, null, printRequestAttributeSet)) {
            object = mediaPrintableArea.getPrintableArea(25400);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                object[i2] = object[i2] * 72.0f;
            }
            paper.setImageableArea((double)object[0], (double)object[1], (double)object[2], (double)object[3]);
        }
        if (orientationRequested != null && printService.isAttributeValueSupported(orientationRequested, null, printRequestAttributeSet)) {
            int n2 = orientationRequested.equals(OrientationRequested.REVERSE_LANDSCAPE) ? 2 : (orientationRequested.equals(OrientationRequested.LANDSCAPE) ? 0 : 1);
            pageFormat.setOrientation(n2);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    @Override
    public void onEndPage(PrintDocument printDocument, PrintPageEventArgs printPageEventArgs) {
        try {
            if (this.d) {
                throw new SystemException();
            }
        }
        finally {
            this.c.dispose();
            this.c = null;
        }
        super.onEndPage(printDocument, printPageEventArgs);
    }

    @Override
    public void onEndPrint(PrintDocument printDocument, PrintEventArgs printEventArgs) {
        if (printEventArgs.getCancel()) {
            return;
        }
        try {
            this.e.print(this.f);
        }
        catch (Exception exception) {
            this.d = true;
        }
        super.onEndPrint(printDocument, printEventArgs);
    }

    private void a(PrintRequestAttributeSet printRequestAttributeSet, PrintDocument printDocument) {
        printRequestAttributeSet.add(new JobName(printDocument.getDocumentName(), Locale.getDefault()));
    }

    private PrintService a(String string) {
        for (PrintService printService : PrintServiceLookup.lookupPrintServices(null, null)) {
            if (!printService.getName().equals(string)) continue;
            return printService;
        }
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    class PrintListener
    implements PrintJobListener {
        private PrintListener() {
        }

        @Override
        public void printDataTransferCompleted(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobCompleted(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobFailed(PrintJobEvent printJobEvent) {
            StandardPrintController.this.d = true;
        }

        @Override
        public void printJobCanceled(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobNoMoreEvents(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobRequiresAttention(PrintJobEvent printJobEvent) {
            StandardPrintController.this.d = true;
        }
    }

    public class MultiPagePrintDocument
    implements Pageable,
    Printable {
        @Override
        public int print(java.awt.Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
            if (n2 >= StandardPrintController.this.b.size()) {
                return 1;
            }
            graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            Image image = ((PrintBitmap)StandardPrintController.this.b.get_Item(n2)).a();
            this.a((Graphics2D)graphics);
            double d2 = Math.max(pageFormat.getHeight() / (double)image.getHeight(), pageFormat.getWidth() / (double)image.getWidth()) * 96.0 / 72.0;
            ((Graphics2D)graphics).scale(d2, d2);
            if (image instanceof Metafile) {
                ((Metafile)image).getInternalMetafile().c((Graphics2D)graphics);
            } else {
                BufferedImage bufferedImage = this.a((Bitmap)image, pageFormat);
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
            return 0;
        }

        private void a(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }

        private BufferedImage a(Bitmap bitmap, PageFormat pageFormat) {
            BufferedImage bufferedImage = bitmap.getNativeObject_Bitmap_New();
            return bufferedImage;
        }

        @Override
        public int getNumberOfPages() {
            return StandardPrintController.this.b.size();
        }

        @Override
        public PageFormat getPageFormat(int n2) throws IndexOutOfBoundsException {
            return ((PrintBitmap)StandardPrintController.this.b.get_Item(n2)).b();
        }

        @Override
        public Printable getPrintable(int n2) throws IndexOutOfBoundsException {
            return this;
        }
    }

    class PrintBitmap {
        private Image b;
        private PageFormat c;

        public PrintBitmap(Image image, PageFormat pageFormat) {
            this.b = image;
            this.c = pageFormat;
        }

        public Image a() {
            return this.b;
        }

        public PageFormat b() {
            return this.c;
        }
    }
}

