/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.acs;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.BitConverter;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.DivideByZeroException;
import com.aspose.html.utils.ms.System.DoubleExtensions;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.utils.ms.System.IConvertible;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.System.IFormattable;
import com.aspose.html.utils.ms.System.InvalidCastException;
import com.aspose.html.utils.ms.System.MidpointRounding;
import com.aspose.html.utils.ms.System.OverflowException;
import com.aspose.html.utils.ms.System.SingleExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Type;
import com.aspose.html.utils.ms.System.msArray;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.ByteArrayUtil;
import com.aspose.html.utils.ms.core.System.l;
import com.aspose.html.utils.ms.lang.Struct;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Decimal
extends Struct<Decimal>
implements IConvertible,
IFormattable,
Comparable<Decimal> {
    public static final Decimal MinValue = new Decimal("-79228162514264337593543950335");
    public static final Decimal MaxValue = new Decimal("79228162514264337593543950335");
    public static final Decimal MinusOne = Decimal.newDecimalFromInt(-1);
    public static final Decimal One = Decimal.newDecimalFromInt(1);
    public static final Decimal Zero = Decimal.newDecimalFromInt(0);
    private static Decimal a = Decimal.op_Division(MaxValue, Decimal.newDecimalFromInt(10));
    private static final int b = 28;
    private static final int c = 29;
    private static final int d = Integer.MIN_VALUE;
    private static final int e = 16;
    private static final long f = 0x7F00FFFFL;
    private static final int g = 7;
    private static final int h = 15;
    private static final int i = 3;
    private static final int j = 3;
    private static final int k = 5;
    private static final int l = 5;
    private static final int m = 10;
    private static final int n = 10;
    private static final int o = 19;
    private static final int p = 20;
    private BigDecimal q;

    public Decimal() {
        this.q = BigDecimal.ZERO;
    }

    public Decimal(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(Decimal.MaxValue.q) > 0 || bigDecimal.compareTo(Decimal.MinValue.q) < 0) {
            throw new OverflowException();
        }
        this.q = bigDecimal;
    }

    public Decimal(String string) {
        this.q = new BigDecimal(string);
    }

    public static Decimal newDecimalFromInt(int n2) {
        BigDecimal bigDecimal = new BigDecimal(n2);
        if (bigDecimal.scale() > 10) {
            bigDecimal = bigDecimal.setScale(10, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static Decimal newDecimalFromUInt(long l2) {
        long l3 = l2 & 0xFFFFFFFFFFFFFFFFL;
        BigDecimal bigDecimal = new BigDecimal(l3);
        if (bigDecimal.scale() > 10) {
            bigDecimal = bigDecimal.setScale(10, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static Decimal newDecimalFromLong(long l2) {
        BigDecimal bigDecimal = new BigDecimal(l2);
        if (bigDecimal.scale() > 19) {
            bigDecimal = bigDecimal.setScale(19, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static Decimal newDecimalFromULong(long l2) {
        long l3 = l2 & 0xFFFFFFFFFFFFFFFFL;
        BigDecimal bigDecimal = new BigDecimal(l3);
        if (bigDecimal.scale() > 20) {
            bigDecimal = bigDecimal.setScale(20, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static Decimal newDecimalFromFloat(float f2) {
        if (f2 >= Float.MAX_VALUE || f2 < -3.4028235E38f || Float.isNaN(f2) || SingleExtensions.isNegativeInfinity(f2) || SingleExtensions.isPositiveInfinity(f2)) {
            throw new OverflowException(StringExtensions.format("Value {0} is greater than Decimal.MaxValue or less than Decimal.MinValue", Float.valueOf(f2)));
        }
        BigDecimal bigDecimal = new BigDecimal(f2);
        if (bigDecimal.scale() > Decimal.a(bigDecimal)) {
            if (Decimal.a(bigDecimal) > 29 && (bigDecimal = bigDecimal.setScale(7 - (Decimal.a(bigDecimal) - bigDecimal.scale()), 4)).scale() > 28) {
                bigDecimal = bigDecimal.setScale(28, 4);
            }
        } else if (Decimal.a(bigDecimal) > 7) {
            bigDecimal = bigDecimal.setScale(7 - (Decimal.a(bigDecimal) - bigDecimal.scale()), 4);
        }
        return Decimal.adjustScale(new Decimal(bigDecimal));
    }

    public static Decimal newDecimalFromDouble(double d2) {
        if (Double.isNaN(d2) || DoubleExtensions.isNegativeInfinity(d2) || DoubleExtensions.isPositiveInfinity(d2) || d2 > Double.MAX_VALUE || d2 < -1.7976931348623157E308) {
            throw new OverflowException(StringExtensions.format("Value {0} is greater than Decimal.MaxValue or less than Decimal.MinValue", d2));
        }
        BigDecimal bigDecimal = new BigDecimal(d2);
        if (bigDecimal.scale() > Decimal.a(bigDecimal)) {
            if (Decimal.a(bigDecimal) > 29 && (bigDecimal = bigDecimal.setScale(15 - (Decimal.a(bigDecimal) - bigDecimal.scale()), 4)).scale() > 28) {
                bigDecimal = bigDecimal.setScale(28, 4);
            }
        } else if (Decimal.a(bigDecimal) > 15) {
            bigDecimal = bigDecimal.setScale(15 - (Decimal.a(bigDecimal) - bigDecimal.scale()), 4);
        }
        if (bigDecimal.compareTo(Decimal.MaxValue.q) > 0 || bigDecimal.compareTo(Decimal.MinValue.q) < 0) {
            throw new OverflowException();
        }
        return Decimal.adjustScale(new Decimal(bigDecimal));
    }

    private static int a(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        boolean bl2 = bigInteger.signum() == -1;
        int n2 = bigInteger.toString().length();
        if (bl2) {
            --n2;
        }
        return n2;
    }

    public Decimal(int[] nArray) {
        BigDecimal bigDecimal;
        if (nArray == null) {
            throw new ArgumentNullException("Bits is a null reference");
        }
        if (msArray.getLength(nArray, 0) != 4) {
            throw new ArgumentException("bits does not contain four values");
        }
        byte[] byArray = new byte[12];
        byte[] byArray2 = BitConverter.getBytesInt32(nArray[3]);
        int n2 = byArray2[3] >>> 31;
        byte by2 = byArray2[2];
        if (by2 > 28 || ((long)nArray[3] & 0x7F00FFFFL) != 0L) {
            throw new ArgumentException("Invalid bits[3]");
        }
        byte[] byArray3 = BitConverter.getBytesInt32(nArray[0]);
        byte[] byArray4 = BitConverter.getBytesInt32(nArray[1]);
        byte[] byArray5 = BitConverter.getBytesInt32(nArray[2]);
        byArray[11] = byArray3[0];
        byArray[10] = byArray3[1];
        byArray[9] = byArray3[2];
        byArray[8] = byArray3[3];
        byArray[7] = byArray4[0];
        byArray[6] = byArray4[1];
        byArray[5] = byArray4[2];
        byArray[4] = byArray4[3];
        byArray[3] = byArray5[0];
        byArray[2] = byArray5[1];
        byArray[1] = byArray5[2];
        byArray[0] = byArray5[3];
        BigInteger bigInteger = new BigInteger(n2 == 0 ? 1 : -1, byArray);
        this.q = bigDecimal = new BigDecimal(bigInteger, by2);
    }

    public static Decimal fromOACurrency(long l2) {
        return Decimal.op_Division(Decimal.newDecimalFromLong(l2), Decimal.newDecimalFromInt(10000));
    }

    public static int[] getBits(Decimal decimal) {
        BigDecimal bigDecimal;
        int[] nArray = new int[4];
        int n2 = 0;
        Decimal decimal2 = decimal;
        boolean bl2 = false;
        if (Decimal.op_LessThan(decimal, Zero)) {
            decimal2 = Decimal.negate(decimal);
            bl2 = true;
        }
        if ((n2 = (bigDecimal = decimal2.q).scale()) < 0) {
            bigDecimal = bigDecimal.setScale(0);
            n2 = 0;
        }
        byte[] byArray = bigDecimal.unscaledValue().toByteArray();
        byte[] byArray2 = new byte[12];
        int n3 = byArray.length - 1;
        for (int i2 = byArray2.length - 1; i2 >= 0; --i2) {
            byArray2[i2] = byArray[n3--];
            if (n3 < 0) break;
        }
        byte[] byArray3 = new byte[4];
        if (n2 > 0) {
            byArray3[1] = (byte)n2;
        }
        if (bl2) {
            byArray3[0] = -128;
        }
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[4];
        byArray4[3] = byArray2[11];
        byArray4[2] = byArray2[10];
        byArray4[1] = byArray2[9];
        byArray4[0] = byArray2[8];
        byArray5[3] = byArray2[7];
        byArray5[2] = byArray2[6];
        byArray5[1] = byArray2[5];
        byArray5[0] = byArray2[4];
        byArray6[3] = byArray2[3];
        byArray6[2] = byArray2[2];
        byArray6[1] = byArray2[1];
        byArray6[0] = byArray2[0];
        nArray[0] = ByteArrayUtil.getInt(byArray4, 0, false);
        nArray[1] = ByteArrayUtil.getInt(byArray5, 0, false);
        nArray[2] = ByteArrayUtil.getInt(byArray6, 0, false);
        nArray[3] = ByteArrayUtil.getInt(byArray3, 0, false);
        return nArray;
    }

    public static Decimal adjustScale(Decimal decimal) {
        BigDecimal bigDecimal = decimal.q;
        String string = bigDecimal.toPlainString();
        String string2 = CultureInfo.getCurrentCulture().getNumberFormat().getNumberDecimalSeparator();
        while (string.endsWith("0") && string.indexOf(string2) != -1) {
            bigDecimal = bigDecimal.setScale(bigDecimal.scale() - 1);
            string = bigDecimal.toPlainString();
        }
        return new Decimal(bigDecimal);
    }

    public boolean isZero() {
        return this.equals(Zero);
    }

    public static Decimal negate(Decimal decimal) {
        return new Decimal(decimal.q.negate());
    }

    public static Decimal add(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return null;
        }
        return Decimal.fromJava(decimal.q.add(decimal2.q));
    }

    public static Decimal subtract(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return null;
        }
        return Decimal.fromJava(decimal.q.subtract(decimal2.q));
    }

    public int hashCode() {
        return this.q.hashCode();
    }

    public static Decimal op_Addition(Decimal decimal, Decimal decimal2) {
        return Decimal.add(decimal, decimal2);
    }

    public static Decimal op_Decrement(Decimal decimal) {
        return Decimal.add(decimal, MinusOne);
    }

    public static Decimal op_Increment(Decimal decimal) {
        return Decimal.add(decimal, One);
    }

    public static Decimal op_Subtraction(Decimal decimal, Decimal decimal2) {
        return Decimal.subtract(decimal, decimal2);
    }

    public static Decimal op_UnaryNegation(Decimal decimal) {
        return Decimal.negate(decimal);
    }

    public static Decimal op_UnaryPlus(Decimal decimal) {
        return decimal;
    }

    public static Decimal abs(Decimal decimal) {
        return new Decimal(decimal.q.abs());
    }

    public static Decimal op_Multiply(Decimal decimal, Decimal decimal2) {
        return Decimal.multiply(decimal, decimal2);
    }

    public static Decimal op_Division(Decimal decimal, Decimal decimal2) {
        return Decimal.divide(decimal, decimal2);
    }

    public static Decimal op_Modulus(Decimal decimal, Decimal decimal2) {
        return Decimal.remainder(decimal, decimal2);
    }

    private static long a(Decimal decimal) {
        return decimal.q.longValue();
    }

    private static long b(Decimal decimal) {
        return decimal.q.longValue();
    }

    public static short to_ByteFromDecimal(Decimal decimal) {
        long l2 = Decimal.a(decimal);
        return (short)(l2 & 0xFFL);
    }

    public static byte to_SByteFromDecimal(Decimal decimal) {
        long l2 = Decimal.b(decimal);
        return (byte)l2;
    }

    public static char to_CharFromDecimal(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromInt(65535)) || Decimal.op_LessThan(decimal, Decimal.newDecimalFromLong(0L))) {
            throw new OverflowException("Value was either too large or too small for an Char.");
        }
        long l2 = Decimal.a(decimal);
        return (char)l2;
    }

    public static short to_ShortFromDecimal(Decimal decimal) {
        long l2 = Decimal.b(decimal);
        return (short)l2;
    }

    public static int to_UShortFromDecimal(Decimal decimal) {
        long l2 = Decimal.a(decimal);
        return (int)(l2 & 0xFFFFL);
    }

    public static int to_IntFromDecimal(Decimal decimal) {
        long l2 = Decimal.b(decimal);
        return (int)l2;
    }

    public static long to_UIntFromDecimal(Decimal decimal) {
        long l2 = Decimal.a(decimal);
        return l2 & 0xFFFFFFFFFFFFFFFFL;
    }

    public static long to_LongFromDecimal(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromLong(Long.MAX_VALUE))) {
            throw new OverflowException("Value was either too large or too small for an Int64.");
        }
        if (Decimal.op_LessThan(decimal, Decimal.newDecimalFromLong(Long.MIN_VALUE))) {
            throw new OverflowException("Value was either too large or too small for an Int64.");
        }
        return Decimal.b(decimal);
    }

    public static long to_ULongFromDecimal(Decimal decimal) {
        return Decimal.a(decimal) & 0xFFFFFFFFFFFFFFFFL;
    }

    public static float to_FloatFromDecimal(Decimal decimal) {
        return decimal.q.floatValue();
    }

    public static double to_DoubleFromDecimal(Decimal decimal) {
        return decimal.q.doubleValue();
    }

    public static Decimal to_DecimalFromByte(byte by2) {
        return Decimal.newDecimalFromInt(by2 & 0xFF);
    }

    public static Decimal to_DecimalFromSByte(byte by2) {
        return Decimal.newDecimalFromInt(by2);
    }

    public static Decimal to_DecimalFromShort(short s2) {
        return Decimal.newDecimalFromInt(s2);
    }

    public static Decimal to_DecimalFromUShort(int n2) {
        return Decimal.newDecimalFromInt(n2 & 0xFFFF);
    }

    public static Decimal to_DecimalFromChar(char c2) {
        return Decimal.newDecimalFromInt(c2);
    }

    public static Decimal to_DecimalFromInt(int n2) {
        return Decimal.newDecimalFromInt(n2);
    }

    public static Decimal to_DecimalFromUInt(long l2) {
        return Decimal.newDecimalFromUInt(l2);
    }

    public static Decimal to_DecimalFromLong(long l2) {
        return Decimal.newDecimalFromLong(l2);
    }

    public static Decimal to_DecimalFromULong(long l2) {
        return Decimal.newDecimalFromULong(l2);
    }

    public static Decimal to_DecimalFromFloat(float f2) {
        return Decimal.newDecimalFromFloat(f2);
    }

    public static Decimal to_DecimalFromDouble(double d2) {
        return Decimal.newDecimalFromDouble(d2);
    }

    public static boolean op_Inequality(Decimal decimal, Decimal decimal2) {
        return !Decimal.op_Equality(decimal, decimal2);
    }

    public static boolean op_Equality(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return false;
        }
        return Decimal.equals(decimal, decimal2);
    }

    public static boolean op_GreaterThan(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return false;
        }
        return Decimal.compare(decimal, decimal2) > 0;
    }

    public static boolean op_GreaterThanOrEqual(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return false;
        }
        return Decimal.compare(decimal, decimal2) >= 0;
    }

    public static boolean op_LessThan(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return false;
        }
        return Decimal.compare(decimal, decimal2) < 0;
    }

    public static boolean op_LessThanOrEqual(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return false;
        }
        return Decimal.compare(decimal, decimal2) <= 0;
    }

    public static boolean equals(Decimal decimal, Decimal decimal2) {
        return Decimal.compare(decimal, decimal2) == 0 || Decimal.a(decimal, decimal2);
    }

    private static boolean a(Decimal decimal, Decimal decimal2) {
        int[] nArray;
        int[] nArray2 = Decimal.getBits(decimal);
        return nArray2[0] == (nArray = Decimal.getBits(decimal2))[0] && nArray2[1] == nArray[1] && nArray2[2] == nArray[2] && nArray2[3] == nArray[3];
    }

    public boolean equals(Object object) {
        if (!(object instanceof Decimal)) {
            if (object instanceof Integer) {
                return this.equals(Decimal.newDecimalFromInt(Convert.toInt32(object)));
            }
            if (object instanceof Long) {
                return this.equals(Decimal.newDecimalFromLong(Convert.toInt64(object)));
            }
            if (object instanceof Double) {
                return this.equals(Decimal.newDecimalFromDouble(Convert.toDouble(object)));
            }
            return false;
        }
        return Decimal.equals((Decimal)object, this);
    }

    public static Decimal floor(Decimal decimal) {
        return new Decimal(decimal.q.divide(BigDecimal.valueOf(1L), 0, 3));
    }

    public static Decimal truncate(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Zero)) {
            return Decimal.floor(decimal);
        }
        return Decimal.negate(Decimal.floor(Decimal.negate(decimal)));
    }

    public static Decimal round(Decimal decimal, int n2, short s2) {
        boolean bl2;
        if (s2 != 0 && s2 != 1) {
            throw new ArgumentException(StringExtensions.concat("The value '", Enum.getName(MidpointRounding.class, s2), "' is not valid for this usage of the type MidpointRounding."), "mode");
        }
        if (n2 < 0 || n2 > 28) {
            throw new ArgumentOutOfRangeException("decimals", "[0,28]");
        }
        boolean bl3 = bl2 = decimal.q.signum() < 0;
        if (bl2) {
            decimal = Decimal.negate(decimal);
        }
        Decimal decimal2 = Decimal.newDecimalFromDouble(msMath.pow(10.0, n2));
        Decimal decimal3 = Decimal.floor(decimal);
        Decimal decimal4 = Decimal.op_Subtraction(decimal, decimal3);
        decimal4 = Decimal.multiply(decimal4, new Decimal("10000000000000000000000000000"));
        decimal4 = Decimal.floor(decimal4);
        decimal4 = Decimal.divide(decimal4, Decimal.op_Division(new Decimal("10000000000000000000000000000"), decimal2));
        decimal4 = msMath.round(decimal4, s2);
        decimal4 = Decimal.divide(decimal4, decimal2);
        Decimal decimal5 = Decimal.op_Addition(decimal3, decimal4);
        int n3 = s2 == 1 ? 4 : 6;
        decimal5.q = decimal5.q.setScale(n2, n3);
        if (bl2) {
            decimal5 = Decimal.negate(decimal5);
        }
        return decimal5;
    }

    public static Decimal round(Decimal decimal) {
        return msMath.round(decimal);
    }

    public static Decimal roundWithMode(Decimal decimal, short s2) {
        return msMath.round(decimal, s2);
    }

    public static Decimal round(Decimal decimal, int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("decimals");
        }
        if (n2 > 28) {
            throw new ArgumentOutOfRangeException("decimals");
        }
        return new Decimal(decimal.q.divide(BigDecimal.valueOf(1L), n2, 6));
    }

    public static Decimal multiply(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return null;
        }
        if (decimal.isZero() || decimal2.isZero()) {
            return Zero;
        }
        BigDecimal bigDecimal = decimal.q.multiply(decimal2.q);
        if ((bigDecimal = bigDecimal.stripTrailingZeros()).scale() < 0) {
            bigDecimal = bigDecimal.setScale(0, 4);
        }
        return Decimal.fromJava(bigDecimal);
    }

    public static Decimal divide(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return null;
        }
        if (decimal2.isZero()) {
            throw new DivideByZeroException();
        }
        if (decimal.isZero()) {
            return Zero;
        }
        BigDecimal bigDecimal = decimal.q.divide(decimal2.q, 28, 4);
        if ((bigDecimal = bigDecimal.stripTrailingZeros()).scale() < 0) {
            bigDecimal = bigDecimal.setScale(0, 4);
        }
        return Decimal.fromJava(bigDecimal);
    }

    public static Decimal remainder(Decimal decimal, Decimal decimal2) {
        if (decimal == null || decimal2 == null) {
            return null;
        }
        if (decimal2.isZero()) {
            throw new DivideByZeroException();
        }
        if (decimal.isZero()) {
            return Zero;
        }
        return Decimal.fromJava(decimal.q.remainder(decimal2.q));
    }

    public static int compare(Decimal decimal, Decimal decimal2) {
        return decimal.q.compareTo(decimal2.q);
    }

    @Override
    public int compareTo(Decimal decimal) {
        return Decimal.compare(this, decimal);
    }

    public boolean equals(Decimal decimal) {
        return Decimal.equals(decimal, this);
    }

    public static Decimal ceiling(Decimal decimal) {
        return msMath.ceiling(decimal);
    }

    public static Decimal parse(String string) {
        return Decimal.parse(string, 111, null);
    }

    public static Decimal parse(String string, int n2) {
        return Decimal.parse(string, n2, null);
    }

    public static Decimal parse(String string, IFormatProvider iFormatProvider) {
        return Decimal.parse(string, 111, iFormatProvider);
    }

    public static Decimal parse(String string, int n2, IFormatProvider iFormatProvider) {
        if (string == null) {
            throw new ArgumentNullException("s");
        }
        if ((n2 & 0x200) != 0) {
            throw new ArgumentException("Decimal.TryParse does not accept AllowHexSpecifier", "style");
        }
        Decimal decimal = null;
        Decimal[] decimalArray = new Decimal[]{decimal};
        Decimal.a(string, n2, iFormatProvider, decimalArray, true);
        decimal = decimalArray[0];
        return decimal;
    }

    public static boolean tryParse(String string, Decimal[] decimalArray) {
        if (string == null) {
            decimalArray[0] = Zero;
            return false;
        }
        try {
            return Decimal.a(string, 111, null, decimalArray, false);
        }
        catch (Exception exception) {
            decimalArray[0] = Zero;
            return false;
        }
    }

    public static boolean tryParse(String string, int n2, IFormatProvider iFormatProvider, Decimal[] decimalArray) {
        if (string == null || (n2 & 0x200) != 0) {
            decimalArray[0] = Zero;
            return false;
        }
        try {
            return Decimal.a(string, n2, iFormatProvider, decimalArray, false);
        }
        catch (Exception exception) {
            decimalArray[0] = Zero;
            return false;
        }
    }

    static boolean a(String string, int n2, IFormatProvider iFormatProvider, Decimal[] decimalArray, boolean bl2) {
        NumberFormatInfo numberFormatInfo = iFormatProvider == null ? NumberFormatInfo.getInvariantInfo() : NumberFormatInfo.getInstance(iFormatProvider);
        if (StringExtensions.contains(string, "\u0000")) {
            string = StringExtensions.replace(string, "\u0000", "");
        }
        string = StringExtensions.trim(string);
        switch (n2) {
            case 111: {
                if (string.startsWith("(") && string.endsWith(")")) {
                    string = StringExtensions.substring(string, 1, string.length() - 2);
                    string = StringExtensions.trim(string);
                    string = numberFormatInfo.getNegativeSign() + string;
                }
                if (StringExtensions.indexOf(string, numberFormatInfo.getNumberGroupSeparator()) == -1 || numberFormatInfo.getNumberGroupSeparator().equals(numberFormatInfo.getNumberDecimalSeparator())) break;
                string = StringExtensions.replace(string, numberFormatInfo.getNumberGroupSeparator(), "");
                break;
            }
            case 7: 
            case 167: {
                if (StringExtensions.indexOf(string, numberFormatInfo.getNumberGroupSeparator()) == -1) break;
                string = StringExtensions.replace(string, numberFormatInfo.getNumberGroupSeparator(), "");
                break;
            }
            case 383: {
                if (StringExtensions.indexOf(string, numberFormatInfo.getCurrencySymbol()) != -1) {
                    string = StringExtensions.replace(string, numberFormatInfo.getCurrencySymbol(), "");
                    string = StringExtensions.trim(string);
                }
                if (string.startsWith("(") && string.endsWith(")")) {
                    string = StringExtensions.substring(string, 1, string.length() - 2);
                    string = StringExtensions.trim(string);
                    string = numberFormatInfo.getNegativeSign() + string;
                }
                if (StringExtensions.indexOf(string, numberFormatInfo.getNumberGroupSeparator()) == -1) break;
                string = StringExtensions.replace(string, numberFormatInfo.getNumberGroupSeparator(), "");
                break;
            }
        }
        try {
            BigDecimal bigDecimal;
            if ((n2 & 0x20) == 0) {
                String string2 = null;
                string2 = (n2 & 0x100) != 0 ? numberFormatInfo.getCurrencyDecimalSeparator() : numberFormatInfo.getNumberDecimalSeparator();
                if (StringExtensions.contains(string, string2)) {
                    throw new FormatException();
                }
            } else {
                String string3 = null;
                string3 = (n2 & 0x100) != 0 ? numberFormatInfo.getCurrencyDecimalSeparator() : numberFormatInfo.getNumberDecimalSeparator();
                if (StringExtensions.indexOf(string, string3) != -1) {
                    string = StringExtensions.replace(string, string3, ".");
                }
            }
            if ((bigDecimal = new BigDecimal(string)).compareTo(Decimal.MaxValue.q) > 0 || bigDecimal.compareTo(Decimal.MinValue.q) < 0) {
                throw new OverflowException();
            }
            decimalArray[0] = Decimal.fromJava(bigDecimal);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException(numberFormatException.getMessage());
        }
        return true;
    }

    @Override
    public int getTypeCode() {
        return 15;
    }

    public static byte toByte(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromInt(255)) || Decimal.op_LessThan(decimal, Zero)) {
            throw new OverflowException("Value is greater than Byte.MaxValue or less than Byte.MinValue");
        }
        return (byte)(Decimal.truncate((Decimal)decimal).q.byteValue() & 0xFF);
    }

    public static byte toSByte(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromInt(127)) || Decimal.op_LessThan(decimal, Decimal.newDecimalFromInt(-128))) {
            throw new OverflowException("Value is greater than Byte.MaxValue or less than Byte.MinValue");
        }
        return Decimal.truncate((Decimal)decimal).q.byteValue();
    }

    public static double toDouble(Decimal decimal) {
        return decimal.q.doubleValue();
    }

    public static short toInt16(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromInt(Short.MAX_VALUE)) || Decimal.op_LessThan(decimal, Decimal.newDecimalFromInt(Short.MIN_VALUE))) {
            throw new OverflowException("Value is greater than Int16.MaxValue or less than Int16.MinValue");
        }
        return Decimal.truncate((Decimal)decimal).q.shortValue();
    }

    public static int toUInt16(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromInt(65535)) || Decimal.op_LessThan(decimal, Decimal.newDecimalFromInt(0))) {
            throw new OverflowException("Value is greater than UInt16.MaxValue or less than UInt16.MinValue");
        }
        return Decimal.truncate((Decimal)decimal).q.shortValue() & 0xFFFF;
    }

    public static int toInt32(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromInt(Integer.MAX_VALUE)) || Decimal.op_LessThan(decimal, Decimal.newDecimalFromInt(Integer.MIN_VALUE))) {
            throw new OverflowException("Value is greater than Int32.MaxValue or less than Int32.MinValue");
        }
        return Decimal.truncate((Decimal)decimal).q.intValue();
    }

    public static long toUInt32(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromUInt(0xFFFFFFFFL)) || Decimal.op_LessThan(decimal, Decimal.newDecimalFromUInt(0L))) {
            throw new OverflowException("Value is greater than Int32.MaxValue or less than Int32.MinValue");
        }
        return (long)Decimal.truncate((Decimal)decimal).q.intValue() & 0xFFFFFFFFL;
    }

    public static long toInt64(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromLong(Long.MAX_VALUE)) || Decimal.op_LessThan(decimal, Decimal.newDecimalFromLong(Long.MIN_VALUE))) {
            throw new OverflowException("Value is greater than Int64.MaxValue or less than Int64.MinValue");
        }
        return Decimal.truncate((Decimal)decimal).q.longValue();
    }

    public static long toUInt64(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, new Decimal("18446744073709551615")) || Decimal.op_LessThan(decimal, Decimal.newDecimalFromULong(0L))) {
            throw new OverflowException("Value is greater than UInt64.MaxValue or less than UInt64.MinValue");
        }
        return Decimal.truncate((Decimal)decimal).q.longValue();
    }

    public static long toOACurrency(Decimal decimal) {
        return Decimal.op_Multiply((Decimal)decimal, (Decimal)Decimal.newDecimalFromInt((int)10000)).q.longValue();
    }

    public static float toSingle(Decimal decimal) {
        return Convert.toSingle(decimal);
    }

    @Override
    public Object toType(Type type, IFormatProvider iFormatProvider) {
        if (type == null) {
            throw new ArgumentNullException("targetType");
        }
        throw new NotImplementedException();
    }

    @Override
    public boolean toBoolean(IFormatProvider iFormatProvider) {
        return Convert.toBoolean(this);
    }

    @Override
    public byte toByte(IFormatProvider iFormatProvider) {
        return Convert.toByte(this);
    }

    @Override
    public char toChar(IFormatProvider iFormatProvider) {
        throw new InvalidCastException();
    }

    @Override
    public acs toDateTime(IFormatProvider iFormatProvider) {
        throw new InvalidCastException();
    }

    @Override
    public Decimal toDecimal(IFormatProvider iFormatProvider) {
        return this;
    }

    public BigDecimal toBigDecimal(IFormatProvider iFormatProvider) {
        return this.q.multiply(BigDecimal.ONE);
    }

    @Override
    public double toDouble(IFormatProvider iFormatProvider) {
        return Convert.toDouble(this);
    }

    @Override
    public short toInt16(IFormatProvider iFormatProvider) {
        return Convert.toInt16(this);
    }

    @Override
    public int toInt32(IFormatProvider iFormatProvider) {
        return Convert.toInt32(this);
    }

    @Override
    public long toInt64(IFormatProvider iFormatProvider) {
        return Convert.toInt64(this);
    }

    @Override
    public byte toSByte(IFormatProvider iFormatProvider) {
        return Convert.toSByte(this);
    }

    @Override
    public float toSingle(IFormatProvider iFormatProvider) {
        return Convert.toSingle(this);
    }

    @Override
    public int toUInt16(IFormatProvider iFormatProvider) {
        return Convert.toUInt16(this);
    }

    @Override
    public long toUInt32(IFormatProvider iFormatProvider) {
        return Convert.toUInt32(this);
    }

    @Override
    public long toUInt64(IFormatProvider iFormatProvider) {
        return Convert.toUInt64(this);
    }

    @Override
    public String toString(String string, IFormatProvider iFormatProvider) {
        return com.aspose.html.utils.ms.core.System.l.a(string, this, iFormatProvider);
    }

    public String toString() {
        return this.toString("G", null);
    }

    public String toString(String string) {
        return this.toString(string, null);
    }

    @Override
    public String toString(IFormatProvider iFormatProvider) {
        return this.toString("G", iFormatProvider);
    }

    @Override
    public void CloneTo(Decimal decimal) {
        decimal.q = this.q;
    }

    @Override
    public Decimal Clone() {
        Decimal decimal = new Decimal();
        this.CloneTo(decimal);
        return decimal;
    }

    public Object clone() {
        return this.Clone();
    }

    public static Decimal fromJava(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return new Decimal();
        }
        int n2 = Decimal.a(bigDecimal);
        int n3 = bigDecimal.scale();
        if (n2 > 0 && n2 != n3 && n2 > 29 && n3 >= n2 - 29) {
            bigDecimal = bigDecimal.setScale(29 - (n2 - n3), 4);
        } else if (n3 > 28) {
            bigDecimal = bigDecimal.setScale(28, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static BigDecimal toJava(Decimal decimal) {
        if (decimal == null) {
            return null;
        }
        return decimal.q;
    }
}

