/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aBH;
import com.aspose.html.utils.aBI;
import com.aspose.html.utils.aBK;
import com.aspose.html.utils.aBN;
import com.aspose.html.utils.aBO;
import com.aspose.html.utils.aBd;
import com.aspose.html.utils.aBn;
import com.aspose.html.utils.aBw;
import com.aspose.html.utils.aCo;
import com.aspose.html.utils.aUT;
import com.aspose.html.utils.aUt;
import com.aspose.html.utils.aUu;
import com.aspose.html.utils.aUv;
import com.aspose.html.utils.aUw;
import com.aspose.html.utils.aUy;
import com.aspose.html.utils.aVS;
import com.aspose.html.utils.aVW;
import com.aspose.html.utils.aVn;
import com.aspose.html.utils.aXl;
import com.aspose.html.utils.aXr;
import com.aspose.html.utils.atB;
import com.aspose.html.utils.atE;
import com.aspose.html.utils.atF;
import com.aspose.html.utils.atH;
import com.aspose.html.utils.atJ;
import com.aspose.html.utils.atK;
import com.aspose.html.utils.ats;
import com.aspose.html.utils.atv;
import com.aspose.html.utils.aty;
import com.aspose.html.utils.azc;
import com.aspose.html.utils.bfG;
import com.aspose.html.utils.bfH;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class aVm {
    protected static final aVS luK = new aVS();
    protected static final String luL = "2.5.29.32.0";
    protected static final String luM = aBK.kaN.getId();
    protected static final int luN = 5;
    protected static final int luO = 6;
    protected static final String[] luP = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    aVm() {
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate x509Certificate, Set set) throws aUT {
        return aVm.findTrustAnchor(x509Certificate, set, null);
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate x509Certificate, Set set, String string) throws aUT {
        TrustAnchor trustAnchor = null;
        PublicKey publicKey = null;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        X500Principal x500Principal = aVm.getEncodedIssuerPrincipal(x509Certificate);
        try {
            x509CertSelector.setSubject(x500Principal.getEncoded());
        }
        catch (IOException iOException) {
            throw new aUT("Cannot set subject search criteria for trust anchor.", iOException);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && trustAnchor == null) {
            block15: {
                trustAnchor = (TrustAnchor)iterator.next();
                if (trustAnchor.getTrustedCert() != null) {
                    if (x509CertSelector.match(trustAnchor.getTrustedCert())) {
                        publicKey = trustAnchor.getTrustedCert().getPublicKey();
                    } else {
                        trustAnchor = null;
                    }
                } else if (trustAnchor.getCAName() != null && trustAnchor.getCAPublicKey() != null) {
                    try {
                        X500Principal x500Principal2 = new X500Principal(trustAnchor.getCAName());
                        if (x500Principal.equals(x500Principal2)) {
                            publicKey = trustAnchor.getCAPublicKey();
                            break block15;
                        }
                        trustAnchor = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        trustAnchor = null;
                    }
                } else {
                    trustAnchor = null;
                }
            }
            if (publicKey == null) continue;
            try {
                aVm.verifyX509Certificate(x509Certificate, publicKey, string);
            }
            catch (Exception exception2) {
                exception = exception2;
                trustAnchor = null;
                publicKey = null;
            }
        }
        if (trustAnchor == null && exception != null) {
            throw new aUT("TrustAnchor found but certificate validation failed.", exception);
        }
        return trustAnchor;
    }

    static List<aUv> getAdditionalStoresFromAltNames(byte[] byArray, Map<aBN, aUv> map) throws CertificateParsingException {
        if (byArray != null) {
            aBO aBO2 = aBO.hg(atF.bG(byArray).getOctets());
            aBN[] aBNArray = aBO2.bdh();
            ArrayList<aUv> arrayList = new ArrayList<aUv>();
            for (int i2 = 0; i2 != aBNArray.length; ++i2) {
                aBN aBN2 = aBNArray[i2];
                aUv aUv2 = map.get(aBN2);
                if (aUv2 == null) continue;
                arrayList.add(aUv2);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    protected static X500Principal getEncodedIssuerPrincipal(Object object) {
        return ((X509Certificate)object).getIssuerX500Principal();
    }

    protected static Date j(aUy aUy2) {
        Date date = aUy2.getDate();
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    protected static aBd i(X509Certificate x509Certificate) {
        return aBd.gE(x509Certificate.getSubjectX500Principal().getEncoded());
    }

    protected static X500Principal getSubjectPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal();
    }

    protected static boolean isSelfIssued(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    protected static atJ a(X509Extension x509Extension, String string) throws aUT {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        return aVm.d(string, byArray);
    }

    private static atJ d(String string, byte[] byArray) throws aUT {
        try {
            atF atF2 = atF.bG(byArray);
            return atJ.aP(atF2.getOctets());
        }
        catch (Exception exception) {
            throw new aUT("exception processing extension " + string, exception);
        }
    }

    protected static X500Principal getIssuerPrincipal(X509CRL x509CRL) {
        return x509CRL.getIssuerX500Principal();
    }

    protected static aBn g(PublicKey publicKey) throws CertPathValidatorException {
        try {
            aCo aCo2 = aCo.hA(publicKey.getEncoded());
            return aCo2.aXc();
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Subject public key cannot be decoded.", exception);
        }
    }

    protected static final Set i(atK atK2) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (atK2 == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        atH atH2 = new atH(byteArrayOutputStream);
        Enumeration enumeration = atK2.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                atH2.b((ats)enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("Policy qualifier info cannot be decoded.", iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    protected static aVW a(aVW aVW2, List[] listArray, aVW aVW3) {
        aVW aVW4 = (aVW)aVW3.getParent();
        if (aVW2 == null) {
            return null;
        }
        if (aVW4 == null) {
            for (int i2 = 0; i2 < listArray.length; ++i2) {
                listArray[i2] = new ArrayList();
            }
            return null;
        }
        aVW4.b(aVW3);
        aVm.a(listArray, aVW3);
        return aVW2;
    }

    private static void a(List[] listArray, aVW aVW2) {
        listArray[aVW2.getDepth()].remove(aVW2);
        if (aVW2.hasChildren()) {
            Iterator iterator = aVW2.getChildren();
            while (iterator.hasNext()) {
                aVW aVW3 = (aVW)iterator.next();
                aVm.a(listArray, aVW3);
            }
        }
    }

    protected static boolean a(int n2, List[] listArray, atE atE2, Set set) {
        List list = listArray[n2 - 1];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            aVW aVW2 = (aVW)list.get(i2);
            Set set2 = aVW2.getExpectedPolicies();
            if (!set2.contains(atE2.getId())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(atE2.getId());
            aVW aVW3 = new aVW(new ArrayList(), n2, hashSet, aVW2, set, atE2.getId(), false);
            aVW2.a(aVW3);
            listArray[n2].add(aVW3);
            list.set(i2, aVW2);
            return true;
        }
        return false;
    }

    protected static void b(int n2, List[] listArray, atE atE2, Set set) {
        List list = listArray[n2 - 1];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            aVW aVW2 = (aVW)list.get(i2);
            if (!luL.equals(aVW2.getValidPolicy())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(atE2.getId());
            aVW aVW3 = new aVW(new ArrayList(), n2, hashSet, aVW2, set, atE2.getId(), false);
            aVW2.a(aVW3);
            listArray[n2].add(aVW3);
            return;
        }
    }

    protected static boolean isAnyPolicy(Set set) {
        return set == null || set.contains(luL) || set.isEmpty();
    }

    protected static Collection a(aUw aUw2, List list) throws aUT {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        for (Object e2 : list) {
            Object object;
            if (e2 instanceof bfG) {
                object = (bfG)e2;
                try {
                    linkedHashSet.addAll(object.a(aUw2));
                    continue;
                }
                catch (bfH bfH2) {
                    throw new aUT("Problem while picking certificates from X.509 store.", bfH2);
                }
            }
            object = (CertStore)e2;
            try {
                linkedHashSet.addAll(aUw.a(aUw2, (CertStore)object));
            }
            catch (CertStoreException certStoreException) {
                throw new aUT("Problem while picking certificates from certificate store.", certStoreException);
            }
        }
        return linkedHashSet;
    }

    static List<aUt> a(aBw aBw2, Map<aBN, aUt> map) throws aUT {
        if (aBw2 != null) {
            aBH[] aBHArray = null;
            try {
                aBHArray = aBw2.bcJ();
            }
            catch (Exception exception) {
                throw new aUT("Distribution points could not be read.", exception);
            }
            ArrayList<aUt> arrayList = new ArrayList<aUt>();
            for (int i2 = 0; i2 < aBHArray.length; ++i2) {
                aBI aBI2 = aBHArray[i2].bcV();
                if (aBI2 == null || aBI2.getType() != 0) continue;
                aBN[] aBNArray = aBO.hg(aBI2.bcY()).bdh();
                for (int i3 = 0; i3 < aBNArray.length; ++i3) {
                    aUt aUt2 = map.get(aBNArray[i3]);
                    if (aUt2 == null) continue;
                    arrayList.add(aUt2);
                }
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    protected static void a(aBH aBH2, Collection collection, X509CRLSelector x509CRLSelector) throws aUT {
        Object object;
        ArrayList<X500Principal> arrayList = new ArrayList<X500Principal>();
        if (aBH2.bcX() != null) {
            object = aBH2.bcX().bdh();
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                if (((aBN)object[i2]).getTagNo() != 4) continue;
                try {
                    arrayList.add(new X500Principal(((aBN)object[i2]).bcY().aUc().getEncoded()));
                    continue;
                }
                catch (IOException iOException) {
                    throw new aUT("CRL issuer information from distribution point cannot be decoded.", iOException);
                }
            }
        } else {
            if (aBH2.bcV() == null) {
                throw new aUT("CRL issuer is omitted from distribution point but no distributionPoint field present.");
            }
            object = collection.iterator();
            while (object.hasNext()) {
                arrayList.add((X500Principal)object.next());
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                x509CRLSelector.addIssuerName(((X500Principal)object.next()).getEncoded());
            }
            catch (IOException iOException) {
                throw new aUT("Cannot decode CRL issuer information.", iOException);
            }
        }
    }

    private static BigInteger getSerialNumber(Object object) {
        return ((X509Certificate)object).getSerialNumber();
    }

    protected static void a(Date date, X509CRL x509CRL, Object object, aVn aVn2) throws aUT {
        Object object2;
        boolean bl2;
        X509CRLEntry x509CRLEntry = null;
        try {
            bl2 = aXr.isIndirectCRL(x509CRL);
        }
        catch (CRLException cRLException) {
            throw new aUT("Failed check for indirect CRL.", cRLException);
        }
        if (bl2) {
            x509CRLEntry = x509CRL.getRevokedCertificate(aVm.getSerialNumber(object));
            if (x509CRLEntry == null) {
                return;
            }
            object2 = x509CRLEntry.getCertificateIssuer();
            if (object2 == null) {
                object2 = aVm.getIssuerPrincipal(x509CRL);
            }
            if (!aVm.getEncodedIssuerPrincipal(object).equals(object2)) {
                return;
            }
        } else {
            if (!aVm.getEncodedIssuerPrincipal(object).equals(aVm.getIssuerPrincipal(x509CRL))) {
                return;
            }
            x509CRLEntry = x509CRL.getRevokedCertificate(aVm.getSerialNumber(object));
            if (x509CRLEntry == null) {
                return;
            }
        }
        object2 = null;
        if (x509CRLEntry.hasExtensions()) {
            try {
                object2 = atv.bB(aVm.a(x509CRLEntry, aBK.kaO.getId()));
            }
            catch (Exception exception) {
                throw new aUT("Reason code CRL entry extension could not be decoded.", exception);
            }
        }
        if (date.getTime() >= x509CRLEntry.getRevocationDate().getTime() || object2 == null || ((atv)object2).getValue().intValue() == 0 || ((atv)object2).getValue().intValue() == 1 || ((atv)object2).getValue().intValue() == 2 || ((atv)object2).getValue().intValue() == 8) {
            if (object2 != null) {
                aVn2.setCertStatus(((atv)object2).getValue().intValue());
            } else {
                aVn2.setCertStatus(0);
            }
            aVn2.setRevocationDate(x509CRLEntry.getRevocationDate());
        }
    }

    protected static Set getDeltaCRLs(Date date, X509CRL x509CRL, List<CertStore> list, List<aUt> list2) throws aUT {
        Object object;
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            x509CRLSelector.addIssuerName(aVm.getIssuerPrincipal(x509CRL).getEncoded());
        }
        catch (IOException iOException) {
            throw new aUT("Cannot extract issuer from CRL.", iOException);
        }
        BigInteger bigInteger = null;
        try {
            object = aVm.a(x509CRL, luM);
            if (object != null) {
                bigInteger = atB.bD(object).getPositiveValue();
            }
        }
        catch (Exception exception) {
            throw new aUT("CRL number extension could not be extracted from CRL.", exception);
        }
        object = null;
        try {
            object = x509CRL.getExtensionValue(aXl.lVC);
        }
        catch (Exception exception) {
            throw new aUT("Issuing distribution point extension value could not be read.", exception);
        }
        x509CRLSelector.setMinCRLNumber(bigInteger == null ? null : bigInteger.add(BigInteger.valueOf(1L)));
        aUu.a a2 = new aUu.a(x509CRLSelector);
        a2.setIssuingDistributionPoint((byte[])object);
        a2.setIssuingDistributionPointEnabled(true);
        a2.setMaxBaseCRLNumber(bigInteger);
        aUu<? extends CRL> aUu2 = a2.bma();
        Set set = luK.a(aUu2, date, list, list2);
        HashSet<X509CRL> hashSet = new HashSet<X509CRL>();
        for (X509CRL x509CRL2 : set) {
            if (!aVm.isDeltaCRL(x509CRL2)) continue;
            hashSet.add(x509CRL2);
        }
        return hashSet;
    }

    private static boolean isDeltaCRL(X509CRL x509CRL) {
        Set<String> set = x509CRL.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        return set.contains(aXl.lVE);
    }

    protected static Set a(aBH aBH2, Object object, Date date, aUy aUy2) throws aUT {
        Set set;
        Cloneable cloneable;
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            cloneable = new HashSet<X500Principal>();
            cloneable.add(aVm.getEncodedIssuerPrincipal(object));
            aVm.a(aBH2, cloneable, x509CRLSelector);
        }
        catch (aUT aUT2) {
            throw new aUT("Could not get issuer information from distribution point.", aUT2);
        }
        if (object instanceof X509Certificate) {
            x509CRLSelector.setCertificateChecking((X509Certificate)object);
        }
        cloneable = new aUu.a(x509CRLSelector).fd(true).bma();
        Date date2 = date;
        if (aUy2.getDate() != null) {
            date2 = aUy2.getDate();
        }
        if ((set = luK.a((aUu)cloneable, date2, aUy2.getCertStores(), aUy2.getCRLStores())).isEmpty()) {
            X509Certificate x509Certificate = (X509Certificate)object;
            throw new aUT("No CRLs found for issuer \"" + x509Certificate.getIssuerX500Principal() + "\"");
        }
        return set;
    }

    protected static Date a(aUy aUy2, CertPath certPath, int n2) throws aUT {
        if (aUy2.getValidityModel() == 1) {
            if (n2 <= 0) {
                return aVm.j(aUy2);
            }
            if (n2 - 1 == 0) {
                aty aty2 = null;
                try {
                    byte[] byArray = ((X509Certificate)certPath.getCertificates().get(n2 - 1)).getExtensionValue(azc.jJB.getId());
                    if (byArray != null) {
                        aty2 = aty.bC(atJ.aP(byArray));
                    }
                }
                catch (IOException iOException) {
                    throw new aUT("Date of cert gen extension could not be read.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new aUT("Date of cert gen extension could not be read.");
                }
                if (aty2 != null) {
                    try {
                        return aty2.getDate();
                    }
                    catch (ParseException parseException) {
                        throw new aUT("Date from date of cert gen extension could not be parsed.", parseException);
                    }
                }
                return ((X509Certificate)certPath.getCertificates().get(n2 - 1)).getNotBefore();
            }
            return ((X509Certificate)certPath.getCertificates().get(n2 - 1)).getNotBefore();
        }
        return aVm.j(aUy2);
    }

    protected static PublicKey getNextWorkingKey(List list, int n2, Provider provider) throws CertPathValidatorException {
        Certificate certificate = (Certificate)list.get(n2);
        PublicKey publicKey = certificate.getPublicKey();
        if (!(publicKey instanceof DSAPublicKey)) {
            return publicKey;
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        if (dSAPublicKey.getParams() != null) {
            return dSAPublicKey;
        }
        for (int i2 = n2 + 1; i2 < list.size(); ++i2) {
            X509Certificate x509Certificate = (X509Certificate)list.get(i2);
            publicKey = x509Certificate.getPublicKey();
            if (!(publicKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
            }
            DSAPublicKey dSAPublicKey2 = (DSAPublicKey)publicKey;
            if (dSAPublicKey2.getParams() == null) continue;
            DSAParams dSAParams = dSAPublicKey2.getParams();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA", provider);
                return keyFactory.generatePublic(dSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(exception.getMessage(), exception);
            }
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }

    static Collection findIssuerCerts(X509Certificate x509Certificate, List<CertStore> list, List<aUv> list2) throws aUT {
        Iterator iterator;
        Serializable serializable;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(x509Certificate.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new aUT("Subject criteria for certificate selector to find issuer certificate could not be set.", iOException);
        }
        aUw<? extends Certificate> aUw2 = new aUw.a(x509CertSelector).bmb();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        try {
            serializable = new ArrayList();
            serializable.addAll(aVm.a(aUw2, list));
            serializable.addAll(aVm.a(aUw2, list2));
            iterator = serializable.iterator();
        }
        catch (aUT aUT2) {
            throw new aUT("Issuer certificate cannot be searched.", aUT2);
        }
        serializable = null;
        while (iterator.hasNext()) {
            serializable = (X509Certificate)iterator.next();
            linkedHashSet.add(serializable);
        }
        return linkedHashSet;
    }

    protected static void verifyX509Certificate(X509Certificate x509Certificate, PublicKey publicKey, String string) throws GeneralSecurityException {
        if (string == null) {
            x509Certificate.verify(publicKey);
        } else {
            x509Certificate.verify(publicKey, string);
        }
    }
}

