/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aBK;
import com.aspose.html.utils.aBn;
import com.aspose.html.utils.aCd;
import com.aspose.html.utils.aUT;
import com.aspose.html.utils.aUxx;
import com.aspose.html.utils.aUy;
import com.aspose.html.utils.aVW;
import com.aspose.html.utils.aVm;
import com.aspose.html.utils.aXl;
import com.aspose.html.utils.atE;
import com.aspose.html.utils.ats;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class aVV
extends CertPathValidatorSpi {
    private final Provider lwa;

    aVV(Provider provider) {
        this.lwa = provider;
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        aUy aUy2;
        if (certPathParameters instanceof aUy) {
            aUy2 = (aUy)certPathParameters;
        } else if (certPathParameters instanceof aUxx) {
            aUy2 = ((aUxx)certPathParameters).bmc();
        } else if (certPathParameters instanceof PKIXParameters) {
            aUy2 = new aUy.a((PKIXParameters)certPathParameters).bmf();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + aUy.class.getName() + " instance.");
        }
        if (aUy2.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = aUy2.getInitialPolicies();
        try {
            trustAnchor = aVm.findTrustAnchor((X509Certificate)list.get(list.size() - 1), aUy2.getTrustAnchors(), aUy2.getSigProvider());
        }
        catch (aUT aUT2) {
            throw new CertPathValidatorException(aUT2.getMessage(), (Throwable)aUT2, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        aUy2 = new aUy.a(aUy2).a(trustAnchor).bmf();
        int n3 = 0;
        List[] listArray = new ArrayList[n2 + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        aVW aVW2 = new aVW(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(aVW2);
        aCd aCd2 = new aCd();
        HashSet hashSet3 = new HashSet();
        int n4 = aUy2.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n5 = aUy2.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n6 = aUy2.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = aVm.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        aBn aBn2 = null;
        try {
            aBn2 = aVm.g(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        atE atE2 = aBn2.bbD();
        ats ats2 = aBn2.bbE();
        int n7 = n2;
        if (aUy2.bme() != null && !aUy2.bme().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = aUy2.getCertPathCheckers();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n3 = list.size() - 1; n3 >= 0; --n3) {
            boolean bl2;
            int n8 = n2 - n3;
            x509Certificate2 = (X509Certificate)list.get(n3);
            boolean bl3 = bl2 = n3 == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n3);
            }
            aXl.a(certPath, aUy2, n3, publicKey, bl2, x500Principal, x509Certificate, this.lwa);
            aXl.a(certPath, n3, aCd2);
            aVW2 = aXl.a(certPath, n3, hashSet3, aVW2, listArray, n5);
            aVW2 = aXl.a(certPath, n3, aVW2);
            aXl.a(certPath, n3, aVW2, n4);
            if (n8 == n2) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n3);
            }
            aXl.prepareNextCertA(certPath, n3);
            aVW2 = aXl.a(certPath, n3, listArray, aVW2, n6);
            aXl.b(certPath, n3, aCd2);
            n4 = aXl.prepareNextCertH1(certPath, n3, n4);
            n6 = aXl.prepareNextCertH2(certPath, n3, n6);
            n5 = aXl.prepareNextCertH3(certPath, n3, n5);
            n4 = aXl.prepareNextCertI1(certPath, n3, n4);
            n6 = aXl.prepareNextCertI2(certPath, n3, n6);
            n5 = aXl.prepareNextCertJ(certPath, n3, n5);
            aXl.prepareNextCertK(certPath, n3);
            n7 = aXl.prepareNextCertL(certPath, n3, n7);
            n7 = aXl.prepareNextCertM(certPath, n3, n7);
            aXl.prepareNextCertN(certPath, n3);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(aXl.lVQ);
            } else {
                hashSet = new HashSet();
            }
            aXl.prepareNextCertO(certPath, n3, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Principal = aVm.getSubjectPrincipal(x509Certificate);
            try {
                publicKey = aVm.getNextWorkingKey(certPath.getCertificates(), n3, this.lwa);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n3);
            }
            aBn2 = aVm.g(publicKey);
            atE2 = aBn2.bbD();
            ats2 = aBn2.bbE();
        }
        n4 = aXl.wrapupCertA(n4, x509Certificate2);
        n4 = aXl.wrapupCertB(certPath, n3 + 1, n4);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(aXl.lVQ);
            set2.remove(aBK.kba.getId());
        } else {
            set2 = new HashSet<String>();
        }
        aXl.wrapupCertF(certPath, n3 + 1, list2, set2);
        hashSet = aXl.a(certPath, aUy2, set, n3 + 1, listArray, aVW2, hashSet3);
        if (n4 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n3);
    }
}

