/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aUA;
import com.aspose.html.utils.aUB;
import com.aspose.html.utils.aUC;
import com.aspose.html.utils.aUD;
import com.aspose.html.utils.aUE;
import com.aspose.html.utils.aUF;
import com.aspose.html.utils.aUG;
import com.aspose.html.utils.aUH;
import com.aspose.html.utils.aUI;
import com.aspose.html.utils.aUJ;
import com.aspose.html.utils.aXC;
import com.aspose.html.utils.aXF;
import com.aspose.html.utils.aXN;
import com.aspose.html.utils.aXO;
import com.aspose.html.utils.bfr;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class aUj {
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public aUj(final PublicKey publicKey, final PrivateKey privateKey) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                aUj.this.checkKeyPairForConsistency(publicKey, privateKey);
                return null;
            }
        });
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkKeyPairForConsistency(PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey instanceof ECKey && privateKey instanceof ECKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            if (!(eCPrivateKey.getParams().getCurve().equals(eCPublicKey.getParams().getCurve()) && eCPrivateKey.getParams().getGenerator().equals(eCPublicKey.getParams().getGenerator()) && eCPrivateKey.getParams().getOrder().equals(eCPublicKey.getParams().getOrder()) && eCPrivateKey.getParams().getCofactor() == eCPublicKey.getParams().getCofactor())) {
                throw new IllegalArgumentException("EC keys do not have the same domain parameters");
            }
            aXF aXF2 = new aXF(eCPrivateKey.getParams());
            if (aXF2.bgE().beq().j(eCPrivateKey.getS()).bnX().h(aXF2.bgE().bep().l(eCPublicKey.getW().getAffineX(), eCPublicKey.getW().getAffineY()))) return;
            throw new IllegalArgumentException("EC public key not consistent with EC private key");
        }
        if (publicKey instanceof DHKey && privateKey instanceof DHKey) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
            if (!dHParameterSpec.getG().equals(dHPublicKey.getParams().getG()) && !dHParameterSpec.getP().equals(dHPublicKey.getParams().getP())) {
                throw new IllegalArgumentException("DH keys do not have the same domain parameters");
            }
            if (dHParameterSpec.getG().modPow(dHPrivateKey.getX(), dHParameterSpec.getP()).equals(dHPublicKey.getY())) return;
            throw new IllegalArgumentException("DH public key not consistent with DH private key");
        }
        if (publicKey instanceof DSAKey && privateKey instanceof DSAKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPrivateKey.getParams();
            if (!(dSAParams.getG().equals(dSAPublicKey.getParams().getG()) || dSAParams.getP().equals(dSAPublicKey.getParams().getP()) || dSAParams.getQ().equals(dSAPublicKey.getParams().getQ()))) {
                throw new IllegalArgumentException("DSA keys do not have the same domain parameters");
            }
            if (dSAParams.getG().modPow(dSAPrivateKey.getX(), dSAParams.getP()).equals(dSAPublicKey.getY())) return;
            throw new IllegalArgumentException("DSA public key not consistent with DSA private key");
        }
        if (publicKey instanceof RSAKey && privateKey instanceof RSAKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            if (!rSAPrivateKey.getModulus().equals(rSAPublicKey.getModulus())) {
                throw new IllegalArgumentException("RSA keys do not have the same modulus");
            }
            BigInteger bigInteger = BigInteger.valueOf(2L);
            if (bigInteger.modPow(rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getModulus()).modPow(rSAPublicKey.getPublicExponent(), rSAPrivateKey.getModulus()).equals(bigInteger)) return;
            throw new IllegalArgumentException("RSA public key not consistent with RSA private key");
        }
        if (publicKey instanceof aUG && privateKey instanceof aUG) {
            if (!((aUG)((Object)publicKey)).bmh().equals(((aUG)((Object)privateKey)).bmh())) {
                throw new IllegalArgumentException("GOST3410 parameters mismatch");
            }
            if (publicKey instanceof aUI && privateKey instanceof aUH) {
                aUH aUH2 = (aUH)privateKey;
                aUI aUI2 = (aUI)publicKey;
                aXO aXO2 = aUH2.bmh();
                aXN aXN2 = (aXN)aXO2.getDomainParametersSpec();
                if (aXN2.getA().modPow(aUH2.getX(), aXN2.getP()).equals(aUI2.getY())) return;
                throw new IllegalArgumentException("GOST3410 public key not consistent with GOST3410 private key");
            }
            if (!(publicKey instanceof aUE) || !(privateKey instanceof aUD)) throw new IllegalArgumentException("GOST3410 key pair inconsistent");
            aUD aUD2 = (aUD)privateKey;
            aUE aUE2 = (aUE)publicKey;
            aXO aXO3 = aUD2.bmh();
            aXF aXF3 = (aXF)aXO3.getDomainParametersSpec();
            aXF aXF4 = new aXF(aXF3);
            if (aXF4.bgE().beq().j(aUD2.getS()).bnX().h(aXF4.bgE().bep().l(aUE2.getW().getAffineX(), aUE2.getW().getAffineY()))) return;
            throw new IllegalArgumentException("ECGOST3410 public key not consistent with ECGOST3410 private key");
        }
        if (publicKey instanceof aUA && privateKey instanceof aUA) {
            aUB aUB2 = (aUB)privateKey;
            aUC aUC2 = (aUC)publicKey;
            if (!aUB2.bmg().equals(aUC2.bmg())) {
                throw new IllegalArgumentException("DSTU4145 keys do not have the same domain parameters");
            }
            aXC aXC2 = aUB2.bmg();
            aXF aXF5 = new aXF(aXC2);
            if (aXF5.bgE().beq().j(aUB2.getS()).bnY().bnX().h(aXF5.bgE().bep().l(aUC2.getW().getAffineX(), aUC2.getW().getAffineY()))) return;
            throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
        }
        if (publicKey instanceof aUF && privateKey instanceof aUF) {
            aUF aUF2 = (aUF)((Object)privateKey);
            aUF aUF3 = (aUF)((Object)publicKey);
            if (!aUF2.getAlgorithm().equals(aUF3.getAlgorithm())) {
                throw new IllegalArgumentException("EdDSA keys do not have the same domain parameters");
            }
            if (bfr.areEqual(aUF2.getPublicData(), aUF3.getPublicData())) return;
            throw new IllegalArgumentException("EdDSA public key not consistent with EdDSA private key");
        }
        if (!(publicKey instanceof aUJ) || !(privateKey instanceof aUJ)) throw new IllegalArgumentException("Key pair inconsistent");
        aUJ aUJ2 = (aUJ)((Object)privateKey);
        aUJ aUJ3 = (aUJ)((Object)publicKey);
        if (!aUJ2.getAlgorithm().equals(aUJ3.getAlgorithm())) {
            throw new IllegalArgumentException("XDH keys do not have the same domain parameters");
        }
        if (bfr.areEqual(aUJ2.getPublicData(), aUJ3.getPublicData())) return;
        throw new IllegalArgumentException("XDH public key not consistent with XDH private key");
    }

    public PublicKey getPublic() {
        return this.publicKey;
    }

    public PrivateKey getPrivate() {
        return this.privateKey;
    }
}

