/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aPV;
import com.aspose.html.utils.aQV;
import com.aspose.html.utils.aQa;
import com.aspose.html.utils.aQd;
import com.aspose.html.utils.aQk;
import com.aspose.html.utils.aQp;
import com.aspose.html.utils.aQs;
import com.aspose.html.utils.aRa;
import com.aspose.html.utils.aRm;
import com.aspose.html.utils.aRz;
import com.aspose.html.utils.aSi;
import com.aspose.html.utils.bfr;

public class aRe
implements aRa {
    private static final byte lkF = 0;
    private static final byte lkG = 1;
    private static final byte lkH = 2;
    private aRm lkI;
    private boolean forEncryption;
    private int blockSize;
    private aQp lkj;
    private byte[] nonceMac;
    private byte[] associatedTextMac;
    private byte[] macBlock;
    private int macSize;
    private byte[] bufBlock;
    private int bufOff;
    private boolean cipherInitialized;
    private byte[] initialAssociatedText;

    public aRe(aPV aPV2) {
        this.blockSize = aPV2.getBlockSize();
        this.lkj = new aQV(aPV2);
        this.macBlock = new byte[this.blockSize];
        this.associatedTextMac = new byte[this.lkj.getMacSize()];
        this.nonceMac = new byte[this.lkj.getMacSize()];
        this.lkI = new aRm(aPV2);
    }

    public String getAlgorithmName() {
        return this.lkI.bkI().getAlgorithmName() + "/EAX";
    }

    public aPV bkI() {
        return this.lkI.bkI();
    }

    public int getBlockSize() {
        return this.lkI.getBlockSize();
    }

    public void a(boolean bl2, aQa aQa2) throws IllegalArgumentException {
        aQa aQa3;
        byte[] byArray;
        Object object;
        this.forEncryption = bl2;
        if (aQa2 instanceof aRz) {
            object = (aRz)aQa2;
            byArray = ((aRz)object).getNonce();
            this.initialAssociatedText = ((aRz)object).getAssociatedText();
            this.macSize = ((aRz)object).getMacSize() / 8;
            aQa3 = ((aRz)object).bkM();
        } else if (aQa2 instanceof aSi) {
            object = (aSi)aQa2;
            byArray = ((aSi)object).getIV();
            this.initialAssociatedText = null;
            this.macSize = this.lkj.getMacSize() / 2;
            aQa3 = ((aSi)object).blb();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to EAX");
        }
        this.bufBlock = new byte[bl2 ? this.blockSize : this.blockSize + this.macSize];
        object = new byte[this.blockSize];
        this.lkj.a(aQa3);
        object[this.blockSize - 1] = false;
        this.lkj.update((byte[])object, 0, this.blockSize);
        this.lkj.update(byArray, 0, byArray.length);
        this.lkj.doFinal(this.nonceMac, 0);
        this.lkI.a(true, new aSi(null, this.nonceMac));
        this.reset();
    }

    private void initCipher() {
        if (this.cipherInitialized) {
            return;
        }
        this.cipherInitialized = true;
        this.lkj.doFinal(this.associatedTextMac, 0);
        byte[] byArray = new byte[this.blockSize];
        byArray[this.blockSize - 1] = 2;
        this.lkj.update(byArray, 0, this.blockSize);
    }

    private void calculateMac() {
        byte[] byArray = new byte[this.blockSize];
        this.lkj.doFinal(byArray, 0);
        for (int i2 = 0; i2 < this.macBlock.length; ++i2) {
            this.macBlock[i2] = (byte)(this.nonceMac[i2] ^ this.associatedTextMac[i2] ^ byArray[i2]);
        }
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl2) {
        this.lkI.reset();
        this.lkj.reset();
        this.bufOff = 0;
        bfr.fill(this.bufBlock, (byte)0);
        if (bl2) {
            bfr.fill(this.macBlock, (byte)0);
        }
        byte[] byArray = new byte[this.blockSize];
        byArray[this.blockSize - 1] = 1;
        this.lkj.update(byArray, 0, this.blockSize);
        this.cipherInitialized = false;
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public void processAADByte(byte by2) {
        if (this.cipherInitialized) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decription processing has begun.");
        }
        this.lkj.update(by2);
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        if (this.cipherInitialized) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
        }
        this.lkj.update(byArray, n2, n3);
    }

    public int processByte(byte by2, byte[] byArray, int n2) throws aQd {
        this.initCipher();
        return this.process(by2, byArray, n2);
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws aQd {
        this.initCipher();
        if (byArray.length < n2 + n3) {
            throw new aQd("Input buffer too short");
        }
        int n5 = 0;
        for (int i2 = 0; i2 != n3; ++i2) {
            n5 += this.process(byArray[n2 + i2], byArray2, n4 + n5);
        }
        return n5;
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, aQk {
        this.initCipher();
        int n3 = this.bufOff;
        byte[] byArray2 = new byte[this.bufBlock.length];
        this.bufOff = 0;
        if (this.forEncryption) {
            if (byArray.length < n2 + n3 + this.macSize) {
                throw new aQs("Output buffer too short");
            }
            this.lkI.processBlock(this.bufBlock, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            this.lkj.update(byArray2, 0, n3);
            this.calculateMac();
            System.arraycopy(this.macBlock, 0, byArray, n2 + n3, this.macSize);
            this.reset(false);
            return n3 + this.macSize;
        }
        if (byArray.length < n2 + n3 - this.macSize) {
            throw new aQs("Output buffer too short");
        }
        if (n3 < this.macSize) {
            throw new aQk("data too short");
        }
        if (n3 > this.macSize) {
            this.lkj.update(this.bufBlock, 0, n3 - this.macSize);
            this.lkI.processBlock(this.bufBlock, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2, n3 - this.macSize);
        }
        this.calculateMac();
        if (!this.verifyMac(this.bufBlock, n3 - this.macSize)) {
            throw new aQk("mac check in EAX failed");
        }
        this.reset(false);
        return n3 - this.macSize;
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, byArray, 0, this.macSize);
        return byArray;
    }

    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (!this.forEncryption) {
            if (n3 < this.macSize) {
                return 0;
            }
            n3 -= this.macSize;
        }
        return n3 - n3 % this.blockSize;
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    private int process(byte by2, byte[] byArray, int n2) {
        this.bufBlock[this.bufOff++] = by2;
        if (this.bufOff == this.bufBlock.length) {
            int n3;
            if (byArray.length < n2 + this.blockSize) {
                throw new aQs("Output buffer is too short");
            }
            if (this.forEncryption) {
                n3 = this.lkI.processBlock(this.bufBlock, 0, byArray, n2);
                this.lkj.update(byArray, n2, this.blockSize);
            } else {
                this.lkj.update(this.bufBlock, 0, this.blockSize);
                n3 = this.lkI.processBlock(this.bufBlock, 0, byArray, n2);
            }
            this.bufOff = 0;
            if (!this.forEncryption) {
                System.arraycopy(this.bufBlock, this.blockSize, this.bufBlock, 0, this.macSize);
                this.bufOff = this.macSize;
            }
            return n3;
        }
        return 0;
    }

    private boolean verifyMac(byte[] byArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.macSize; ++i2) {
            n3 |= this.macBlock[i2] ^ byArray[n2 + i2];
        }
        return n3 == 0;
    }
}

