/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering.pdf;

import com.aspose.html.drawing.Color;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.p219.z1;
import com.aspose.html.internal.p4.z31;
import com.aspose.html.rendering.RenderingOptions;
import com.aspose.html.rendering.pdf.encryption.PdfEncryptionInfo;
import com.aspose.html.rendering.pdf.z10;
import com.aspose.html.rendering.pdf.z3;

public class PdfRenderingOptions
extends RenderingOptions {
    private final z3 _fontException = new z3();
    private PdfEncryptionInfo _encryptionDetails;
    private int _expandedOutlineLevels;
    private int _textCompression = 3;
    private int _imageCompression = 0;
    private int _jpegQuality = 95;
    private boolean _isShowHyperlinkRects;
    private int _compliance = 0;
    private z10 _complianceOptions = new z10();
    private int _fontEmbeddingRule = 2;
    private Color _imageTransparentColor = Color.getTransparent().Clone();
    private boolean _applyImageTransparent = false;
    private long _tabSize = 8L;
    private z1 _digitalSignatureDetails;

    public void validate() {
        if (this._encryptionDetails != null) {
            if (!z31.m47(this._encryptionDetails.getUserPassword()) && !z31.m47(this._encryptionDetails.getOwnerPassword())) {
                throw new ArgumentException("You have requested PDF encryption, but not specified either a user password or an owner password.");
            }
            if (StringExtensions.equals(this._encryptionDetails.getUserPassword(), this._encryptionDetails.getOwnerPassword())) {
                throw new ArgumentException("The PDF user password and owner password cannot be the same. Please enter different passwords.");
            }
        }
    }

    public int getExpandedOutlineLevels() {
        return this._expandedOutlineLevels;
    }

    public void setExpandedOutlineLevels(int value) {
        this._expandedOutlineLevels = value;
    }

    public int getTextCompression() {
        return this._textCompression;
    }

    public void setTextCompression(int value) {
        this._textCompression = value;
    }

    public int getImageCompression() {
        return this._imageCompression;
    }

    public void setImageCompression(int value) {
        this._imageCompression = value;
    }

    public int getJpegQuality() {
        return this._jpegQuality;
    }

    public void setJpegQuality(int value) {
        if (value < 0 || value > 100) {
            throw new ArgumentException("value");
        }
        this._jpegQuality = value;
    }

    public boolean isShowHyperlinkRects() {
        return this._isShowHyperlinkRects;
    }

    public void setShowHyperlinkRects(boolean value) {
        this._isShowHyperlinkRects = value;
    }

    public int getCompliance() {
        return this._compliance;
    }

    public void setCompliance(int value) {
        this._compliance = value;
    }

    public z10 getComplianceOptions() {
        return this._complianceOptions;
    }

    public void setComplianceOptions(z10 value) {
        this._complianceOptions = value;
    }

    public boolean getPdfaCompliant() {
        switch (this._compliance) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public PdfEncryptionInfo getEncryption() {
        return this._encryptionDetails;
    }

    public void setEncryption(PdfEncryptionInfo value) {
        this._encryptionDetails = value;
    }

    public boolean isEncrypted() {
        return this._encryptionDetails != null;
    }

    public Color getImageTransparentColor() {
        return this._imageTransparentColor;
    }

    public void setImageTransparentColor(Color value) {
        value.CloneTo(this._imageTransparentColor);
    }

    public boolean getApplyImageTransparent() {
        return this._applyImageTransparent;
    }

    public void setApplyImageTransparent(boolean value) {
        this._applyImageTransparent = value;
    }

    public z1 getDigitalSignatureDetails() {
        return this._digitalSignatureDetails;
    }

    public void setDigitalSignatureDetails(z1 value) {
        this._digitalSignatureDetails = value;
    }

    public z3 getFontException() {
        return this._fontException;
    }

    public int getFontEmbeddingRule() {
        return this._fontEmbeddingRule;
    }

    public void setFontEmbeddingRule(int value) {
        this._fontEmbeddingRule = value;
    }

    public long getTabSize() {
        return this._tabSize;
    }

    public void setTabSize(long value) {
        this._tabSize = value;
        if ((this._tabSize & 0xFFFFFFFFL) < 0L) {
            this._tabSize = 0L;
        }
    }
}

