/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.Generic.Stack;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.InAttribute;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.OutAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p11.z16;
import com.aspose.html.internal.p331.z7;
import com.aspose.html.internal.p4.z23;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.rendering.RenderingOptions;
import com.aspose.html.rendering.z6;
import com.aspose.html.z15;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Device<TGraphicContext extends GraphicContext, TRenderingOptions extends RenderingOptions>
implements IDevice {
    private final Stack<TGraphicContext> _contextStack;
    private final List<Document> documents = new List();
    private TRenderingOptions auto_Options;
    private ICreateStreamProvider auto_StreamProvider;
    private Stream _outputStream;
    private int auto_PageIndex;
    private Document auto_CurrentDocument;
    private boolean auto_RenderingStarted;

    protected Device(TRenderingOptions options, ICreateStreamProvider streamProvider) {
        this._contextStack = new Stack();
        this.setOptions(((RenderingOptions)options).deepClone());
        this.setStreamProvider(streamProvider);
    }

    protected Device(TRenderingOptions options, String file) {
        this(options, new z4(file));
    }

    protected Device(TRenderingOptions options, Stream stream) {
        this(options, new z5(stream));
    }

    public Device(TRenderingOptions options, InputStream stream) {
        this(options, new z5(Stream.fromJava(stream)));
    }

    public Device(TRenderingOptions options, OutputStream outputStream) {
        this(options, new z2(outputStream));
    }

    protected void initialize() {
        try {
            this._contextStack.clear();
            this._contextStack.push((GraphicContext)this.getGraphicContextCalss().newInstance());
            this.setPageIndex(0);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception caught: ", exception);
        }
    }

    public TRenderingOptions getOptions() {
        return this.auto_Options;
    }

    private void setOptions(TRenderingOptions value) {
        this.auto_Options = value;
    }

    protected z1 getConfiguration() {
        z1 z1100 = new z1();
        z1100.m487(0);
        return z1100;
    }

    public TGraphicContext getGraphicContext() {
        return (TGraphicContext)((GraphicContext)this._contextStack.peek());
    }

    protected ICreateStreamProvider getStreamProvider() {
        return this.auto_StreamProvider;
    }

    private void setStreamProvider(ICreateStreamProvider value) {
        this.auto_StreamProvider = value;
    }

    protected Stream getOutputStream() {
        return this._outputStream;
    }

    private void setOutputStream(Stream value) {
        this._outputStream = value == null ? null : new z15(value);
    }

    public Stream getOriginalOutputStream() {
        z15 z1510 = Operators.as(this._outputStream, z15.class);
        if (z1510 != null) {
            return z1510.m79();
        }
        return this._outputStream;
    }

    @Override
    public void saveGraphicContext() {
        this._contextStack.push(((GraphicContext)this._contextStack.peek()).deepClone());
    }

    @Override
    public void restoreGraphicContext() {
        if (this._contextStack.size() > 1) {
            this._contextStack.pop();
        }
    }

    public int getPageIndex() {
        return this.auto_PageIndex;
    }

    public void setPageIndex(int value) {
        this.auto_PageIndex = value;
    }

    public Document getCurrentDocument() {
        return this.auto_CurrentDocument;
    }

    public void setCurrentDocument(Document value) {
        this.auto_CurrentDocument = value;
    }

    protected abstract String getExtension();

    public boolean getRenderingStarted() {
        return this.auto_RenderingStarted;
    }

    private void setRenderingStarted(boolean value) {
        this.auto_RenderingStarted = value;
    }

    @Override
    public void beginDocument(Document document) {
        this.initialize();
        this.setCurrentDocument(document);
        this.documents.addItem(this.getCurrentDocument());
        if (this.getConfiguration().m2501() == 0 && !this.getRenderingStarted()) {
            String string = "about".equals(this.getCurrentDocument().getContext().getWindow().getLocation().getProtocol()) ? "document" : Path.getFileNameWithoutExtension(this.getCurrentDocument().getDocumentURI());
            this.setOutputStream(this.getStreamProvider().getStream(string, this.getExtension()));
        }
        if (!this.getRenderingStarted()) {
            this.setPageIndex(0);
            this.setRenderingStarted(true);
        }
    }

    @Override
    public void endDocument() {
        this.setCurrentDocument(null);
    }

    @Override
    public void beginPage(SizeF size) {
        this.setPageIndex(this.getPageIndex() + 1);
        if (this.getConfiguration().m2501() == 1) {
            String string = "about".equals(this.getCurrentDocument().getContext().getWindow().getLocation().getProtocol()) ? "document" : Path.getFileNameWithoutExtension(this.getCurrentDocument().getDocumentURI());
            this.setOutputStream(this.getStreamProvider().getStream(string, this.getExtension(), this.getPageIndex()));
        }
    }

    @Override
    public void endPage() {
        if (this.getConfiguration().m2501() == 1) {
            IDisposable iDisposable = (IDisposable)((z7)z23.get("Func4<Document, Stream, IDevice, IDisposable>")).m2(this.getCurrentDocument(), (Stream)Operators.as(this.getOutputStream(), z15.class), this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.getStreamProvider().releaseStream(this.getOriginalOutputStream());
            this.setOutputStream(null);
        }
    }

    @Override
    public void flush() {
        this.setRenderingStarted(false);
        if (this.getConfiguration().m2501() == 0) {
            IDisposable iDisposable = (IDisposable)((z7)z23.get("Func4<List<Document>, Stream, IDevice, IDisposable>")).m2(this.documents, (Stream)Operators.as(this.getOutputStream(), z15.class), this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.getStreamProvider().releaseStream(this.getOriginalOutputStream());
            this.setOutputStream(null);
        } else if (this.getOutputStream() != null && this.getConfiguration().m2501() == 1) {
            IDisposable iDisposable = (IDisposable)((z7)z23.get("Func4<Document, Stream, IDevice, IDisposable>")).m2(this.documents.get_Item(this.documents.size() - 1), (Stream)Operators.as(this.getOutputStream(), z15.class), this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.getStreamProvider().releaseStream(this.getOriginalOutputStream());
            this.setOutputStream(null);
        }
        this.documents.clear();
    }

    @Override
    public abstract boolean beginElement(Element var1, RectangleF var2);

    @Override
    public abstract void endElement(Element var1);

    @Override
    public abstract void closePath();

    @Override
    public abstract void moveTo(PointF var1);

    @Override
    public abstract void lineTo(PointF var1);

    @Override
    public abstract void addRect(RectangleF var1);

    @Override
    public abstract void cubicBezierTo(PointF var1, PointF var2, PointF var3);

    @Override
    public abstract void stroke();

    @Override
    public abstract void fill(int var1);

    @Override
    public abstract void clip(int var1);

    @Override
    public abstract void strokeAndFill(int var1);

    @Override
    public abstract void fillText(String var1, PointF var2);

    @Override
    public abstract void strokeText(String var1, PointF var2);

    @Override
    public abstract void drawImage(byte[] var1, int var2, RectangleF var3);

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    protected void dispose(boolean disposing) {
    }

    public void initPageBackground(SizeF size) {
        this.saveGraphicContext();
        ((GraphicContext)this.getGraphicContext()).setFillBrush(new z6(new z16(com.aspose.html.internal.p15.z5.m1(((RenderingOptions)this.getOptions()).getBackgroundColor().Clone()))));
        this.addRect(new RectangleF(0.0f, 0.0f, size.getWidth(), size.getHeight()));
        this.fill(1);
        this.restoreGraphicContext();
    }

    protected abstract Class<TGraphicContext> getGraphicContextCalss();

    private static class z2
    extends Stream {
        private OutputStream m12655;

        public z2(OutputStream outputStream) {
            this.m12655 = outputStream;
        }

        @Override
        public boolean canRead() {
            return false;
        }

        @Override
        public boolean canSeek() {
            return false;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        protected void dispose(boolean disposing) {
            try {
                if (this.m12655 != null) {
                    this.m12655.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
            finally {
                this.m12655 = null;
                super.dispose(disposing);
            }
        }

        @Override
        public void flush() {
            try {
                this.m12655.flush();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public void setLength(long arg0) {
        }

        @Override
        public long getPosition() {
            return 0L;
        }

        @Override
        public void setPosition(long arg0) {
        }

        @Override
        public int read(@InAttribute @OutAttribute byte[] arg0, int arg1, int arg2) {
            return 0;
        }

        @Override
        public long seek(long arg0, int arg1) {
            return 0L;
        }

        @Override
        public void write(byte[] b2, int off, int len) {
            try {
                this.m12655.write(b2, off, len);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
    }

    public static final class z3
    extends Enum {
        public static final int m12656 = 0;
        public static final int m12657 = 1;

        private z3() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)z3.class, Integer.class){
                {
                    this.addConstant("SingleStream", 0L);
                    this.addConstant("MultipleStreams", 1L);
                }
            });
        }
    }

    public static class z1 {
        private int m12654;

        public int m2501() {
            return this.m12654;
        }

        public void m487(int n2) {
            this.m12654 = n2;
        }
    }

    private static class z5
    implements ICreateStreamProvider {
        private Stream stream;

        public z5(Stream stream) {
            this.stream = stream;
        }

        @Override
        public Stream getStream(String name, String extension) {
            return this.stream;
        }

        @Override
        public Stream getStream(String name, String extension, int page) {
            return this.stream;
        }

        @Override
        public void releaseStream(Stream stream) {
        }

        @Override
        public void dispose() {
            this.stream = null;
        }
    }

    private static class z4
    implements ICreateStreamProvider {
        private final String m12658;
        private final String fileName;
        private final String fileExtension;

        public z4(String string) {
            this.m12658 = Path.getDirectoryName(string);
            this.fileName = Path.getFileNameWithoutExtension(string);
            this.fileExtension = Path.getExtension(string);
        }

        @Override
        public Stream getStream(String name, String extension) {
            String string = this.fileName;
            if (string == null) {
                string = name;
            }
            name = string;
            String string2 = this.fileExtension;
            if (string2 == null) {
                string2 = extension;
            }
            extension = string2;
            String string3 = StringExtensions.format("{0}{1}", name, extension);
            return File.create(Path.combine(this.m12658, string3));
        }

        @Override
        public Stream getStream(String name, String extension, int page) {
            String string = this.fileName;
            if (string == null) {
                string = name;
            }
            name = string;
            String string2 = this.fileExtension;
            if (string2 == null) {
                string2 = extension;
            }
            extension = string2;
            String string3 = StringExtensions.format("{0}_{1}{2}", name, page, extension);
            return File.create(Path.combine(this.m12658, string3));
        }

        @Override
        public void releaseStream(Stream stream) {
            if (stream != null) {
                stream.dispose();
            }
        }

        @Override
        public void dispose() {
        }
    }
}

