/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.compression.crc;

import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.core.compression.crc.CRC32;

public class CrcCalculatorStream
extends Stream
implements IDisposable {
    private static long b = -99L;
    Stream a;
    private CRC32 c;
    private long d = -99L;
    private boolean e;

    public CrcCalculatorStream(Stream stream) {
        this(true, b, stream, null);
    }

    public CrcCalculatorStream(Stream stream, boolean leaveOpen) {
        this(leaveOpen, b, stream, null);
    }

    public CrcCalculatorStream(Stream stream, long length) {
        this(true, length, stream, null);
        if (length < 0L) {
            throw new IllegalArgumentException("length");
        }
    }

    public CrcCalculatorStream(Stream stream, long length, boolean leaveOpen) {
        this(leaveOpen, length, stream, null);
        if (length < 0L) {
            throw new IllegalArgumentException("length");
        }
    }

    public CrcCalculatorStream(Stream stream, long length, boolean leaveOpen, CRC32 crc32) {
        this(leaveOpen, length, stream, crc32);
        if (length < 0L) {
            throw new IllegalArgumentException("length");
        }
    }

    private CrcCalculatorStream(boolean leaveOpen, long length, Stream stream, CRC32 crc32) {
        this.a = stream;
        this.c = crc32 != null ? crc32 : new CRC32();
        this.d = length;
        this.e = leaveOpen;
    }

    public long getTotalBytesSlurped() {
        return this.c.getTotalBytesRead();
    }

    public int getCrc() {
        return this.c.getCrc32Result();
    }

    public boolean getLeaveOpen() {
        return this.e;
    }

    public void setLeaveOpen(boolean value) {
        this.e = value;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        int n2;
        int n3 = count;
        if (this.d != b) {
            if (this.c.getTotalBytesRead() >= this.d) {
                return 0;
            }
            long l2 = this.d - this.c.getTotalBytesRead();
            if (l2 < (long)count) {
                n3 = (int)l2;
            }
        }
        if ((n2 = this.a.read(buffer, offset, n3)) > 0) {
            this.c.slurpBlock(buffer, offset, n2);
        }
        return n2;
    }

    @Override
    public void write(byte[] buffer, int offset, int count) {
        if (count > 0) {
            this.c.slurpBlock(buffer, offset, count);
        }
        this.a.write(buffer, offset, count);
    }

    @Override
    public boolean canRead() {
        return this.a.canRead();
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return this.a.canWrite();
    }

    @Override
    public void flush() {
        this.a.flush();
    }

    @Override
    public long getLength() {
        if (this.d == b) {
            return this.a.getLength();
        }
        return this.d;
    }

    @Override
    public long getPosition() {
        return this.c.getTotalBytesRead();
    }

    @Override
    public void setPosition(long value) {
        throw new NotSupportedException();
    }

    @Override
    public long seek(long offset, int origin) {
        throw new NotSupportedException();
    }

    @Override
    public void setLength(long value) {
        throw new NotSupportedException();
    }

    @Override
    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        super.close();
        if (!this.e) {
            this.a.close();
        }
    }
}

