/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkcs.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Object;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.GOST28147Parameters;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBEParameter;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBES2Parameters;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBKDF2Params;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCS12PBEParams;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.internal.ms.core.bc.crypto.general.KDF;
import com.aspose.html.internal.ms.core.bc.jcajce.PBKDF1Key;
import com.aspose.html.internal.ms.core.bc.jcajce.PKCS12KeyWithParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.GOST28147ParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.PBKDF2KeySpec;
import com.aspose.html.internal.ms.core.bc.jcajce.util.DefaultJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.JcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.NamedJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.ProviderJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.operator.DefaultSecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.operator.InputDecryptor;
import com.aspose.html.internal.ms.core.bc.operator.InputDecryptorProvider;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.operator.ScryptParams;
import com.aspose.html.internal.ms.core.bc.operator.SecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.pkcs.jcajce.JceUtils;
import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JcePKCSPBEInputDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private boolean wrongPKCS12Zero = false;
    private SecretKeySizeProvider keySizeProvider = DefaultSecretKeySizeProvider.INSTANCE;

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setTryWrongPKCS12Zero(boolean tryWrong) {
        this.wrongPKCS12Zero = tryWrong;
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setKeySizeProvider(SecretKeySizeProvider keySizeProvider) {
        this.keySizeProvider = keySizeProvider;
        return this;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){
            private Cipher cipher;
            private AlgorithmIdentifier encryptionAlg;

            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                block9: {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                    try {
                        if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(aSN1ObjectIdentifier.getId());
                            this.cipher.init(2, new PKCS12KeyWithParameters(password, JcePKCSPBEInputDecryptorProviderBuilder.this.wrongPKCS12Zero, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue()));
                            this.encryptionAlg = algorithmIdentifier;
                            break block9;
                        }
                        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                            SecretKey secretKey;
                            ASN1Object aSN1Object;
                            Object object;
                            PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
                            if (JceUtils.id_scrypt.equals(pBES2Parameters.getKeyDerivationFunc().getAlgorithm())) {
                                object = ScryptParams.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
                                aSN1Object = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
                                KDF.ScryptParameters scryptParameters = KDF.SCRYPT.using(((ScryptParams)object).getSalt(), ((ScryptParams)object).getCostParameter().intValue(), ((ScryptParams)object).getBlockSize().intValue(), ((ScryptParams)object).getParallelizationParameter().intValue(), PasswordConverter.UTF8, password);
                                byte[] byArray = new byte[(JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize((AlgorithmIdentifier)aSN1Object) + 7) / 8];
                                new KDF.SCryptFactory().createKDFCalculator(scryptParameters).generateBytes(byArray);
                                secretKey = new SecretKeySpec(byArray, ((AlgorithmIdentifier)aSN1Object).getAlgorithm().getId());
                            } else {
                                object = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory(pBES2Parameters.getKeyDerivationFunc().getAlgorithm().getId());
                                aSN1Object = PBKDF2Params.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
                                AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
                                secretKey = ((PBKDF2Params)aSN1Object).isDefaultPrf() ? ((SecretKeyFactory)object).generateSecret(new PBEKeySpec(password, ((PBKDF2Params)aSN1Object).getSalt(), ((PBKDF2Params)aSN1Object).getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(algorithmIdentifier2))) : ((SecretKeyFactory)object).generateSecret(new PBKDF2KeySpec(password, ((PBKDF2Params)aSN1Object).getSalt(), ((PBKDF2Params)aSN1Object).getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(algorithmIdentifier2), ((PBKDF2Params)aSN1Object).getPrf()));
                            }
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(pBES2Parameters.getEncryptionScheme().getAlgorithm().getId());
                            this.encryptionAlg = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
                            object = pBES2Parameters.getEncryptionScheme().getParameters();
                            if (object instanceof ASN1OctetString) {
                                this.cipher.init(2, (Key)secretKey, new IvParameterSpec(ASN1OctetString.getInstance(object).getOctets()));
                            } else {
                                aSN1Object = GOST28147Parameters.getInstance(object);
                                this.cipher.init(2, (Key)secretKey, new GOST28147ParameterSpec(((GOST28147Parameters)aSN1Object).getEncryptionParamSet(), ((GOST28147Parameters)aSN1Object).getIV()));
                            }
                            break block9;
                        }
                        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC) || aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC)) {
                            PBEParameter pBEParameter = PBEParameter.getInstance(algorithmIdentifier.getParameters());
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(aSN1ObjectIdentifier.getId());
                            this.cipher.init(2, (Key)new PBKDF1Key(password, PasswordConverter.ASCII), new PBEParameterSpec(pBEParameter.getSalt(), pBEParameter.getIterationCount().intValue()));
                            break block9;
                        }
                        throw new OperatorCreationException("unable to create InputDecryptor: algorithm " + aSN1ObjectIdentifier + " unknown.");
                    }
                    catch (Exception exception) {
                        throw new OperatorCreationException("unable to create InputDecryptor: " + exception.getMessage(), exception);
                    }
                }
                return new InputDecryptor(){

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return encryptionAlg;
                    }

                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, cipher);
                    }
                };
            }
        };
    }
}

