/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkcs;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.DLSequence;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.AuthenticatedSafe;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.ContentInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.MacData;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.Pfx;
import com.aspose.html.internal.ms.core.bc.cms.CMSEncryptedDataGenerator;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSProcessableByteArray;
import com.aspose.html.internal.ms.core.bc.operator.OutputEncryptor;
import com.aspose.html.internal.ms.core.bc.pkcs.MacDataGenerator;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS12MacCalculatorBuilder;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS12PfxPdu;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS12SafeBag;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCSException;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCSIOException;
import java.io.IOException;

public class PKCS12PfxPduBuilder {
    private ASN1EncodableVector dataVector = new ASN1EncodableVector();

    public PKCS12PfxPduBuilder addData(PKCS12SafeBag data) throws IOException {
        this.dataVector.add(new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(new DLSequence(data.toASN1Structure()).getEncoded())));
        return this;
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, PKCS12SafeBag data) throws IOException {
        return this.addEncryptedData(dataEncryptor, new DERSequence(data.toASN1Structure()));
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, PKCS12SafeBag[] data) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != data.length; ++i2) {
            aSN1EncodableVector.add(data[i2].toASN1Structure());
        }
        return this.addEncryptedData(dataEncryptor, new DLSequence(aSN1EncodableVector));
    }

    private PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, ASN1Sequence data) throws IOException {
        CMSEncryptedDataGenerator cMSEncryptedDataGenerator = new CMSEncryptedDataGenerator();
        try {
            this.dataVector.add(cMSEncryptedDataGenerator.generate(new CMSProcessableByteArray(data.getEncoded()), dataEncryptor).toASN1Structure());
        }
        catch (CMSException cMSException) {
            throw new PKCSIOException(cMSException.getMessage(), cMSException.getCause());
        }
        return this;
    }

    public PKCS12PfxPdu build(PKCS12MacCalculatorBuilder macCalcBuilder, char[] password) throws PKCSException {
        Object object;
        byte[] byArray;
        AuthenticatedSafe authenticatedSafe = AuthenticatedSafe.getInstance(new DLSequence(this.dataVector));
        try {
            byArray = authenticatedSafe.getEncoded();
        }
        catch (IOException iOException) {
            throw new PKCSException("unable to encode AuthenticatedSafe: " + iOException.getMessage(), iOException);
        }
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(byArray));
        MacData macData = null;
        if (macCalcBuilder != null) {
            object = new MacDataGenerator(macCalcBuilder);
            macData = ((MacDataGenerator)object).build(password, byArray);
        }
        object = new Pfx(contentInfo, macData);
        return new PKCS12PfxPdu((Pfx)object);
    }
}

