/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.operator.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.jcajce.util.DefaultJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.NamedJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.ProviderJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculatorProvider;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.operator.jcajce.OperatorHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;

public class JcaDigestCalculatorProviderBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());

    public JcaDigestCalculatorProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaDigestCalculatorProviderBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public DigestCalculatorProvider build() throws OperatorCreationException {
        return new DigestCalculatorProvider(){

            public DigestCalculator get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
                DigestOutputStream digestOutputStream;
                try {
                    MessageDigest messageDigest = JcaDigestCalculatorProviderBuilder.this.helper.createDigest(algorithm);
                    digestOutputStream = new DigestOutputStream(messageDigest);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new OperatorCreationException("exception on setup: " + generalSecurityException, generalSecurityException);
                }
                return new DigestCalculator(){

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithm;
                    }

                    public OutputStream getOutputStream() {
                        return digestOutputStream;
                    }

                    public byte[] getDigest() {
                        return digestOutputStream.getDigest();
                    }
                };
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private MessageDigest dig;

        DigestOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes);
        }

        public void write(int b2) throws IOException {
            this.dig.update((byte)b2);
        }

        byte[] getDigest() {
            return this.dig.digest();
        }
    }
}

