/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.mime;

import com.aspose.html.internal.ms.core.bc.mime.LineReader;
import com.aspose.html.internal.ms.core.bc.util.Iterable;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Headers
implements Iterable<String> {
    private final Map<String, List> headers = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
    private final List<String> headersAsPresented;
    private final String contentTransferEncoding;
    private String boundary;
    private boolean multipart;
    private String contentType;
    private Map<String, String> contentTypeParameters;

    private static List<String> parseHeaders(InputStream src) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        LineReader lineReader = new LineReader(src);
        while ((string = lineReader.readLine()) != null && string.length() != 0) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public Headers(InputStream source, String defaultContentTransferEncoding) throws IOException {
        this(Headers.parseHeaders(source), defaultContentTransferEncoding);
    }

    public Headers(List<String> headerLines, String defaultContentTransferEncoding) {
        int n2;
        this.headersAsPresented = headerLines;
        String string = "";
        Object object = headerLines.iterator();
        while (object.hasNext()) {
            String string2 = object.next();
            if (string2.startsWith(" ") || string2.startsWith("\t")) {
                string = string + string2.trim();
                continue;
            }
            if (string.length() != 0) {
                this.put(string.substring(0, string.indexOf(58)).trim(), string.substring(string.indexOf(58) + 1).trim());
            }
            string = string2;
        }
        if (string.trim().length() != 0) {
            this.put(string.substring(0, string.indexOf(58)).trim(), string.substring(string.indexOf(58) + 1).trim());
        }
        if ((n2 = ((String)(object = this.getValues("Content-Type") == null ? "text/plain" : this.getValues("Content-Type")[0])).indexOf(59)) < 0) {
            this.contentType = object;
            this.contentTypeParameters = Collections.EMPTY_MAP;
        } else {
            this.contentType = ((String)object).substring(0, n2);
            this.contentTypeParameters = this.createContentTypeParameters(((String)object).substring(n2 + 1).trim());
        }
        String string3 = this.contentTransferEncoding = this.getValues("Content-Transfer-Encoding") == null ? defaultContentTransferEncoding : this.getValues("Content-Transfer-Encoding")[0];
        if (this.contentType.indexOf("multipart") >= 0) {
            this.multipart = true;
            String string4 = this.contentTypeParameters.get("boundary");
            this.boundary = string4.substring(1, string4.length() - 1);
        } else {
            this.boundary = null;
            this.multipart = false;
        }
    }

    public Map<String, String> getContentTypeAttributes() {
        return this.contentTypeParameters;
    }

    private Map<String, String> createContentTypeParameters(String contentTypeParameters) {
        String[] stringArray = contentTypeParameters.split(";");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i2 = 0; i2 != stringArray.length; ++i2) {
            String string = stringArray[i2];
            int n2 = string.indexOf(61);
            if (n2 < 0) {
                throw new IllegalArgumentException("malformed Content-Type header");
            }
            linkedHashMap.put(string.substring(0, n2).trim(), string.substring(n2 + 1).trim());
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String field, String value) {
        Headers headers = this;
        synchronized (headers) {
            KV kV = new KV(field, value);
            ArrayList<KV> arrayList = this.headers.get(field);
            if (arrayList == null) {
                arrayList = new ArrayList<KV>();
                this.headers.put(field, arrayList);
            }
            arrayList.add(kV);
        }
    }

    public Iterator<String> getNames() {
        return this.headers.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValues(String header) {
        Headers headers = this;
        synchronized (headers) {
            List list = this.headers.get(header);
            if (list == null) {
                return null;
            }
            String[] stringArray = new String[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                stringArray[i2] = ((KV)list.get((int)i2)).value;
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Headers headers = this;
        synchronized (headers) {
            return this.headers.isEmpty();
        }
    }

    public boolean containsKey(String s2) {
        return this.headers.containsKey(s2);
    }

    @Override
    public Iterator<String> iterator() {
        return this.headers.keySet().iterator();
    }

    public void dumpHeaders(OutputStream outputStream) throws IOException {
        Iterator<String> iterator = this.headersAsPresented.iterator();
        while (iterator.hasNext()) {
            outputStream.write(Strings.toUTF8ByteArray(iterator.next().toString()));
            outputStream.write(13);
            outputStream.write(10);
        }
    }

    private class KV {
        public final String key;
        public final String value;

        public KV(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public KV(KV kv) {
            this.key = kv.key;
            this.value = kv.value;
        }
    }
}

