/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.mime;

import com.aspose.html.internal.ms.core.bc.mime.BoundaryLimitedInputStream;
import com.aspose.html.internal.ms.core.bc.mime.Headers;
import com.aspose.html.internal.ms.core.bc.mime.LineReader;
import com.aspose.html.internal.ms.core.bc.mime.MimeContext;
import com.aspose.html.internal.ms.core.bc.mime.MimeMultipartContext;
import com.aspose.html.internal.ms.core.bc.mime.MimeParser;
import com.aspose.html.internal.ms.core.bc.mime.MimeParserContext;
import com.aspose.html.internal.ms.core.bc.mime.MimeParserListener;
import com.aspose.html.internal.ms.core.bc.mime.encoding.Base64InputStream;
import com.aspose.html.internal.ms.core.bc.mime.encoding.QuotedPrintableInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BasicMimeParser
implements MimeParser {
    private final InputStream src;
    private final MimeParserContext parserContext;
    private final String defaultContentTransferEncoding;
    private Headers headers;
    private boolean isMultipart = false;
    private final String boundary;

    public BasicMimeParser(InputStream src) throws IOException {
        this(null, new Headers(src, "7bit"), src);
    }

    public BasicMimeParser(MimeParserContext parserContext, InputStream src) throws IOException {
        this(parserContext, new Headers(src, parserContext.getDefaultContentTransferEncoding()), src);
    }

    public BasicMimeParser(Headers headers, InputStream content) {
        this(null, headers, content);
    }

    public BasicMimeParser(MimeParserContext parserContext, Headers headers, InputStream src) {
        if (headers.isMultipart()) {
            this.isMultipart = true;
            this.boundary = headers.getBoundary();
        } else {
            this.boundary = null;
        }
        this.headers = headers;
        this.parserContext = parserContext;
        this.src = src;
        this.defaultContentTransferEncoding = parserContext != null ? parserContext.getDefaultContentTransferEncoding() : "7bit";
    }

    public void parse(MimeParserListener listener) throws IOException {
        MimeContext mimeContext = listener.createContext(this.parserContext, this.headers);
        if (this.isMultipart) {
            String string;
            MimeMultipartContext mimeMultipartContext = (MimeMultipartContext)mimeContext;
            String string2 = "--" + this.boundary;
            boolean bl2 = false;
            int n2 = 0;
            LineReader lineReader = new LineReader(this.src);
            while ((string = lineReader.readLine()) != null && !"--".equals(string)) {
                MimeContext mimeContext2;
                Headers headers;
                InputStream inputStream;
                if (bl2) {
                    inputStream = new BoundaryLimitedInputStream(this.src, this.boundary);
                    headers = new Headers(inputStream, this.defaultContentTransferEncoding);
                    mimeContext2 = mimeMultipartContext.createContext(n2++);
                    inputStream = mimeContext2.applyContext(headers, inputStream);
                    listener.object(this.parserContext, headers, this.processStream(headers, inputStream));
                    if (inputStream.read() < 0) continue;
                    throw new IOException("MIME object not fully processed");
                }
                if (!string2.equals(string)) continue;
                bl2 = true;
                inputStream = new BoundaryLimitedInputStream(this.src, this.boundary);
                headers = new Headers(inputStream, this.defaultContentTransferEncoding);
                mimeContext2 = mimeMultipartContext.createContext(n2++);
                inputStream = mimeContext2.applyContext(headers, inputStream);
                listener.object(this.parserContext, headers, this.processStream(headers, inputStream));
                if (inputStream.read() < 0) continue;
                throw new IOException("MIME object not fully processed");
            }
        } else {
            InputStream inputStream = mimeContext.applyContext(this.headers, this.src);
            listener.object(this.parserContext, this.headers, this.processStream(this.headers, inputStream));
        }
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    private InputStream processStream(Headers headers, InputStream inputStream) {
        if (headers.getContentTransferEncoding().equals("base64")) {
            return new Base64InputStream(inputStream);
        }
        if (headers.getContentTransferEncoding().equals("quoted-printable")) {
            return new QuotedPrintableInputStream(inputStream);
        }
        return inputStream;
    }
}

