/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.math.ec;

import com.aspose.html.internal.ms.core.bc.math.ec.AbstractECMultiplier;
import com.aspose.html.internal.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.internal.ms.core.bc.math.ec.FixedPointPreCompInfo;
import com.aspose.html.internal.ms.core.bc.math.ec.FixedPointUtil;
import java.math.BigInteger;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n2 = FixedPointUtil.getCombSize(eCCurve);
        if (bigInteger.bitLength() > n2) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        int n3 = this.getWidthForCombSize(n2);
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(eCPoint, n3);
        ECPoint[] eCPointArray = fixedPointPreCompInfo.getPreComp();
        int n4 = fixedPointPreCompInfo.getWidth();
        int n5 = (n2 + n4 - 1) / n4;
        ECPoint eCPoint2 = eCCurve.getInfinity();
        int n6 = n5 * n4 - 1;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = 0;
            for (int i3 = n6 - i2; i3 >= 0; i3 -= n5) {
                n7 <<= 1;
                if (!bigInteger.testBit(i3)) continue;
                n7 |= 1;
            }
            eCPoint2 = eCPoint2.twicePlus(eCPointArray[n7]);
        }
        return eCPoint2;
    }

    protected int getWidthForCombSize(int n2) {
        return n2 > 257 ? 6 : 5;
    }
}

