/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.spec;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.iana.IANAObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.iso.ISOIECObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.nist.NISTObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.general.SecureHash;
import java.util.HashMap;
import java.util.Map;

class PrfUtils {
    private static Map<Algorithm, AlgorithmIdentifier> hmacAlgIds = new HashMap<Algorithm, AlgorithmIdentifier>();
    private static Map<Algorithm, ASN1ObjectIdentifier> digestOIDs = new HashMap<Algorithm, ASN1ObjectIdentifier>();

    PrfUtils() {
    }

    static AlgorithmIdentifier getAlgorithmIdentifier(Algorithm algorithm) {
        AlgorithmIdentifier algorithmIdentifier = hmacAlgIds.get(algorithm);
        if (algorithmIdentifier == null) {
            throw new IllegalArgumentException("Unknown PRF requested: " + algorithm.getName());
        }
        return algorithmIdentifier;
    }

    public static ASN1ObjectIdentifier getObjectIdentifier(Algorithm algorithm) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = digestOIDs.get(algorithm);
        if (aSN1ObjectIdentifier == null) {
            throw new IllegalArgumentException("Unrecognized digest requested: " + algorithm.getName());
        }
        return aSN1ObjectIdentifier;
    }

    static {
        hmacAlgIds.put(FipsSHS.Algorithm.SHA1_HMAC, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE));
        hmacAlgIds.put(FipsSHS.Algorithm.SHA224_HMAC, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA224, DERNull.INSTANCE));
        hmacAlgIds.put(FipsSHS.Algorithm.SHA256_HMAC, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256, DERNull.INSTANCE));
        hmacAlgIds.put(FipsSHS.Algorithm.SHA384_HMAC, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA384, DERNull.INSTANCE));
        hmacAlgIds.put(FipsSHS.Algorithm.SHA512_HMAC, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE));
        hmacAlgIds.put(SecureHash.Algorithm.GOST3411_HMAC, new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3411Hmac, DERNull.INSTANCE));
        hmacAlgIds.put(SecureHash.Algorithm.RIPEMD160_HMAC, new AlgorithmIdentifier(IANAObjectIdentifiers.hmacRIPEMD160, DERNull.INSTANCE));
        hmacAlgIds.put(SecureHash.Algorithm.TIGER_HMAC, new AlgorithmIdentifier(IANAObjectIdentifiers.hmacTIGER, DERNull.INSTANCE));
        digestOIDs.put(FipsSHS.Algorithm.SHA1, OIWObjectIdentifiers.idSHA1);
        digestOIDs.put(FipsSHS.Algorithm.SHA224, NISTObjectIdentifiers.id_sha224);
        digestOIDs.put(FipsSHS.Algorithm.SHA256, NISTObjectIdentifiers.id_sha256);
        digestOIDs.put(FipsSHS.Algorithm.SHA384, NISTObjectIdentifiers.id_sha384);
        digestOIDs.put(FipsSHS.Algorithm.SHA512, NISTObjectIdentifiers.id_sha512);
        digestOIDs.put(SecureHash.Algorithm.RIPEMD160, TeleTrusTObjectIdentifiers.ripemd160);
        digestOIDs.put(SecureHash.Algorithm.RIPEMD256, TeleTrusTObjectIdentifiers.ripemd256);
        digestOIDs.put(SecureHash.Algorithm.WHIRLPOOL, ISOIECObjectIdentifiers.whirlpool);
    }
}

