/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSecureRandom;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AsymmetricAlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Pack;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "com.aspose.html.internal.ms.core.bc.jcajce.provider.random.";

    ProvRandom() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.DEFAULT", "com.aspose.html.internal.ms.core.bc.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            public Object createInstance(Object object) {
                final SecureRandom secureRandom = bouncyCastleFipsProvider.getDefaultSecureRandom();
                return new SecureRandomSpi(){

                    protected void engineSetSeed(byte[] byArray) {
                        secureRandom.setSeed(byArray);
                    }

                    protected void engineNextBytes(byte[] byArray) {
                        secureRandom.nextBytes(byArray);
                    }

                    protected byte[] engineGenerateSeed(int n2) {
                        return secureRandom.generateSeed(n2);
                    }
                };
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "com.aspose.html.internal.ms.core.bc.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(){

            public Object createInstance(Object object) {
                SecureRandom secureRandom = bouncyCastleFipsProvider.getDefaultEntropySource();
                final FipsSecureRandom fipsSecureRandom = bouncyCastleFipsProvider.getProviderDefaultRandomBuilder().fromEntropySource(secureRandom, true).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(secureRandom.generateSeed(bouncyCastleFipsProvider.getProviderDefaultSecurityStrength() / 16 + 1), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV"));
                return new SecureRandomSpi(){

                    protected void engineSetSeed(byte[] byArray) {
                        fipsSecureRandom.setSeed(byArray);
                    }

                    protected void engineNextBytes(byte[] byArray) {
                        fipsSecureRandom.nextBytes(byArray);
                    }

                    protected byte[] engineGenerateSeed(int n2) {
                        return fipsSecureRandom.generateSeed(n2);
                    }
                };
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }
}

