/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricDSAPrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.DSAUtils;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvKey;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvDSAPrivateKey
implements ProvKey<AsymmetricDSAPrivateKey>,
DSAPrivateKey {
    private static final long serialVersionUID = -4677259546958385734L;
    private transient AsymmetricDSAPrivateKey baseKey;

    ProvDSAPrivateKey(Algorithm algorithm, DSAPrivateKey dSAPrivateKey) {
        this.baseKey = new AsymmetricDSAPrivateKey(algorithm, DSAUtils.extractParams(dSAPrivateKey.getParams()), dSAPrivateKey.getX());
    }

    ProvDSAPrivateKey(Algorithm algorithm, DSAPrivateKeySpec dSAPrivateKeySpec) {
        this.baseKey = new AsymmetricDSAPrivateKey(algorithm, DSAUtils.extractParams(dSAPrivateKeySpec), dSAPrivateKeySpec.getX());
    }

    ProvDSAPrivateKey(AsymmetricDSAPrivateKey asymmetricDSAPrivateKey) {
        this.baseKey = asymmetricDSAPrivateKey;
    }

    @Override
    public BigInteger getX() {
        return this.baseKey.getX();
    }

    @Override
    public DSAParams getParams() {
        return DSAUtils.convertParams(this.baseKey.getDomainParameters());
    }

    @Override
    public AsymmetricDSAPrivateKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("DSA Private Key").append(string);
        try {
            stringBuilder.append("    X: ").append(this.getX().toString(16)).append(string);
        }
        catch (Exception exception) {
            stringBuilder.append("RESTRICTED").append(string);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvDSAPrivateKey)) {
            return false;
        }
        ProvDSAPrivateKey provDSAPrivateKey = (ProvDSAPrivateKey)object;
        return this.baseKey.equals(provDSAPrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricDSAPrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

