/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricDHPrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.DHUtils;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;

class ProvDHPrivateKey
implements DHPrivateKey {
    static final long serialVersionUID = 311058815616901812L;
    private transient AsymmetricDHPrivateKey baseKey;

    ProvDHPrivateKey(Algorithm algorithm, DHPrivateKey dHPrivateKey) {
        this.baseKey = new AsymmetricDHPrivateKey(algorithm, DHUtils.extractParams(dHPrivateKey.getParams()), dHPrivateKey.getX());
    }

    ProvDHPrivateKey(Algorithm algorithm, DHPrivateKeySpec dHPrivateKeySpec) {
        this.baseKey = new AsymmetricDHPrivateKey(algorithm, DHUtils.extractParams(dHPrivateKeySpec), dHPrivateKeySpec.getX());
    }

    ProvDHPrivateKey(AsymmetricDHPrivateKey asymmetricDHPrivateKey) {
        this.baseKey = asymmetricDHPrivateKey;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public DHParameterSpec getParams() {
        return DHUtils.convertParams(this.baseKey.getDomainParameters());
    }

    public BigInteger getX() {
        return this.baseKey.getX();
    }

    AsymmetricDHPrivateKey getBaseKey() {
        return this.baseKey;
    }

    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("DH Private Key").append(string);
        try {
            stringBuilder.append("    X: ").append(this.getX().toString(16)).append(string);
        }
        catch (Exception exception) {
            stringBuilder.append("RESTRICTED").append(string);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvDHPrivateKey)) {
            return false;
        }
        ProvDHPrivateKey provDHPrivateKey = (ProvDHPrivateKey)object;
        return this.baseKey.equals(provDHPrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricDHPrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

