/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.kisa.KISAObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.misc.MiscObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.nist.NISTObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.ntt.NTTObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.util.Integers;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class KeyIvSizeProvider {
    private final Map KEY_SIZES;

    KeyIvSizeProvider() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put(MiscObjectIdentifiers.cast5CBC.getId(), Integers.valueOf(16));
        hashMap.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), Integers.valueOf(24));
        hashMap.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), Integers.valueOf(24));
        hashMap.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), Integers.valueOf(24));
        hashMap.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), Integers.valueOf(16));
        hashMap.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), Integers.valueOf(24));
        hashMap.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), Integers.valueOf(32));
        hashMap.put(NISTObjectIdentifiers.id_aes128_GCM.getId(), Integers.valueOf(16));
        hashMap.put(NISTObjectIdentifiers.id_aes192_GCM.getId(), Integers.valueOf(24));
        hashMap.put(NISTObjectIdentifiers.id_aes256_GCM.getId(), Integers.valueOf(32));
        hashMap.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), Integers.valueOf(16));
        hashMap.put(NISTObjectIdentifiers.id_aes192_CCM.getId(), Integers.valueOf(24));
        hashMap.put(NISTObjectIdentifiers.id_aes256_CCM.getId(), Integers.valueOf(32));
        hashMap.put(NISTObjectIdentifiers.id_aes128_CFB.getId(), Integers.valueOf(16));
        hashMap.put(NISTObjectIdentifiers.id_aes192_CFB.getId(), Integers.valueOf(24));
        hashMap.put(NISTObjectIdentifiers.id_aes256_CFB.getId(), Integers.valueOf(32));
        hashMap.put(NISTObjectIdentifiers.id_aes128_OFB.getId(), Integers.valueOf(16));
        hashMap.put(NISTObjectIdentifiers.id_aes192_OFB.getId(), Integers.valueOf(24));
        hashMap.put(NISTObjectIdentifiers.id_aes256_OFB.getId(), Integers.valueOf(32));
        hashMap.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), Integers.valueOf(16));
        hashMap.put(NISTObjectIdentifiers.id_aes192_wrap.getId(), Integers.valueOf(24));
        hashMap.put(NISTObjectIdentifiers.id_aes256_wrap.getId(), Integers.valueOf(32));
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA1.getId(), Integers.valueOf(20));
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA224.getId(), Integers.valueOf(28));
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA256.getId(), Integers.valueOf(32));
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA384.getId(), Integers.valueOf(48));
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA512.getId(), Integers.valueOf(64));
        hashMap.put(NTTObjectIdentifiers.id_camellia128_cbc.getId(), Integers.valueOf(16));
        hashMap.put(NTTObjectIdentifiers.id_camellia192_cbc.getId(), Integers.valueOf(24));
        hashMap.put(NTTObjectIdentifiers.id_camellia256_cbc.getId(), Integers.valueOf(32));
        hashMap.put(NTTObjectIdentifiers.id_camellia128_wrap.getId(), Integers.valueOf(16));
        hashMap.put(NTTObjectIdentifiers.id_camellia192_wrap.getId(), Integers.valueOf(24));
        hashMap.put(NTTObjectIdentifiers.id_camellia256_wrap.getId(), Integers.valueOf(32));
        hashMap.put(KISAObjectIdentifiers.id_seedCBC.getId(), Integers.valueOf(16));
        hashMap.put(KISAObjectIdentifiers.id_seedMAC.getId(), Integers.valueOf(16));
        hashMap.put(OIWObjectIdentifiers.desCBC.getId(), Integers.valueOf(8));
        hashMap.put(CryptoProObjectIdentifiers.gostR28147_gcfb.getId(), Integers.valueOf(32));
        hashMap.put(CryptoProObjectIdentifiers.gostR3411Hmac.getId(), Integers.valueOf(32));
        hashMap.put(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC.getId(), Integers.valueOf(16));
        hashMap.put(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC.getId(), Integers.valueOf(24));
        hashMap.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC.getId(), Integers.valueOf(16));
        hashMap.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4.getId(), Integers.valueOf(16));
        hashMap.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC.getId(), Integers.valueOf(5));
        this.KEY_SIZES = Collections.unmodifiableMap(hashMap);
    }

    public int getKeySize(String string) {
        Integer n2 = (Integer)this.KEY_SIZES.get(string);
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    public int getKeySize(AlgorithmIdentifier algorithmIdentifier) {
        Integer n2 = (Integer)this.KEY_SIZES.get(algorithmIdentifier.getAlgorithm().getId());
        if (n2 != null) {
            return n2;
        }
        return -1;
    }
}

