/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est.jcajce;

import com.aspose.html.internal.ms.core.bc.est.ESTClientSourceProvider;
import com.aspose.html.internal.ms.core.bc.est.Source;
import com.aspose.html.internal.ms.core.bc.est.jcajce.ChannelBindingProvider;
import com.aspose.html.internal.ms.core.bc.est.jcajce.JsseHostnameAuthorizer;
import com.aspose.html.internal.ms.core.bc.est.jcajce.LimitedSSLSocketSource;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultESTClientSourceProvider
implements ESTClientSourceProvider {
    private final SSLSocketFactory sslSocketFactory;
    private final JsseHostnameAuthorizer hostNameAuthorizer;
    private final int timeout;
    private final ChannelBindingProvider bindingProvider;
    private final Set<String> cipherSuites;
    private final Long absoluteLimit;
    private final boolean filterSupportedSuites;

    public DefaultESTClientSourceProvider(SSLSocketFactory socketFactory, JsseHostnameAuthorizer hostNameAuthorizer, int timeout, ChannelBindingProvider bindingProvider, Set<String> cipherSuites, Long absoluteLimit, boolean filterSupportedSuites) throws GeneralSecurityException {
        this.sslSocketFactory = socketFactory;
        this.hostNameAuthorizer = hostNameAuthorizer;
        this.timeout = timeout;
        this.bindingProvider = bindingProvider;
        this.cipherSuites = cipherSuites;
        this.absoluteLimit = absoluteLimit;
        this.filterSupportedSuites = filterSupportedSuites;
    }

    @Override
    public Source makeSource(String host, int port) throws IOException {
        Object object;
        SSLSocket sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket(host, port);
        sSLSocket.setSoTimeout(this.timeout);
        if (this.cipherSuites != null && !this.cipherSuites.isEmpty()) {
            if (this.filterSupportedSuites) {
                object = new HashSet();
                String[] stringArray = sSLSocket.getSupportedCipherSuites();
                for (int i2 = 0; i2 != stringArray.length; ++i2) {
                    ((HashSet)object).add(stringArray[i2]);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : this.cipherSuites) {
                    if (!((HashSet)object).contains(string)) continue;
                    arrayList.add(string);
                }
                if (arrayList.isEmpty()) {
                    throw new IllegalStateException("No supplied cipher suite is supported by the provider.");
                }
                sSLSocket.setEnabledCipherSuites(arrayList.toArray(new String[arrayList.size()]));
            } else {
                sSLSocket.setEnabledCipherSuites(this.cipherSuites.toArray(new String[this.cipherSuites.size()]));
            }
        }
        sSLSocket.startHandshake();
        if (this.hostNameAuthorizer != null && !this.hostNameAuthorizer.verified(host, sSLSocket.getSession())) {
            throw new IOException("Host name could not be verified.");
        }
        object = Strings.toLowerCase(sSLSocket.getSession().getCipherSuite());
        if (((String)object).contains("_des_") || ((String)object).contains("_des40_") || ((String)object).contains("_3des_")) {
            throw new IOException("EST clients must not use DES ciphers");
        }
        if (Strings.toLowerCase(sSLSocket.getSession().getCipherSuite()).contains("null")) {
            throw new IOException("EST clients must not use NULL ciphers");
        }
        if (Strings.toLowerCase(sSLSocket.getSession().getCipherSuite()).contains("anon")) {
            throw new IOException("EST clients must not use anon ciphers");
        }
        if (Strings.toLowerCase(sSLSocket.getSession().getCipherSuite()).contains("export")) {
            throw new IOException("EST clients must not use export ciphers");
        }
        if (sSLSocket.getSession().getProtocol().equalsIgnoreCase("tlsv1")) {
            try {
                sSLSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("EST clients must not use TLSv1");
        }
        if (this.hostNameAuthorizer != null && !this.hostNameAuthorizer.verified(host, sSLSocket.getSession())) {
            throw new IOException("Hostname was not verified: " + host);
        }
        return new LimitedSSLSocketSource(sSLSocket, this.bindingProvider, this.absoluteLimit);
    }
}

