/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1InputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERPrintableString;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ContentInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cmc.CMCException;
import com.aspose.html.internal.ms.core.bc.cmc.SimplePKIResponse;
import com.aspose.html.internal.ms.core.bc.est.CACertsResponse;
import com.aspose.html.internal.ms.core.bc.est.CSRAttributesResponse;
import com.aspose.html.internal.ms.core.bc.est.CSRRequestResponse;
import com.aspose.html.internal.ms.core.bc.est.CsrAttrs;
import com.aspose.html.internal.ms.core.bc.est.ESTAuth;
import com.aspose.html.internal.ms.core.bc.est.ESTClient;
import com.aspose.html.internal.ms.core.bc.est.ESTClientProvider;
import com.aspose.html.internal.ms.core.bc.est.ESTException;
import com.aspose.html.internal.ms.core.bc.est.ESTRequest;
import com.aspose.html.internal.ms.core.bc.est.ESTRequestBuilder;
import com.aspose.html.internal.ms.core.bc.est.ESTResponse;
import com.aspose.html.internal.ms.core.bc.est.ESTSourceConnectionListener;
import com.aspose.html.internal.ms.core.bc.est.EnrollmentResponse;
import com.aspose.html.internal.ms.core.bc.est.Source;
import com.aspose.html.internal.ms.core.bc.est.TLSUniqueProvider;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS10CertificationRequest;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS10CertificationRequestBuilder;
import com.aspose.html.internal.ms.core.bc.util.Selector;
import com.aspose.html.internal.ms.core.bc.util.Store;
import com.aspose.html.internal.ms.core.bc.util.encoders.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESTService {
    protected static final String CACERTS = "/cacerts";
    protected static final String SIMPLE_ENROLL = "/simpleenroll";
    protected static final String SIMPLE_REENROLL = "/simplereenroll";
    protected static final String FULLCMC = "/fullcmc";
    protected static final String SERVERGEN = "/serverkeygen";
    protected static final String CSRATTRS = "/csrattrs";
    protected static final Set<String> illegalParts = new HashSet<String>();
    private final String server;
    private final ESTClientProvider clientProvider;
    private static final Pattern pathInvalid;

    ESTService(String serverAuthority, String label, ESTClientProvider clientProvider) {
        serverAuthority = this.verifyServer(serverAuthority);
        if (label != null) {
            label = this.verifyLabel(label);
            this.server = "https://" + serverAuthority + "/.well-known/est/" + label;
        } else {
            this.server = "https://" + serverAuthority + "/.well-known/est";
        }
        this.clientProvider = clientProvider;
    }

    public static X509CertificateHolder[] storeToArray(Store<X509CertificateHolder> store) {
        return ESTService.storeToArray(store, null);
    }

    public static X509CertificateHolder[] storeToArray(Store<X509CertificateHolder> store, Selector<X509CertificateHolder> selector) {
        Collection<X509CertificateHolder> collection = store.getMatches(selector);
        return collection.toArray(new X509CertificateHolder[collection.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public CACertsResponse getCACerts() throws Exception {
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = false;
        try {
            var4_4 = new URL(this.server + "/cacerts");
            var6_6 = this.clientProvider.makeClient();
            var7_9 = new ESTRequestBuilder("GET", var4_4).withClient(var6_6).build();
            var1_1 = var6_6.doRequest(var7_9);
            var8_10 = null;
            var9_11 = null;
            if (var1_1.getStatusCode() == 200) {
                if (!"application/pkcs7-mime".equals(var1_1.getHeaders().getFirstValue("Content-Type"))) {
                    var10_12 = var1_1.getHeaders().getFirstValue("Content-Type") != null ? " got " + var1_1.getHeaders().getFirstValue("Content-Type") : " but was not present.";
                    throw new ESTException("Response : " + var4_4.toString() + "Expecting application/pkcs7-mime " + var10_12, null, var1_1.getStatusCode(), var1_1.getInputStream());
                }
                try {
                    if (var1_1.getContentLength() == null || var1_1.getContentLength() <= 0L) ** GOTO lbl28
                    var10_13 = new ASN1InputStream(var1_1.getInputStream());
                    var11_15 = new SimplePKIResponse(ContentInfo.getInstance((ASN1Sequence)var10_13.readObject()));
                    var8_10 = var11_15.getCertificates();
                    var9_11 = var11_15.getCRLs();
                }
                catch (Throwable var10_14) {
                    throw new ESTException("Decoding CACerts: " + var4_4.toString() + " " + var10_14.getMessage(), var10_14, var1_1.getStatusCode(), var1_1.getInputStream());
                }
            } else if (var1_1.getStatusCode() != 204) {
                throw new ESTException("Get CACerts: " + var4_4.toString(), null, var1_1.getStatusCode(), var1_1.getInputStream());
            }
lbl28:
            // 4 sources

            var3_3 = new CACertsResponse(var8_10, var9_11, var7_9, var1_1.getSource(), this.clientProvider.isTrusted());
        }
        catch (Throwable var6_8) {
            var5_5 = true;
            if (var6_8 instanceof ESTException) {
                throw (ESTException)var6_8;
            }
            throw new ESTException(var6_8.getMessage(), var6_8);
        }
        finally {
            if (var1_1 != null) {
                try {
                    var1_1.close();
                }
                catch (Exception var6_7) {
                    var2_2 = var6_7;
                }
            }
        }
        if (var2_2 != null) {
            if (var2_2 instanceof ESTException) {
                throw var2_2;
            }
            throw new ESTException("Get CACerts: " + var4_4.toString(), (Throwable)var2_2, var1_1.getStatusCode(), null);
        }
        return var3_3;
    }

    public EnrollmentResponse simpleEnroll(EnrollmentResponse priorResponse) throws Exception {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        ESTResponse eSTResponse = null;
        try {
            ESTClient eSTClient = this.clientProvider.makeClient();
            eSTResponse = eSTClient.doRequest(new ESTRequestBuilder(priorResponse.getRequestToRetry()).withClient(eSTClient).build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(eSTResponse);
            return enrollmentResponse;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ESTException) {
                throw (ESTException)throwable;
            }
            throw new ESTException(throwable.getMessage(), throwable);
        }
        finally {
            if (eSTResponse != null) {
                eSTResponse.close();
            }
        }
    }

    public EnrollmentResponse simpleEnroll(boolean reenroll, PKCS10CertificationRequest certificationRequest, ESTAuth auth) throws IOException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        ESTResponse eSTResponse = null;
        try {
            byte[] byArray = this.annotateRequest(certificationRequest.getEncoded()).getBytes();
            URL uRL = new URL(this.server + (reenroll ? SIMPLE_REENROLL : SIMPLE_ENROLL));
            ESTClient eSTClient = this.clientProvider.makeClient();
            ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder("POST", uRL).withData(byArray).withClient(eSTClient);
            eSTRequestBuilder.addHeader("Content-Type", "application/pkcs10");
            eSTRequestBuilder.addHeader("Content-Length", "" + byArray.length);
            eSTRequestBuilder.addHeader("Content-Transfer-Encoding", "base64");
            if (auth != null) {
                auth.applyAuth(eSTRequestBuilder);
            }
            eSTResponse = eSTClient.doRequest(eSTRequestBuilder.build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(eSTResponse);
            return enrollmentResponse;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ESTException) {
                throw (ESTException)throwable;
            }
            throw new ESTException(throwable.getMessage(), throwable);
        }
        finally {
            if (eSTResponse != null) {
                eSTResponse.close();
            }
        }
    }

    public EnrollmentResponse simpleEnrollPoP(boolean reEnroll, final PKCS10CertificationRequestBuilder builder, final ContentSigner contentSigner, ESTAuth auth) throws IOException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        ESTResponse eSTResponse = null;
        try {
            URL uRL = new URL(this.server + (reEnroll ? SIMPLE_REENROLL : SIMPLE_ENROLL));
            ESTClient eSTClient = this.clientProvider.makeClient();
            ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder("POST", uRL).withClient(eSTClient).withConnectionListener(new ESTSourceConnectionListener(){

                public ESTRequest onConnection(Source source, ESTRequest request) throws IOException {
                    if (source instanceof TLSUniqueProvider && ((TLSUniqueProvider)((Object)source)).isTLSUniqueAvailable()) {
                        PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder = new PKCS10CertificationRequestBuilder(builder);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = ((TLSUniqueProvider)((Object)source)).getTLSUnique();
                        pKCS10CertificationRequestBuilder.setAttribute(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, new DERPrintableString(Base64.toBase64String(byArray)));
                        byteArrayOutputStream.write(ESTService.this.annotateRequest(pKCS10CertificationRequestBuilder.build(contentSigner).getEncoded()).getBytes());
                        byteArrayOutputStream.flush();
                        ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder(request).withData(byteArrayOutputStream.toByteArray());
                        eSTRequestBuilder.setHeader("Content-Type", "application/pkcs10");
                        eSTRequestBuilder.setHeader("Content-Transfer-Encoding", "base64");
                        eSTRequestBuilder.setHeader("Content-Length", Long.toString(byteArrayOutputStream.size()));
                        return eSTRequestBuilder.build();
                    }
                    throw new IOException("Source does not supply TLS unique.");
                }
            });
            if (auth != null) {
                auth.applyAuth(eSTRequestBuilder);
            }
            eSTResponse = eSTClient.doRequest(eSTRequestBuilder.build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(eSTResponse);
            return enrollmentResponse;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ESTException) {
                throw (ESTException)throwable;
            }
            throw new ESTException(throwable.getMessage(), throwable);
        }
        finally {
            if (eSTResponse != null) {
                eSTResponse.close();
            }
        }
    }

    protected EnrollmentResponse handleEnrollResponse(ESTResponse resp) throws IOException {
        ESTRequest eSTRequest = resp.getOriginalRequest();
        Store<X509CertificateHolder> store = null;
        if (resp.getStatusCode() == 202) {
            String string = resp.getHeader("Retry-After");
            if (string == null) {
                throw new ESTException("Got Status 202 but not Retry-After header from: " + eSTRequest.getURL().toString());
            }
            long l2 = -1L;
            try {
                l2 = System.currentTimeMillis() + Long.parseLong(string) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    l2 = simpleDateFormat.parse(string).getTime();
                }
                catch (Exception exception) {
                    throw new ESTException("Unable to parse Retry-After header:" + eSTRequest.getURL().toString() + " " + exception.getMessage(), null, resp.getStatusCode(), resp.getInputStream());
                }
            }
            return new EnrollmentResponse(null, l2, eSTRequest, resp.getSource());
        }
        if (resp.getStatusCode() == 200) {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(resp.getInputStream());
            SimplePKIResponse simplePKIResponse = null;
            try {
                simplePKIResponse = new SimplePKIResponse(ContentInfo.getInstance(aSN1InputStream.readObject()));
            }
            catch (CMCException cMCException) {
                throw new ESTException(cMCException.getMessage(), cMCException.getCause());
            }
            store = simplePKIResponse.getCertificates();
            return new EnrollmentResponse(store, -1L, null, resp.getSource());
        }
        throw new ESTException("Simple Enroll: " + eSTRequest.getURL().toString(), null, resp.getStatusCode(), resp.getInputStream());
    }

    /*
     * Unable to fully structure code
     */
    public CSRRequestResponse getCSRAttributes() throws ESTException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        try {
            var4_4 = new URL(this.server + "/csrattrs");
            var5_5 = this.clientProvider.makeClient();
            var6_8 = new ESTRequestBuilder("GET", var4_4).withClient(var5_5).build();
            var1_1 = var5_5.doRequest(var6_8);
            switch (var1_1.getStatusCode()) {
                case 200: {
                    try {
                        if (var1_1.getContentLength() != null && var1_1.getContentLength() > 0L) {
                            var7_9 = new ASN1InputStream(var1_1.getInputStream());
                            var8_11 = (ASN1Sequence)var7_9.readObject();
                            var2_2 = new CSRAttributesResponse(CsrAttrs.getInstance(var8_11));
                            ** break;
                        }
lbl20:
                        // 3 sources

                        break;
                    }
                    catch (Throwable var7_10) {
                        throw new ESTException("Decoding CACerts: " + var4_4.toString() + " " + var7_10.getMessage(), var7_10, var1_1.getStatusCode(), var1_1.getInputStream());
                    }
                }
                case 204: {
                    var2_2 = null;
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 404: {
                    var2_2 = null;
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                default: {
                    throw new ESTException("CSR Attribute request: " + var6_8.getURL().toString(), null, var1_1.getStatusCode(), var1_1.getInputStream());
                }
            }
        }
        catch (Throwable var5_7) {
            if (var5_7 instanceof ESTException) {
                throw (ESTException)var5_7;
            }
            throw new ESTException(var5_7.getMessage(), var5_7);
        }
        finally {
            if (var1_1 != null) {
                try {
                    var1_1.close();
                }
                catch (Exception var5_6) {
                    var3_3 = var5_6;
                }
            }
        }
        if (var3_3 != null) {
            if (var3_3 instanceof ESTException) {
                throw (ESTException)var3_3;
            }
            throw new ESTException(var3_3.getMessage(), (Throwable)var3_3, var1_1.getStatusCode(), null);
        }
        return new CSRRequestResponse(var2_2, var1_1.getSource());
    }

    private String annotateRequest(byte[] data) {
        int n2 = 0;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        do {
            if (n2 + 48 < data.length) {
                printWriter.print(Base64.toBase64String(data, n2, 48));
                n2 += 48;
            } else {
                printWriter.print(Base64.toBase64String(data, n2, data.length - n2));
                n2 = data.length;
            }
            printWriter.print('\n');
        } while (n2 < data.length);
        printWriter.flush();
        return stringWriter.toString();
    }

    private String verifyLabel(String label) {
        while (label.endsWith("/") && label.length() > 0) {
            label = label.substring(0, label.length() - 1);
        }
        while (label.startsWith("/") && label.length() > 0) {
            label = label.substring(1);
        }
        if (label.length() == 0) {
            throw new IllegalArgumentException("Label set but after trimming '/' is not zero length string.");
        }
        if (!pathInvalid.matcher(label).matches()) {
            throw new IllegalArgumentException("Server path " + label + " contains invalid characters");
        }
        if (illegalParts.contains(label)) {
            throw new IllegalArgumentException("Label " + label + " is a reserved path segment.");
        }
        return label;
    }

    private String verifyServer(String server) {
        try {
            while (server.endsWith("/") && server.length() > 0) {
                server = server.substring(0, server.length() - 1);
            }
            if (server.contains("://")) {
                throw new IllegalArgumentException("Server contains scheme, must only be <dnsname/ipaddress>:port, https:// will be added arbitrarily.");
            }
            URL uRL = new URL("https://" + server);
            if (uRL.getPath().length() == 0 || uRL.getPath().equals("/")) {
                return server;
            }
            throw new IllegalArgumentException("Server contains path, must only be <dnsname/ipaddress>:port, a path of '/.well-known/est/<label>' will be added arbitrarily.");
        }
        catch (Exception exception) {
            if (exception instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)exception;
            }
            throw new IllegalArgumentException("Scheme and host is invalid: " + exception.getMessage(), exception);
        }
    }

    static {
        illegalParts.add(CACERTS.substring(1));
        illegalParts.add(SIMPLE_ENROLL.substring(1));
        illegalParts.add(SIMPLE_REENROLL.substring(1));
        illegalParts.add(FULLCMC.substring(1));
        illegalParts.add(SERVERGEN.substring(1));
        illegalParts.add(CSRATTRS.substring(1));
        pathInvalid = Pattern.compile("^[0-9a-zA-Z_\\-.~!$&'()*+,;=]+");
    }
}

