/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est;

import com.aspose.html.internal.ms.core.bc.util.encoders.Base64Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CTEBase64InputStream
extends InputStream {
    private final Base64Encoder base64Encoder = new Base64Encoder();
    protected final InputStream src;
    protected final byte[] rawBuf = new byte[1024];
    protected final byte[] data = new byte[768];
    protected final OutputStream dataOutputStream;
    protected final Long max;
    protected int rp;
    protected int wp;
    protected boolean end;
    protected long read;

    public CTEBase64InputStream(InputStream src, Long limit) {
        this.src = src;
        this.dataOutputStream = new OutputStream(){

            public void write(int b2) throws IOException {
                CTEBase64InputStream.this.data[CTEBase64InputStream.this.wp++] = (byte)b2;
            }
        };
        this.max = limit;
    }

    protected int pullFromSrc() throws IOException {
        if (this.read >= this.max) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n2 = this.src.read()) >= 33 || n2 == 13 || n2 == 10) {
                if (n3 >= this.rawBuf.length) {
                    throw new IOException("Content Transfer Encoding, base64 line length > 1024");
                }
                this.rawBuf[n3++] = (byte)n2;
                ++this.read;
                continue;
            }
            if (n2 < 0) continue;
            ++this.read;
        } while (n2 > -1 && n3 < this.rawBuf.length && n2 != 10 && this.read < this.max);
        if (n3 > 0) {
            try {
                this.base64Encoder.decode(this.rawBuf, 0, n3, this.dataOutputStream);
            }
            catch (Exception exception) {
                throw new IOException("Decode Base64 Content-Transfer-Encoding: " + exception);
            }
        } else if (n2 == -1) {
            return -1;
        }
        return this.wp;
    }

    public int read() throws IOException {
        if (this.rp == this.wp) {
            this.rp = 0;
            this.wp = 0;
            int n2 = this.pullFromSrc();
            if (n2 == -1) {
                return n2;
            }
        }
        return this.data[this.rp++] & 0xFF;
    }

    public void close() throws IOException {
        this.src.close();
    }
}

