/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.eac.operator.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.eac.EACObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.eac.operator.EACSigner;
import com.aspose.html.internal.ms.core.bc.eac.operator.jcajce.DefaultEACHelper;
import com.aspose.html.internal.ms.core.bc.eac.operator.jcajce.EACHelper;
import com.aspose.html.internal.ms.core.bc.eac.operator.jcajce.NamedEACHelper;
import com.aspose.html.internal.ms.core.bc.eac.operator.jcajce.ProviderEACHelper;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.operator.OperatorStreamException;
import com.aspose.html.internal.ms.core.bc.operator.RuntimeOperatorException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Hashtable;

public class JcaEACSignerBuilder {
    private static final Hashtable sigNames = new Hashtable();
    private EACHelper helper = new DefaultEACHelper();

    public JcaEACSignerBuilder setProvider(String providerName) {
        this.helper = new NamedEACHelper(providerName);
        return this;
    }

    public JcaEACSignerBuilder setProvider(Provider provider) {
        this.helper = new ProviderEACHelper(provider);
        return this;
    }

    public EACSigner build(String algorithm, PrivateKey privKey) throws OperatorCreationException {
        return this.build((ASN1ObjectIdentifier)sigNames.get(algorithm), privKey);
    }

    public EACSigner build(final ASN1ObjectIdentifier usageOid, PrivateKey privKey) throws OperatorCreationException {
        Signature signature;
        try {
            signature = this.helper.getSignature(usageOid);
            signature.initSign(privKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OperatorCreationException("unable to find algorithm: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new OperatorCreationException("unable to find provider: " + noSuchProviderException.getMessage(), noSuchProviderException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new OperatorCreationException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        final SignatureOutputStream signatureOutputStream = new SignatureOutputStream(signature);
        return new EACSigner(){

            public ASN1ObjectIdentifier getUsageIdentifier() {
                return usageOid;
            }

            public OutputStream getOutputStream() {
                return signatureOutputStream;
            }

            public byte[] getSignature() {
                try {
                    byte[] byArray = signatureOutputStream.getSignature();
                    if (usageOid.on(EACObjectIdentifiers.id_TA_ECDSA)) {
                        return JcaEACSignerBuilder.reencode(byArray);
                    }
                    return byArray;
                }
                catch (SignatureException signatureException) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
                }
            }
        };
    }

    public static int max(int el1, int el2) {
        return el1 > el2 ? el1 : el2;
    }

    private static byte[] reencode(byte[] rawSign) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(rawSign);
        BigInteger bigInteger = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue();
        BigInteger bigInteger2 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue();
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = bigInteger2.toByteArray();
        int n2 = JcaEACSignerBuilder.unsignedIntLength(byArray);
        int n3 = JcaEACSignerBuilder.unsignedIntLength(byArray2);
        int n4 = JcaEACSignerBuilder.max(n2, n3);
        byte[] byArray3 = new byte[n4 * 2];
        Arrays.fill(byArray3, (byte)0);
        JcaEACSignerBuilder.copyUnsignedInt(byArray, byArray3, n4 - n2);
        JcaEACSignerBuilder.copyUnsignedInt(byArray2, byArray3, 2 * n4 - n3);
        return byArray3;
    }

    private static int unsignedIntLength(byte[] i2) {
        int n2 = i2.length;
        if (i2[0] == 0) {
            --n2;
        }
        return n2;
    }

    private static void copyUnsignedInt(byte[] src, byte[] dst, int offset) {
        int n2 = src.length;
        int n3 = 0;
        if (src[0] == 0) {
            --n2;
            n3 = 1;
        }
        System.arraycopy(src, n3, dst, offset, n2);
    }

    static {
        sigNames.put("SHA1withRSA", EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1);
        sigNames.put("SHA256withRSA", EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256);
        sigNames.put("SHA1withRSAandMGF1", EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1);
        sigNames.put("SHA256withRSAandMGF1", EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256);
        sigNames.put("SHA512withRSA", EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_512);
        sigNames.put("SHA512withRSAandMGF1", EACObjectIdentifiers.id_TA_RSA_PSS_SHA_512);
        sigNames.put("SHA1withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_1);
        sigNames.put("SHA224withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_224);
        sigNames.put("SHA256withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_256);
        sigNames.put("SHA384withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_384);
        sigNames.put("SHA512withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_512);
    }

    private class SignatureOutputStream
    extends OutputStream {
        private Signature sig;

        SignatureOutputStream(Signature sig) {
            this.sig = sig;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.sig.update(bytes, off, len);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        public void write(byte[] bytes) throws IOException {
            try {
                this.sig.update(bytes);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        public void write(int b2) throws IOException {
            try {
                this.sig.update((byte)b2);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        byte[] getSignature() throws SignatureException {
            return this.sig.sign();
        }
    }
}

